/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogJoiner {
    private static final int BOUND_SAVED_LOG = 10000;

    @NotNull
    public Pair<List<TimedVcsCommit>, Integer> addCommits(@NotNull List<? extends TimedVcsCommit> savedLog, @NotNull Collection<VcsRef> previousRefs, @NotNull List<? extends TimedVcsCommit> firstBlock, @NotNull Collection<VcsRef> newRefs) {
        if (savedLog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner", "addCommits"));
        }
        if (previousRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogJoiner", "addCommits"));
        }
        if (firstBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/VcsLogJoiner", "addCommits"));
        }
        if (newRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/VcsLogJoiner", "addCommits"));
        }
        Set<Hash> previousRefsHashes = VcsLogJoiner.toHashes(previousRefs);
        Set<Hash> newRefsHashes = VcsLogJoiner.toHashes(newRefs);
        Pair<Integer, Set<Hash>> redCommitsAndSavedRedIndex = VcsLogJoiner.getRedCommitsAndSavedRedIndex(savedLog, previousRefsHashes, firstBlock, newRefsHashes);
        Pair<Integer, Set<TimedVcsCommit>> newCommitsAndSavedGreenIndex = VcsLogJoiner.getNewCommitsAndSavedGreenIndex(savedLog, previousRefsHashes, firstBlock, newRefsHashes);
        if ((Integer)redCommitsAndSavedRedIndex.first == -1) {
            throw new IllegalStateException();
        }
        if ((Integer)newCommitsAndSavedGreenIndex.first == -1) {
            throw new IllegalStateException();
        }
        Set removeCommits = (Set)redCommitsAndSavedRedIndex.second;
        Set allNewsCommits = (Set)newCommitsAndSavedGreenIndex.second;
        int unsafeBlockSize = Math.max((Integer)redCommitsAndSavedRedIndex.first, (Integer)newCommitsAndSavedGreenIndex.first);
        List<TimedVcsCommit> unsafePartSavedLog = new ArrayList();
        for (TimedVcsCommit timedVcsCommit : savedLog.subList(0, unsafeBlockSize)) {
            if (removeCommits.contains(timedVcsCommit.getHash())) continue;
            unsafePartSavedLog.add(timedVcsCommit);
        }
        unsafePartSavedLog = new NewCommitIntegrator(unsafePartSavedLog, allNewsCommits).getResultList();
        Pair pair = Pair.create((Object)ContainerUtil.concat(unsafePartSavedLog, savedLog.subList(unsafeBlockSize, savedLog.size())), (Object)(unsafePartSavedLog.size() - unsafeBlockSize));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogJoiner", "addCommits"));
        }
        return pair;
    }

    private static Set<Hash> toHashes(Collection<VcsRef> refs) {
        java.util.HashSet<Hash> hashes = new java.util.HashSet<Hash>(refs.size());
        for (VcsRef ref : refs) {
            hashes.add(ref.getCommitHash());
        }
        return hashes;
    }

    @NotNull
    private static Pair<Integer, Set<TimedVcsCommit>> getNewCommitsAndSavedGreenIndex(@NotNull List<? extends TimedVcsCommit> savedLog, @NotNull Collection<Hash> previousRefs, @NotNull List<? extends TimedVcsCommit> firstBlock, @NotNull Collection<Hash> newRefs) {
        if (savedLog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner", "getNewCommitsAndSavedGreenIndex"));
        }
        if (previousRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogJoiner", "getNewCommitsAndSavedGreenIndex"));
        }
        if (firstBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/VcsLogJoiner", "getNewCommitsAndSavedGreenIndex"));
        }
        if (newRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/VcsLogJoiner", "getNewCommitsAndSavedGreenIndex"));
        }
        HashSet allUnresolvedLinkedHashes = new HashSet(newRefs);
        allUnresolvedLinkedHashes.removeAll(previousRefs);
        for (TimedVcsCommit timedVcsCommit : firstBlock) {
            allUnresolvedLinkedHashes.add(timedVcsCommit.getHash());
            allUnresolvedLinkedHashes.addAll(timedVcsCommit.getParents());
        }
        for (TimedVcsCommit timedVcsCommit : firstBlock) {
            if (timedVcsCommit.getParents().size() == 0) continue;
            allUnresolvedLinkedHashes.remove(timedVcsCommit.getHash());
        }
        int saveGreenIndex = VcsLogJoiner.getFirstUnTrackedIndex(savedLog, (Set<Hash>)allUnresolvedLinkedHashes);
        if (saveGreenIndex == -1) {
            Pair pair = new Pair((Object)-1, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogJoiner", "getNewCommitsAndSavedGreenIndex"));
            }
            return pair;
        }
        Pair pair = new Pair((Object)saveGreenIndex, VcsLogJoiner.getAllNewCommits(savedLog.subList(0, saveGreenIndex), firstBlock));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogJoiner", "getNewCommitsAndSavedGreenIndex"));
        }
        return pair;
    }

    private static int getFirstUnTrackedIndex(@NotNull List<? extends TimedVcsCommit> commits, @NotNull Set<Hash> searchHashes) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner", "getFirstUnTrackedIndex"));
        }
        if (searchHashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogJoiner", "getFirstUnTrackedIndex"));
        }
        int lastIndex = 0;
        for (TimedVcsCommit timedVcsCommit : commits) {
            if (searchHashes.size() == 0) {
                return lastIndex;
            }
            if (lastIndex > 10000) {
                return -1;
            }
            searchHashes.remove(timedVcsCommit.getHash());
            ++lastIndex;
        }
        return searchHashes.size() == 0 ? lastIndex : -1;
    }

    private static Set<TimedVcsCommit> getAllNewCommits(@NotNull List<? extends TimedVcsCommit> unsafeGreenPartSavedLog, @NotNull List<? extends TimedVcsCommit> firstBlock) {
        if (unsafeGreenPartSavedLog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner", "getAllNewCommits"));
        }
        if (firstBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogJoiner", "getAllNewCommits"));
        }
        HashSet existedCommitHashes = new HashSet();
        for (TimedVcsCommit timedVcsCommit : unsafeGreenPartSavedLog) {
            existedCommitHashes.add(timedVcsCommit.getHash());
        }
        java.util.HashSet allNewsCommits = ContainerUtil.newHashSet();
        for (TimedVcsCommit timedVcsCommit : firstBlock) {
            if (existedCommitHashes.contains(timedVcsCommit.getHash())) continue;
            allNewsCommits.add(timedVcsCommit);
        }
        return allNewsCommits;
    }

    @NotNull
    private static Pair<Integer, Set<Hash>> getRedCommitsAndSavedRedIndex(@NotNull List<? extends TimedVcsCommit> savedLog, @NotNull Collection<Hash> previousRefs, @NotNull List<? extends TimedVcsCommit> firstBlock, @NotNull Collection<Hash> newRefs) {
        if (savedLog == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner", "getRedCommitsAndSavedRedIndex"));
        }
        if (previousRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogJoiner", "getRedCommitsAndSavedRedIndex"));
        }
        if (firstBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/VcsLogJoiner", "getRedCommitsAndSavedRedIndex"));
        }
        if (newRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/vcs/log/data/VcsLogJoiner", "getRedCommitsAndSavedRedIndex"));
        }
        HashSet startRedCommits = new HashSet(previousRefs);
        startRedCommits.removeAll(newRefs);
        HashSet startGreenNodes = new HashSet(newRefs);
        for (TimedVcsCommit timedVcsCommit : firstBlock) {
            startGreenNodes.add(timedVcsCommit.getHash());
            startGreenNodes.addAll(timedVcsCommit.getParents());
        }
        RedGreenSorter sorter = new RedGreenSorter((Set)startRedCommits, (Set)startGreenNodes, savedLog);
        int n = sorter.getFirstSaveIndex();
        if (n == -1) {
            Pair pair = new Pair((Object)-1, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogJoiner", "getRedCommitsAndSavedRedIndex"));
            }
            return pair;
        }
        Pair pair = new Pair((Object)n, sorter.getAllRedCommit());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogJoiner", "getRedCommitsAndSavedRedIndex"));
        }
        return pair;
    }

    static class NewCommitIntegrator<Commit extends TimedVcsCommit> {
        private final List<Commit> list;
        private final Map<Hash, Commit> newCommitsMap;
        private final Collection<Commit> newCommits;

        public NewCommitIntegrator(@NotNull List<Commit> list, @NotNull Collection<Commit> newCommits) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner$NewCommitIntegrator", "<init>"));
            }
            if (newCommits == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/VcsLogJoiner$NewCommitIntegrator", "<init>"));
            }
            this.list = list;
            this.newCommitsMap = ContainerUtil.newHashMap();
            this.newCommits = newCommits;
            for (TimedVcsCommit commit : newCommits) {
                this.newCommitsMap.put(commit.getHash(), commit);
            }
        }

        private void insertToList(@NotNull Commit commit) {
            TimedVcsCommit currentCommit;
            int insertIndex;
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner$NewCommitIntegrator", "insertToList"));
            }
            if (!this.newCommitsMap.containsKey(commit.getHash())) {
                throw new IllegalStateException("Commit was inserted, but insert call again. Commit hash: " + commit.getHash());
            }
            for (Hash parentHash : commit.getParents()) {
                TimedVcsCommit parentCommit = (TimedVcsCommit)this.newCommitsMap.get(parentHash);
                if (parentCommit == null) continue;
                this.insertToList(parentCommit);
            }
            HashSet parents = new HashSet((Collection)commit.getParents());
            for (insertIndex = 0; insertIndex < this.list.size() && !parents.contains((Object)(currentCommit = (TimedVcsCommit)this.list.get(insertIndex)).getHash()) && currentCommit.getTime() >= commit.getTime(); ++insertIndex) {
            }
            this.list.add(insertIndex, commit);
            this.newCommitsMap.remove(commit.getHash());
        }

        private void insertAllCommits() {
            for (TimedVcsCommit commit : this.newCommits) {
                if (this.newCommitsMap.get(commit.getHash()) == null) continue;
                this.insertToList(commit);
            }
        }

        public List<Commit> getResultList() {
            this.insertAllCommits();
            return this.list;
        }
    }

    private static class RedGreenSorter {
        private final Set<Hash> currentRed;
        private final Set<Hash> currentGreen;
        private final Set<Hash> allRedCommit = new HashSet();
        private final List<? extends TimedVcsCommit> savedLog;

        private RedGreenSorter(Set<Hash> startRedNodes, Set<Hash> startGreenNodes, List<? extends TimedVcsCommit> savedLog) {
            this.currentRed = startRedNodes;
            this.currentGreen = startGreenNodes;
            this.savedLog = savedLog;
        }

        private void markRealRedNode(@NotNull Hash node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/VcsLogJoiner$RedGreenSorter", "markRealRedNode"));
            }
            assert (this.currentRed.remove(node)) : "Red node isn't marked as red";
            this.allRedCommit.add(node);
        }

        private int getFirstSaveIndex() {
            int lastIndex = 0;
            for (TimedVcsCommit timedVcsCommit : this.savedLog) {
                if (lastIndex > 10000) {
                    return -1;
                }
                boolean isGreen = this.currentGreen.remove(timedVcsCommit.getHash());
                if (isGreen) {
                    this.currentRed.remove(timedVcsCommit.getHash());
                    this.currentGreen.addAll(timedVcsCommit.getParents());
                } else {
                    this.markRealRedNode(timedVcsCommit.getHash());
                    this.currentRed.addAll(timedVcsCommit.getParents());
                }
                ++lastIndex;
                if (!this.currentRed.isEmpty()) continue;
                return lastIndex;
            }
            return -1;
        }

        public Set<Hash> getAllRedCommit() {
            return this.allRedCommit;
        }
    }
}

