/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefsModel
implements VcsLogRefs {
    @NotNull
    private final Collection<VcsRef> myBranches;
    @NotNull
    private final MultiMap<Hash, VcsRef> myRefsToHashes;
    @NotNull
    private final TIntObjectHashMap<SmartList<VcsRef>> myRefsToIndices;
    @NotNull
    private final NotNullFunction<Hash, Integer> myIndexGetter;

    public RefsModel(@NotNull Collection<VcsRef> allRefs, @NotNull NotNullFunction<Hash, Integer> indexGetter) {
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (indexGetter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        this.myIndexGetter = indexGetter;
        this.myBranches = ContainerUtil.filter(allRefs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getType().isBranch();
            }
        });
        this.myRefsToHashes = RefsModel.prepareRefsMap(allRefs);
        this.myRefsToIndices = this.prepareRefsToIndicesMap(allRefs);
    }

    @NotNull
    private TIntObjectHashMap<SmartList<VcsRef>> prepareRefsToIndicesMap(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (VcsRef ref : refs) {
            int index = (Integer)this.myIndexGetter.fun((Object)ref.getCommitHash());
            SmartList list = (SmartList)map.get(index);
            if (list == null) {
                list = new SmartList();
                map.put(index, (Object)list);
            }
            list.add((Object)ref);
        }
        TIntObjectHashMap tIntObjectHashMap = map;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRefsToIndicesMap"));
        }
        return tIntObjectHashMap;
    }

    @NotNull
    private static MultiMap<Hash, VcsRef> prepareRefsMap(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/RefsModel", "prepareRefsMap"));
        }
        MultiMap map = MultiMap.createSmartList();
        for (VcsRef ref : refs) {
            map.putValue((Object)ref.getCommitHash(), (Object)ref);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "prepareRefsMap"));
        }
        return multiMap;
    }

    public boolean isBranchRef(int hash) {
        for (VcsRef ref : this.refsToCommit(hash)) {
            if (!ref.getType().isBranch()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        if (this.myRefsToHashes.containsKey((Object)hash)) {
            Collection collection = this.myRefsToHashes.get((Object)hash);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
            }
            return collection;
        }
        List<VcsRef> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        return list;
    }

    @NotNull
    public Collection<VcsRef> refsToCommit(int index) {
        List list = this.myRefsToIndices.containsKey(index) ? (List)this.myRefsToIndices.get(index) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "refsToCommit"));
        }
        return list;
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        Collection<VcsRef> collection = this.myBranches;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getBranches"));
        }
        return collection;
    }

    @NotNull
    public Collection<VcsRef> getAllRefs() {
        ArrayList<VcsRef> arrayList = new ArrayList<VcsRef>(this.myRefsToHashes.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getAllRefs"));
        }
        return arrayList;
    }
}

