/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.vcs.log.GraphCommit;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.data.GraphFacadeBuilder;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphFacade;
import com.intellij.vcs.log.graph.GraphFacadeImpl;
import com.intellij.vcs.log.graph.elements.Node;
import com.intellij.vcs.log.graph.mutable.GraphBuilder;
import com.intellij.vcs.log.graph.mutable.MutableGraph;
import com.intellij.vcs.log.graphmodel.impl.GraphModelImpl;
import com.intellij.vcs.log.printmodel.impl.GraphPrintCellModelImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GraphFacadeBuilderImpl
implements GraphFacadeBuilder {
    GraphFacadeBuilderImpl() {
    }

    @Override
    @NotNull
    public GraphFacade build(@NotNull List<? extends GraphCommit> commits, final @NotNull RefsModel refsModel, @NotNull GraphColorManagerImpl colorManager) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl", "build"));
        }
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl", "build"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl", "build"));
        }
        MutableGraph graph = GraphBuilder.build(commits, refsModel.getAllRefs());
        GraphModelImpl graphModel = new GraphModelImpl(graph);
        final GraphPrintCellModelImpl printCellModel = new GraphPrintCellModelImpl(graphModel.getGraph());
        graphModel.addUpdateListener(new Consumer<UpdateRequest>(){

            public void consume(UpdateRequest key) {
                printCellModel.recalculate(key);
            }
        });
        graphModel.getFragmentManager().setUnconcealedNodeFunction(new Function<Node, Boolean>(){

            @NotNull
            public Boolean fun(@NotNull Node key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl$2", "fun"));
                }
                if (key.getDownEdges().isEmpty() || key.getUpEdges().isEmpty() || refsModel.isBranchRef(key.getCommitIndex())) {
                    Boolean bl = true;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl$2", "fun"));
                    }
                    return bl;
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl$2", "fun"));
                }
                return bl;
            }
        });
        GraphFacadeImpl graphFacadeImpl = new GraphFacadeImpl(graphModel, printCellModel, colorManager);
        if (graphFacadeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/GraphFacadeBuilderImpl", "build"));
        }
        return graphFacadeImpl;
    }
}

