/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.compressedlist;

import com.intellij.util.containers.SLRUCache;
import com.intellij.vcs.log.compressedlist.CompressedList;
import com.intellij.vcs.log.compressedlist.UpdateRequest;
import com.intellij.vcs.log.compressedlist.generator.Generator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RuntimeGenerateCompressedList<T>
implements CompressedList<T> {
    private final SLRUCache<Integer, T> cache = new SLRUCache<Integer, T>(200, 200){

        @NotNull
        public T createValue(Integer key) {
            Object object = RuntimeGenerateCompressedList.this.get(key);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/compressedlist/RuntimeGenerateCompressedList$1", "createValue"));
            }
            return object;
        }
    };
    private final Generator<T> generator;
    private final int intervalSave;
    private final List<PositionItem> positionItems = new ArrayList<PositionItem>();
    private int size;

    public RuntimeGenerateCompressedList(Generator<T> generator, int size, int intervalSave) {
        this.generator = generator;
        this.intervalSave = intervalSave;
        this.size = size;
        T firstT = generator.generateFirst();
        this.positionItems.add(new PositionItem(0, firstT));
        T prevT = firstT;
        for (int curPosition = intervalSave; curPosition < size; curPosition += intervalSave) {
            prevT = generator.generate(prevT, intervalSave);
            this.positionItems.add(new PositionItem(curPosition, prevT));
        }
    }

    public RuntimeGenerateCompressedList(Generator<T> generator, int size) {
        this(generator, size, 20);
    }

    private int binarySearch(int position) {
        assert (this.positionItems.size() > 0);
        int x = 0;
        int y = this.positionItems.size() - 1;
        while (y - x > 1) {
            int z = (x + y) / 2;
            if (this.positionItems.get(z).getPosition() <= position) {
                x = z;
                continue;
            }
            y = z;
        }
        if (this.positionItems.get(y).getPosition() <= position) {
            return y;
        }
        return x;
    }

    @Override
    @NotNull
    public List<T> getList() {
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                return RuntimeGenerateCompressedList.this.cache.get((Object)index);
            }

            @Override
            public int size() {
                return RuntimeGenerateCompressedList.this.size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/compressedlist/RuntimeGenerateCompressedList", "getList"));
        }
        return abstractList;
    }

    private void fixPositionsTail(int startIndex, int deltaSize) {
        for (int i = startIndex; i < this.positionItems.size(); ++i) {
            PositionItem positionItem = this.positionItems.get(i);
            positionItem.setPosition(positionItem.getPosition() + deltaSize);
        }
    }

    private List<PositionItem> regenerateMediate(PositionItem prevSavePositionItem, int downSavePosition) {
        ArrayList<PositionItem> mediateSave = new ArrayList<PositionItem>();
        Object prevT = prevSavePositionItem.getT();
        for (int curTPosition = prevSavePositionItem.getPosition() + this.intervalSave; curTPosition < downSavePosition - this.intervalSave; curTPosition += this.intervalSave) {
            prevT = this.generator.generate(prevT, this.intervalSave);
            mediateSave.add(new PositionItem(curTPosition, prevT));
        }
        return mediateSave;
    }

    private void checkReplace(UpdateRequest updateRequest) {
        if (updateRequest.to() >= this.size) {
            throw new IllegalArgumentException("size= " + this.size + "Bad updateRequest: " + updateRequest);
        }
    }

    @Override
    public void recalculate(@NotNull UpdateRequest updateRequest) {
        int downSaveIndex;
        if (updateRequest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/vcs/log/compressedlist/RuntimeGenerateCompressedList", "recalculate"));
        }
        if (updateRequest == UpdateRequest.ID_UpdateRequest) {
            return;
        }
        this.checkReplace(updateRequest);
        this.cache.clear();
        int deltaSize = updateRequest.addedElementCount() - updateRequest.removedElementCount();
        int upSaveIndex = this.binarySearch(updateRequest.from());
        if (upSaveIndex > 0) {
            --upSaveIndex;
        } else {
            this.positionItems.set(0, new PositionItem(0, this.generator.generateFirst()));
        }
        PositionItem upSavePositionItem = this.positionItems.get(upSaveIndex);
        for (downSaveIndex = upSaveIndex; downSaveIndex < this.positionItems.size() && this.positionItems.get(downSaveIndex).getPosition() <= updateRequest.to(); ++downSaveIndex) {
        }
        this.size += deltaSize;
        this.fixPositionsTail(downSaveIndex, deltaSize);
        int downSavePosition = this.size;
        if (downSaveIndex < this.positionItems.size()) {
            downSavePosition = this.positionItems.get(downSaveIndex).getPosition();
        }
        List<PositionItem> mediate = this.regenerateMediate(upSavePositionItem, downSavePosition);
        this.positionItems.subList(upSaveIndex + 1, downSaveIndex).clear();
        this.positionItems.addAll(upSaveIndex + 1, mediate);
    }

    @NotNull
    private T get(int position) {
        if (position < 0 || position >= this.size) {
            throw new IllegalArgumentException();
        }
        int saveIndex = this.binarySearch(position);
        PositionItem positionItem = this.positionItems.get(saveIndex);
        assert (position >= positionItem.getPosition());
        T t = this.generator.generate(positionItem.getT(), position - positionItem.getPosition());
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/compressedlist/RuntimeGenerateCompressedList", "get"));
        }
        return t;
    }

    private class PositionItem {
        private int position;
        private final T t;

        private PositionItem(@NotNull int position, T t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/vcs/log/compressedlist/RuntimeGenerateCompressedList$PositionItem", "<init>"));
            }
            this.position = position;
            this.t = t;
        }

        public int getPosition() {
            return this.position;
        }

        @NotNull
        public T getT() {
            Object t = this.t;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/compressedlist/RuntimeGenerateCompressedList$PositionItem", "getT"));
            }
            return t;
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }
}

