/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.util.xml.stubs.builder.DomStubBuilderVisitor;
import com.intellij.xml.util.XmlUtil;

public class DomStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance(DomStubBuilder.class);

    public boolean acceptsFile(VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == XmlFileType.INSTANCE && !FileBasedIndexImpl.isProjectOrWorkspaceFile(file, fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stub buildStubTree(FileContent fileContent) {
        PsiFile existingPsi;
        PsiFile psiFile = fileContent.getPsiFile();
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(fileContent.getFile());
        Project project = fileContent.getProject();
        if (document != null && (existingPsi = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
            psiFile = existingPsi;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile);
            if (fileElement == null || !fileElement.getFileDescription().hasStubs()) {
                Stub stub = null;
                return stub;
            }
            XmlFileHeader header = DomService.getInstance().getXmlFileHeader(xmlFile);
            if (header.getRootTagLocalName() == null) {
                LOG.error("null root tag for " + fileElement + " for " + fileContent.getFile());
            }
            FileStub fileStub = new FileStub(header);
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                new DomStubBuilderVisitor(DomManagerImpl.getDomManager(project)).visitXmlElement((XmlElement)rootTag, fileStub, 0);
            }
            FileStub fileStub2 = fileStub;
            return fileStub2;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    public int getStubVersion() {
        return 18 + DomApplicationComponent.getInstance().getCumulativeVersion();
    }
}

