/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubParentStrategy
implements DomParentStrategy {
    protected final DomStub myStub;

    public static StubParentStrategy createAttributeStrategy(@Nullable AttributeStub stub, @NotNull DomStub parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/stubs/StubParentStrategy", "createAttributeStrategy"));
        }
        if (stub == null) {
            return new Empty(parent);
        }
        return new StubParentStrategy(stub){

            @Override
            public XmlElement getXmlElement() {
                DomInvocationHandler parentHandler = this.getParentHandler();
                assert (parentHandler != null);
                XmlTag tag = parentHandler.getXmlTag();
                if (tag == null) {
                    throw new AssertionError((Object)("can't find tag for " + (Object)((Object)parentHandler)));
                }
                return tag.getAttribute(this.myStub.getName());
            }
        };
    }

    public StubParentStrategy(@NotNull DomStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/stubs/StubParentStrategy", "<init>"));
        }
        this.myStub = stub;
    }

    @Override
    public DomInvocationHandler getParentHandler() {
        DomStub parentStub = (DomStub)this.myStub.getParentStub();
        return parentStub == null ? null : parentStub.getHandler();
    }

    @Override
    public XmlElement getXmlElement() {
        DomStub parentStub = (DomStub)this.myStub.getParentStub();
        if (parentStub == null) {
            return null;
        }
        List<DomStub> children = parentStub.getChildrenStubs();
        if (children.isEmpty()) {
            return null;
        }
        XmlTag parentTag = parentStub.getHandler().getXmlTag();
        if (parentTag == null) {
            return null;
        }
        XmlTag[] tags = parentTag.getSubTags();
        int i = 0;
        String nameToFind = this.myStub.getName();
        for (XmlTag xmlTag : tags) {
            if (!nameToFind.equals(xmlTag.getName()) || this.myStub.getIndex() != i++) continue;
            return xmlTag;
        }
        return null;
    }

    @Override
    @NotNull
    public DomParentStrategy refreshStrategy(DomInvocationHandler handler) {
        StubParentStrategy stubParentStrategy = this;
        if (stubParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/StubParentStrategy", "refreshStrategy"));
        }
        return stubParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/stubs/StubParentStrategy", "setXmlElement"));
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
        if (physicalDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/StubParentStrategy", "setXmlElement"));
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy clearXmlElement() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        VirtualDomParentStrategy virtualDomParentStrategy = new VirtualDomParentStrategy(parent);
        if (virtualDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/StubParentStrategy", "clearXmlElement"));
        }
        return virtualDomParentStrategy;
    }

    @Override
    public String checkValidity() {
        return null;
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler) {
        return this.getParentHandler().getFile();
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    public boolean equals(Object obj) {
        return PhysicalDomParentStrategy.strategyEquals(this, obj);
    }

    public static class Empty
    extends StubParentStrategy {
        private final DomStub myParent;

        public Empty(DomStub parent) {
            super(parent);
            this.myParent = parent;
        }

        @Override
        public DomInvocationHandler getParentHandler() {
            return this.myParent.getHandler();
        }

        @Override
        public XmlElement getXmlElement() {
            return null;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }
    }
}

