/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStubSerializer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementStub
extends DomStub {
    private final List<DomStub> myChildren;
    private final int myIndex;
    private final boolean myCustom;
    @Nullable
    private final StringRef myElementClass;

    public ElementStub(@Nullable ElementStub parent, @NotNull StringRef name, @Nullable StringRef namespace, int index, boolean custom, @Nullable StringRef elementClass) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/stubs/ElementStub", "<init>"));
        }
        super(parent, name, namespace);
        this.myChildren = new SmartList();
        this.myIndex = index;
        this.myCustom = custom;
        this.myElementClass = elementClass;
    }

    void addChild(DomStub child) {
        this.myChildren.add(child);
    }

    @Override
    public List<DomStub> getChildrenStubs() {
        return this.myChildren;
    }

    public ObjectStubSerializer getStubType() {
        return ElementStubSerializer.INSTANCE;
    }

    public String toString() {
        String key = this.getNamespaceKey();
        return StringUtil.isEmpty((String)key) ? this.getName() : key + ":" + this.getName();
    }

    @Override
    public boolean isCustom() {
        return this.myCustom;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Nullable
    String getElementClass() {
        return this.myElementClass == null ? null : this.myElementClass.getString();
    }
}

