/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChildrenDescriptionsHolder<T extends DomChildDescriptionImpl> {
    private final Map<XmlName, T> myMap = new THashMap();
    private final ChildrenDescriptionsHolder<T> myDelegate;
    private volatile List<T> myCached = null;

    public ChildrenDescriptionsHolder(@Nullable ChildrenDescriptionsHolder<T> delegate) {
        this.myDelegate = delegate;
    }

    public ChildrenDescriptionsHolder() {
        this(null);
    }

    final T addDescription(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/impl/ChildrenDescriptionsHolder", "addDescription"));
        }
        this.myMap.put(((DomChildDescriptionImpl)t).getXmlName(), t);
        this.myCached = null;
        return t;
    }

    final void addDescriptions(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/impl/ChildrenDescriptionsHolder", "addDescriptions"));
        }
        for (DomChildDescriptionImpl t : collection) {
            this.addDescription(t);
        }
    }

    @Nullable
    final T getDescription(XmlName name) {
        DomChildDescriptionImpl t = (DomChildDescriptionImpl)this.myMap.get(name);
        if (t != null) {
            return (T)t;
        }
        return this.myDelegate != null ? (T)this.myDelegate.getDescription(name) : null;
    }

    @Nullable
    final T getDescription(@NotNull String localName, String namespaceKey) {
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/impl/ChildrenDescriptionsHolder", "getDescription"));
        }
        return this.getDescription(new XmlName(localName, namespaceKey));
    }

    @Nullable
    final T findDescription(@NotNull String localName) {
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/impl/ChildrenDescriptionsHolder", "findDescription"));
        }
        for (XmlName xmlName : this.myMap.keySet()) {
            if (!xmlName.getLocalName().equals(localName)) continue;
            return (T)((DomChildDescriptionImpl)this.myMap.get(xmlName));
        }
        return this.myDelegate != null ? (T)this.myDelegate.findDescription(localName) : null;
    }

    @NotNull
    final List<T> getDescriptions() {
        ArrayList result = new ArrayList();
        this.dumpDescriptions(result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/ChildrenDescriptionsHolder", "getDescriptions"));
        }
        return arrayList;
    }

    private List<T> getSortedDescriptions() {
        List<T> cached = this.myCached;
        if (cached != null) {
            return cached;
        }
        cached = new ArrayList<T>(this.myMap.values());
        Collections.sort(cached);
        this.myCached = cached;
        return cached;
    }

    final void dumpDescriptions(Collection<? super T> to) {
        to.addAll(this.getSortedDescriptions());
        if (this.myDelegate != null) {
            this.myDelegate.dumpDescriptions(to);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildrenDescriptionsHolder)) {
            return false;
        }
        ChildrenDescriptionsHolder holder = (ChildrenDescriptionsHolder)o;
        if (this.myDelegate != null ? !this.myDelegate.equals(holder.myDelegate) : holder.myDelegate != null) {
            return false;
        }
        return ((Object)this.myMap).equals(holder.myMap);
    }

    public int hashCode() {
        int result = ((Object)this.myMap).hashCode();
        result = 31 * result + (this.myDelegate != null ? this.myDelegate.hashCode() : 0);
        return result;
    }
}

