/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import org.jetbrains.annotations.NotNull;

class DomElementResolveProblemDescriptorImpl
extends DomElementProblemDescriptorImpl
implements DomElementResolveProblemDescriptor {
    @NotNull
    private final PsiReference myReference;

    public DomElementResolveProblemDescriptorImpl(@NotNull GenericDomValue domElement, @NotNull PsiReference reference, LocalQuickFix ... quickFixes) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "<init>"));
        }
        super((DomElement)domElement, reference instanceof FileReference ? ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference) : XmlHighlightVisitor.getErrorDescription(reference), HighlightSeverity.ERROR, quickFixes);
        this.myReference = reference;
    }

    @NotNull
    public PsiReference getPsiReference() {
        PsiReference psiReference = this.myReference;
        if (psiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "getPsiReference"));
        }
        return psiReference;
    }

    @NotNull
    public GenericDomValue getDomElement() {
        GenericDomValue genericDomValue = (GenericDomValue)super.getDomElement();
        if (genericDomValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "getDomElement"));
        }
        return genericDomValue;
    }

    @Override
    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiReference reference = this.myReference;
        PsiElement element = reference.getElement();
        if (element instanceof XmlAttributeValue && element.getTextLength() == 0) {
            Pair pair = NO_PROBLEM;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "computeProblemRange"));
            }
            return pair;
        }
        TextRange referenceRange = reference.getRangeInElement();
        if (referenceRange.isEmpty()) {
            int startOffset = referenceRange.getStartOffset();
            Pair pair = element instanceof XmlAttributeValue ? Pair.create((Object)new UnfairTextRange(startOffset - 1, startOffset + 1), (Object)element) : Pair.create((Object)TextRange.from((int)startOffset, (int)1), (Object)element);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "computeProblemRange"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)referenceRange, (Object)element);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl", "computeProblemRange"));
        }
        return pair;
    }
}

