/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Computable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class TaskQueue {
    private final AtomicInteger myDoWorkRequest = new AtomicInteger();
    private final AtomicInteger myUpdatesCount = new AtomicInteger();
    private final LinkedBlockingQueue<Runnable> myPendingWriteRequestsQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Runnable> myTimestampUpdates = new LinkedBlockingQueue();
    private final int myLimit;
    private final int myStealLimit;
    private final int myTimeStampUpdateSizeLimit;

    public TaskQueue(int limit) {
        this.myLimit = limit;
        this.myStealLimit = Math.max(1, (int)((double)limit * 0.01));
        this.myTimeStampUpdateSizeLimit = 32;
    }

    void submit(final Computable<Boolean> update, final Runnable successRunnable) {
        int size;
        int currentTasksCount = this.myUpdatesCount.incrementAndGet();
        this.myPendingWriteRequestsQueue.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Boolean result = (Boolean)update.compute();
                    if (result == Boolean.TRUE) {
                        TaskQueue.this.myTimestampUpdates.add(successRunnable);
                    }
                }
                finally {
                    TaskQueue.this.myUpdatesCount.decrementAndGet();
                }
            }
        });
        if (currentTasksCount > this.myLimit) {
            Runnable runnable = this.myPendingWriteRequestsQueue.poll();
            int processed = 0;
            while (runnable != null) {
                runnable.run();
                if (++processed == this.myStealLimit) break;
                runnable = this.myPendingWriteRequestsQueue.poll();
            }
        }
        if ((size = this.myTimestampUpdates.size()) > this.myTimeStampUpdateSizeLimit) {
            this.applyTimeStamps(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTimeStamps(int max) {
        Runnable runnable = this.myTimestampUpdates.poll();
        if (runnable == null) {
            return;
        }
        int updates = 0;
        AccessToken accessToken = ReadAction.start();
        try {
            while (runnable != null) {
                runnable.run();
                if (++updates == max) {
                    break;
                }
                runnable = this.myTimestampUpdates.poll();
            }
        }
        finally {
            accessToken.finish();
        }
    }

    public void ensureUpToDate() {
        try {
            while (this.myUpdatesCount.get() > 0) {
                Runnable runnable = this.myPendingWriteRequestsQueue.poll(10L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            this.applyTimeStamps(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void signalUpdateEnd() {
        this.myDoWorkRequest.decrementAndGet();
    }

    public void signalUpdateStart() {
        int workRequests = this.myDoWorkRequest.getAndIncrement();
        if (workRequests == 0) {
            this.myDoWorkRequest.incrementAndGet();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Runnable runnable;
                            if ((runnable = (Runnable)TaskQueue.this.myPendingWriteRequestsQueue.poll(2000L, TimeUnit.MILLISECONDS)) != null) {
                                runnable.run();
                                continue;
                            }
                            if (TaskQueue.this.myDoWorkRequest.compareAndSet(1, 0)) break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

