/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private final boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    @NotNull
    public final Map<Integer, V> map(FileContent inputData) {
        if (inputData == null) {
            Map map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
            }
            return map;
        }
        V value = this.computeValue(inputData);
        if (value == null && !this.myAcceptNullValues) {
            Map map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
            }
            return map;
        }
        int key = Math.abs(FileBasedIndex.getFileId((VirtualFile)inputData.getFile()));
        Map<Integer, V> map = Collections.singletonMap(key, value);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SingleEntryIndexer", "map"));
        }
        return map;
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);
}

