/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PerIndexDocumentVersionMap {
    private volatile int mapVersion;
    private static final Key<List<IdVersionInfo>> KEY = Key.create((String)"UnsavedDocIdVersionInfo");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndSet(@NotNull Document document, @NotNull ID<?, ?> indexId, long value) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "getAndSet"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "getAndSet"));
        }
        List list = (List)document.getUserData(KEY);
        if (list == null) {
            list = (List)((UserDataHolderEx)document).putUserDataIfAbsent(KEY, new ArrayList());
        }
        List list2 = list;
        synchronized (list2) {
            for (IdVersionInfo info : list) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    old = 0L;
                    info.mapVersion = this.mapVersion;
                }
                info.docVersion = value;
                return old;
            }
            list.add(new IdVersionInfo(indexId, value, this.mapVersion));
            return 0L;
        }
    }

    public void clear() {
        ++this.mapVersion;
    }

    private static class IdVersionInfo {
        private final ID<?, ?> id;
        private int mapVersion;
        private long docVersion;

        /*
         * WARNING - void declaration
         */
        private IdVersionInfo(@NotNull ID<?, ?> id, long docVersion, int n) {
            void mapVersion;
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/PerIndexDocumentVersionMap$IdVersionInfo", "<init>"));
            }
            this.docVersion = docVersion;
            this.mapVersion = mapVersion;
            this.id = id;
        }
    }
}

