/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.indexing.ID;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexInfrastructure {
    private static final int VERSION = 9;
    private static final ConcurrentHashMap<ID<?, ?>, Long> ourIndexIdToCreationStamp = new ConcurrentHashMap();
    private static final boolean ourUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    public static final long INVALID_STAMP = -1L;
    public static final long INVALID_STAMP2 = -2L;
    private static final String STUB_VERSIONS = ".versions";
    private static volatile long ourLastStamp;

    private IndexInfrastructure() {
    }

    @NotNull
    public static File getVersionFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "getVersionFile"));
        }
        File file = new File(IndexInfrastructure.getIndexDirectory(indexName, true), indexName + ".ver");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexInfrastructure", "getVersionFile"));
        }
        return file;
    }

    @NotNull
    public static File getStorageFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "getStorageFile"));
        }
        File file = new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.toString());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexInfrastructure", "getStorageFile"));
        }
        return file;
    }

    @NotNull
    public static File getInputIndexStorageFile(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "getInputIndexStorageFile"));
        }
        File file = new File(IndexInfrastructure.getIndexRootDir(indexName), indexName + "_inputs");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexInfrastructure", "getInputIndexStorageFile"));
        }
        return file;
    }

    @NotNull
    public static File getIndexRootDir(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "getIndexRootDir"));
        }
        File file = IndexInfrastructure.getIndexDirectory(indexName, false);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexInfrastructure", "getIndexRootDir"));
        }
        return file;
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "getIndexDirectory"));
        }
        String dirName = indexName.toString().toLowerCase(Locale.US);
        File indexDir = indexName instanceof StubIndexKey ? new File(IndexInfrastructure.getIndexRootDir(StubUpdatingIndex.INDEX_ID), forVersion ? STUB_VERSIONS : dirName) : new File(PathManager.getIndexRoot(), dirName);
        indexDir.mkdirs();
        File file = indexDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IndexInfrastructure", "getIndexDirectory"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void rewriteVersion(final @NotNull File file, int version) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "rewriteVersion"));
        }
        long prevLastModifiedValue = file.lastModified();
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        file.getParentFile().mkdirs();
        DataOutputStream os = (DataOutputStream)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

            @Nullable
            public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                try {
                    return new DataOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException ex) {
                    if (lastAttempt) {
                        throw ex;
                    }
                    return null;
                }
            }
        });
        assert (os != null);
        try {
            os.writeInt(version);
            os.writeInt(9);
        }
        finally {
            long max;
            ourIndexIdToCreationStamp.clear();
            os.close();
            ourLastStamp = max = Math.max(System.currentTimeMillis(), Math.max(prevLastModifiedValue, ourLastStamp) + 2000L);
            file.setLastModified(max);
        }
    }

    public static long getIndexCreationStamp(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "getIndexCreationStamp"));
        }
        Long version = (Long)ourIndexIdToCreationStamp.get(indexName);
        if (version != null) {
            return version;
        }
        long stamp = IndexInfrastructure.getVersionFile(indexName).lastModified();
        ourIndexIdToCreationStamp.putIfAbsent(indexName, (Object)stamp);
        return stamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean versionDiffers(@NotNull File versionFile, int currentIndexVersion) {
        boolean bl;
        if (versionFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "versionDiffers"));
        }
        ourLastStamp = Math.max(ourLastStamp, versionFile.lastModified());
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(versionFile)));
        try {
            int savedIndexVersion = in.readInt();
            int commonVersion = in.readInt();
            bl = savedIndexVersion != currentIndexVersion || commonVersion != 9;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        in.close();
        return bl;
    }

    @Nullable
    public static VirtualFile findFileById(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "findFileById"));
        }
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileById(id);
    }

    @Nullable
    public static VirtualFile findFileByIdIfCached(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/IndexInfrastructure", "findFileByIdIfCached"));
        }
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileByIdIfCached(id);
    }

    @Nullable
    private static VirtualFile findTestFile(int id) {
        return DummyFileSystem.getInstance().findById(id);
    }
}

