/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.file.exclude.ProjectFileExclusionManagerImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FileBasedIndexProjectHandler
extends AbstractProjectComponent
implements IndexableFileSet {
    private final FileBasedIndexImpl myIndex;
    private final ProjectRootManagerEx myRootManager;
    private final FileTypeManager myFileTypeManager;
    private final ProjectFileExclusionManagerImpl myExclusionManager;

    public FileBasedIndexProjectHandler(final FileBasedIndexImpl index, final Project project, final ProjectRootManagerComponent rootManager, FileTypeManager ftManager, final ProjectManager projectManager) {
        super(project);
        this.myIndex = index;
        this.myRootManager = rootManager;
        this.myFileTypeManager = ftManager;
        this.myExclusionManager = ProjectFileExclusionManagerImpl.getInstance(project);
        final StartupManagerEx startupManager = (StartupManagerEx)StartupManager.getInstance((Project)project);
        if (startupManager != null) {
            startupManager.registerPreStartupActivity(new Runnable(){

                @Override
                public void run() {
                    final RefreshCacheUpdater changedFilesUpdater = new RefreshCacheUpdater();
                    final UnindexedFilesUpdater unindexedFilesUpdater = new UnindexedFilesUpdater(project, index);
                    startupManager.registerCacheUpdater(unindexedFilesUpdater);
                    rootManager.registerRootsChangeUpdater(unindexedFilesUpdater);
                    rootManager.registerRefreshUpdater(changedFilesUpdater);
                    FileBasedIndexProjectHandler.this.myIndex.registerIndexableSet(FileBasedIndexProjectHandler.this, project);
                    projectManager.addProjectManagerListener(project, (ProjectManagerListener)new ProjectManagerAdapter(){
                        private boolean removed = false;

                        public void projectClosing(Project project) {
                            if (!this.removed) {
                                this.removed = true;
                                rootManager.unregisterRefreshUpdater(changedFilesUpdater);
                                rootManager.unregisterRootsChangeUpdater(unindexedFilesUpdater);
                                FileBasedIndexProjectHandler.this.myIndex.removeIndexableSet(FileBasedIndexProjectHandler.this);
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean isInSet(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "isInSet"));
        }
        ProjectFileIndex index = this.myRootManager.getFileIndex();
        if (index.isInContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file)) {
            if (this.myExclusionManager != null && this.myExclusionManager.isExcluded(file)) {
                return false;
            }
            return !this.myFileTypeManager.isFileIgnored(file);
        }
        return false;
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file, final @NotNull ContentIterator iterator) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "iterateIndexableFilesIn"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "iterateIndexableFilesIn"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexProjectHandler$2", "visitFile"));
                }
                if (!FileBasedIndexProjectHandler.this.isInSet(file)) {
                    return false;
                }
                iterator.processFile(file);
                return true;
            }
        });
    }

    public void disposeComponent() {
        this.myIndex.removeIndexableSet(this);
    }

    private class RefreshCacheUpdater
    implements CacheUpdater {
        private RefreshCacheUpdater() {
        }

        public int getNumberOfPendingUpdateJobs() {
            return FileBasedIndexProjectHandler.this.myIndex.getNumberOfPendingInvalidations();
        }

        @NotNull
        public VirtualFile[] queryNeededFiles(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexProjectHandler$RefreshCacheUpdater", "queryNeededFiles"));
            }
            Collection<VirtualFile> files = FileBasedIndexProjectHandler.this.myIndex.getFilesToUpdate(FileBasedIndexProjectHandler.this.myProject);
            VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexProjectHandler$RefreshCacheUpdater", "queryNeededFiles"));
            }
            return virtualFileArray;
        }

        public void processFile(@NotNull FileContent fileContent) {
            if (fileContent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexProjectHandler$RefreshCacheUpdater", "processFile"));
            }
            FileBasedIndexProjectHandler.this.myIndex.processRefreshedFile(FileBasedIndexProjectHandler.this.myProject, fileContent);
        }

        public void updatingDone() {
        }

        public void canceled() {
        }
    }
}

