/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.AppTopics;
import com.intellij.history.LocalHistory;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.lang.FileASTNode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexedRootsProvider;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.TaskQueue;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateSemaphore;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import jsr166e.extra.SequenceLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexImpl
extends FileBasedIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexImpl");
    @NonNls
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private final Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> myIndices;
    private final List<ID<?, ?>> myIndicesWithoutFileTypeInfo;
    private final Map<FileType, List<ID<?, ?>>> myFileType2IndicesWithFileTypeInfoMap;
    private final List<ID<?, ?>> myIndicesForDirectories;
    private final Map<ID<?, ?>, Semaphore> myUnsavedDataIndexingSemaphores;
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap;
    private final Set<ID<?, ?>> myNotRequiringContentIndices;
    private final Set<ID<?, ?>> myRequiringContentIndices;
    private final Set<ID<?, ?>> myPsiDependentIndices;
    private final Set<FileType> myNoLimitCheckTypes;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps;
    @NotNull
    private final ChangedFilesCollector myChangedFilesCollector;
    private final List<IndexableFileSet> myIndexableSets;
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap;
    private static final int OK = 1;
    private static final int REQUIRES_REBUILD = 2;
    private static final int REBUILD_IN_PROGRESS = 3;
    private static final Map<ID<?, ?>, AtomicInteger> ourRebuildStatus = new THashMap();
    private final MessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final FileTypeManager myFileTypeManager;
    private final ConcurrentHashSet<ID<?, ?>> myUpToDateIndices;
    private volatile SmartFMap<Document, PsiFile> myTransactionMap;
    @Nullable
    private final String myConfigPath;
    @Nullable
    private final String myLogPath;
    private final boolean myIsUnitTestMode;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private volatile int myLocalModCount;
    private volatile int myFilesModCount;
    private final AtomicInteger myUpdatingFiles;
    private final ConcurrentHashSet<Project> myProjectsBeingUpdated;
    private volatile boolean myInitialized;
    private final AtomicBoolean myShutdownPerformed;
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard;
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock;
    private static final Key<WeakReference<FileContentImpl>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final TaskQueue myContentlessIndicesUpdateQueue;
    private final StorageGuard myStorageLock;

    public FileBasedIndexImpl(VirtualFileManager vfManager, FileDocumentManager fdm, FileTypeManager fileTypeManager, @NotNull MessageBus bus, SerializationManager sm) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/indexing/FileBasedIndexImpl", "<init>"));
        }
        this.myIndices = new THashMap();
        this.myIndicesWithoutFileTypeInfo = new ArrayList();
        this.myFileType2IndicesWithFileTypeInfoMap = new THashMap();
        this.myIndicesForDirectories = new SmartList();
        this.myUnsavedDataIndexingSemaphores = new THashMap();
        this.myIndexIdToVersionMap = new TObjectIntHashMap();
        this.myNotRequiringContentIndices = new THashSet();
        this.myRequiringContentIndices = new THashSet();
        this.myPsiDependentIndices = new THashSet();
        this.myNoLimitCheckTypes = new THashSet();
        this.myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
        this.myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIndexableSetToProjectMap = new THashMap();
        this.myUpToDateIndices = new ConcurrentHashSet();
        this.myTransactionMap = SmartFMap.emptyMap();
        this.myUpdatingFiles = new AtomicInteger();
        this.myProjectsBeingUpdated = new ConcurrentHashSet();
        this.myShutdownPerformed = new AtomicBoolean(false);
        this.myReentrancyGuard = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        this.myCalcIndexableFilesLock = new SequenceLock();
        this.myContentlessIndicesUpdateQueue = new TaskQueue(10000);
        this.myStorageLock = new StorageGuard();
        this.myFileDocumentManager = fdm;
        this.myFileTypeManager = fileTypeManager;
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myConfigPath = FileBasedIndexImpl.calcConfigPath(PathManager.getConfigPath());
        this.myLogPath = FileBasedIndexImpl.calcConfigPath(PathManager.getLogPath());
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(Document doc, PsiFile file) {
                if (file != null) {
                    FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file);
                    FileBasedIndexImpl.this.myUpToDateIndices.clear();
                }
            }

            @Override
            public void transactionCompleted(Document doc, PsiFile file) {
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){
            @Nullable
            private Map<FileType, Set<String>> myTypeToExtensionMap;

            public void beforeFileTypesChanged(FileTypeEvent event) {
                FileBasedIndexImpl.cleanupProcessedFlag();
                this.myTypeToExtensionMap = new THashMap();
                for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                    this.myTypeToExtensionMap.put(type, this.getExtensions(type));
                }
            }

            public void fileTypesChanged(FileTypeEvent event) {
                Map<FileType, Set<String>> oldExtensions = this.myTypeToExtensionMap;
                this.myTypeToExtensionMap = null;
                if (oldExtensions != null) {
                    THashMap newExtensions = new THashMap();
                    for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                        newExtensions.put(type, this.getExtensions(type));
                    }
                    if (!newExtensions.keySet().containsAll(oldExtensions.keySet())) {
                        this.rebuildAllIndices();
                        return;
                    }
                    for (Map.Entry<FileType, Set<String>> entry : oldExtensions.entrySet()) {
                        FileType fileType = entry.getKey();
                        Set<String> strings = entry.getValue();
                        if (((Set)newExtensions.get(fileType)).containsAll(strings)) continue;
                        this.rebuildAllIndices();
                        return;
                    }
                }
            }

            @NotNull
            private Set<String> getExtensions(@NotNull FileType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$2", "getExtensions"));
                }
                THashSet set = new THashSet();
                for (FileNameMatcher matcher : FileBasedIndexImpl.this.myFileTypeManager.getAssociations(type)) {
                    set.add(matcher.getPresentableString());
                }
                THashSet tHashSet = set;
                if (tHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$2", "getExtensions"));
                }
                return tHashSet;
            }

            private void rebuildAllIndices() {
                IndexingStamp.flushCaches();
                for (ID indexId : FileBasedIndexImpl.this.myIndices.keySet()) {
                    try {
                        FileBasedIndexImpl.this.clearIndex(indexId);
                    }
                    catch (StorageException e) {
                        LOG.info((Throwable)e);
                    }
                }
                FileBasedIndexImpl.this.scheduleIndexRebuild(true);
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(VirtualFile file, @NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl$3", "fileContentReloaded"));
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage();
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage();
            }
        });
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionStarted(Object action) {
                FileBasedIndexImpl.this.myUpToDateIndices.clear();
            }
        });
        this.myChangedFilesCollector = new ChangedFilesCollector();
        this.myConnection = connection;
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file, @Nullable FileType fileType) {
        VirtualFile parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "isProjectOrWorkspaceFile"));
        }
        if (fileType instanceof InternalFileType) {
            return true;
        }
        VirtualFile virtualFile = parent = file.isDirectory() ? file : file.getParent();
        while (parent instanceof VirtualFileSystemEntry) {
            if (((VirtualFileSystemEntry)parent).compareNameTo(".idea", !SystemInfoRt.isFileSystemCaseSensitive) == 0) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void requestReindex(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "requestReindex"));
        }
        this.myChangedFilesCollector.invalidateIndices(file, true);
    }

    public void requestReindexExcluded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "requestReindexExcluded"));
        }
        this.myChangedFilesCollector.invalidateIndices(file, false);
    }

    private void initExtensions() {
        try {
            FileBasedIndexExtension[] extensions;
            for (FileBasedIndexExtension extension : extensions = (FileBasedIndexExtension[])Extensions.getExtensions((ExtensionPointName)FileBasedIndexExtension.EXTENSION_POINT_NAME)) {
                ourRebuildStatus.put(extension.getName(), new AtomicInteger(1));
            }
            File corruptionMarker = new File(PathManager.getIndexRoot(), CORRUPTION_MARKER_NAME);
            boolean currentVersionCorrupted = corruptionMarker.exists();
            boolean versionChanged = false;
            for (FileBasedIndexExtension extension : extensions) {
                versionChanged |= this.registerIndexer(extension, currentVersionCorrupted);
            }
            for (List<ID<?, ?>> value : this.myFileType2IndicesWithFileTypeInfoMap.values()) {
                value.addAll(this.myIndicesWithoutFileTypeInfo);
            }
            FileUtil.delete((File)corruptionMarker);
            String rebuildNotification = null;
            if (currentVersionCorrupted) {
                rebuildNotification = "Index files on disk are corrupted. Indices will be rebuilt.";
            } else if (versionChanged) {
                rebuildNotification = "Index file format has changed for some indices. These indices will be rebuilt.";
            }
            if (rebuildNotification != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.is((String)"ide.showIndexRebuildMessage")) {
                new NotificationGroup("Indexing", NotificationDisplayType.BALLOON, false).createNotification("Index Rebuild", rebuildNotification, NotificationType.INFORMATION, null).notify(null);
            }
            this.dropUnregisteredIndices();
            for (ID<?, ?> indexId : this.myIndices.keySet()) {
                if (!ourRebuildStatus.get(indexId).compareAndSet(2, 1)) continue;
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    this.requestRebuild(indexId);
                    LOG.error((Throwable)e);
                }
            }
            this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myChangedFilesCollector);
            this.registerIndexableSet(new AdditionalIndexableFileSet(), null);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        FileBasedIndexImpl.this.performShutdown();
                    }
                });
                FileBasedIndexImpl.saveRegisteredIndices(this.myIndices.keySet());
                this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                    private int lastModCount = 0;

                    @Override
                    public void run() {
                        if (this.lastModCount == FileBasedIndexImpl.this.myLocalModCount) {
                            FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                        }
                        this.lastModCount = FileBasedIndexImpl.this.myLocalModCount;
                    }
                });
                this.myInitialized = true;
                throw throwable;
            }
        }
        ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
        FileBasedIndexImpl.saveRegisteredIndices(this.myIndices.keySet());
        this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new /* invalid duplicate definition of identical inner class */);
        this.myInitialized = true;
    }

    public void initComponent() {
        this.initExtensions();
    }

    @Nullable
    private static String calcConfigPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "calcConfigPath"));
        }
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private <K, V> boolean registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension, boolean isCurrentVersionCorrupted) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "registerIndexer"));
        }
        ID name = extension.getName();
        int version = extension.getVersion();
        File versionFile = IndexInfrastructure.getVersionFile(name);
        boolean versionFileExisted = versionFile.exists();
        boolean versionChanged = false;
        if (isCurrentVersionCorrupted || IndexInfrastructure.versionDiffers(versionFile, version)) {
            if (!isCurrentVersionCorrupted && versionFileExisted) {
                versionChanged = true;
                LOG.info("Version has changed for index " + name + ". The index will be rebuilt.");
            }
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(name));
            IndexInfrastructure.rewriteVersion(versionFile, version);
        }
        this.initIndexStorage(extension, version, versionFile);
        return versionChanged;
    }

    private <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, int version, @NotNull File versionFile) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "initIndexStorage"));
        }
        if (versionFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "initIndexStorage"));
        }
        MapIndexStorage storage = null;
        final ID name = extension.getName();
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                storage = new MapIndexStorage(IndexInfrastructure.getStorageFile(name), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.isKeyHighlySelective(), extension.traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage);
                UpdatableIndex<K, V, FileContent> index = this.createIndex(name, extension, memStorage);
                FileBasedIndex.InputFilter inputFilter = extension.getInputFilter();
                assert (inputFilter != null) : "Index extension " + name + " must provide non-null input filter";
                this.myIndices.put(name, new Pair(index, (Object)new IndexableFilesFilter(inputFilter)));
                if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                    ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing((Consumer)new Consumer<FileType>(){
                        final Set<FileType> addedTypes = new THashSet();

                        public void consume(FileType type) {
                            if (type == null || !this.addedTypes.add(type)) {
                                return;
                            }
                            ArrayList<ID> ids = (ArrayList<ID>)FileBasedIndexImpl.this.myFileType2IndicesWithFileTypeInfoMap.get(type);
                            if (ids == null) {
                                ids = new ArrayList<ID>(5);
                                FileBasedIndexImpl.this.myFileType2IndicesWithFileTypeInfoMap.put(type, ids);
                            }
                            ids.add(name);
                        }
                    });
                } else {
                    this.myIndicesWithoutFileTypeInfo.add(name);
                }
                this.myUnsavedDataIndexingSemaphores.put(name, new Semaphore());
                this.myIndexIdToVersionMap.put((Object)name, version);
                if (!extension.dependsOnFileContent()) {
                    if (extension.indexDirectories()) {
                        this.myIndicesForDirectories.add(name);
                    }
                    this.myNotRequiringContentIndices.add(name);
                } else {
                    this.myRequiringContentIndices.add(name);
                }
                if (extension instanceof PsiDependentIndex) {
                    this.myPsiDependentIndices.add(name);
                }
                this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
                break;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                try {
                    if (storage != null) {
                        storage.close();
                    }
                    storage = null;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(name));
                IndexInfrastructure.rewriteVersion(versionFile, version);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRegisteredIndices(@NotNull Collection<ID<?, ?>> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "saveRegisteredIndices"));
        }
        File file = FileBasedIndexImpl.getRegisteredIndicesFile();
        try {
            FileUtil.createIfDoesntExist((File)file);
            DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
            try {
                os.writeInt(ids.size());
                for (ID<?, ?> id : ids) {
                    IOUtil.writeString((String)id.toString(), (DataOutput)os);
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Set<String> readRegisteredIndexNames() {
        THashSet result = new THashSet();
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(FileBasedIndexImpl.getRegisteredIndicesFile())));
            try {
                int size = in.readInt();
                for (int idx = 0; idx < size; ++idx) {
                    result.add(IOUtil.readString((DataInput)in));
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "readRegisteredIndexNames"));
        }
        return tHashSet;
    }

    @NotNull
    private static File getRegisteredIndicesFile() {
        File file = new File(PathManager.getIndexRoot(), "registered");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getRegisteredIndicesFile"));
        }
        return file;
    }

    @NotNull
    private <K, V> UpdatableIndex<K, V, FileContent> createIndex(final @NotNull ID<K, V> indexId, @NotNull FileBasedIndexExtension<K, V> extension, final @NotNull MemoryIndexStorage<K, V> storage) throws StorageException, IOException {
        MapReduceIndex index;
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        if (extension instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex custom = ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(indexId, this, storage);
            if (!(custom instanceof MapReduceIndex)) {
                UpdatableIndex updatableIndex = custom;
                if (updatableIndex == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
                }
                return updatableIndex;
            }
            index = (MapReduceIndex)custom;
        } else {
            index = new MapReduceIndex(indexId, extension.getIndexer(), storage);
        }
        final KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
        index.setInputIdToDataKeysIndex(new Factory<PersistentHashMap<Integer, Collection<K>>>(){

            public PersistentHashMap<Integer, Collection<K>> create() {
                try {
                    return FileBasedIndexImpl.createIdToDataKeysIndex(indexId, keyDescriptor, storage);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        MapReduceIndex mapReduceIndex = index;
        if (mapReduceIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        return mapReduceIndex;
    }

    @NotNull
    public static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(final @NotNull ID<K, ?> indexId, final @NotNull KeyDescriptor<K> keyDescriptor, @NotNull MemoryIndexStorage<K, ?> storage) throws IOException {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "createIdToDataKeysIndex"));
        }
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "createIdToDataKeysIndex"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "createIdToDataKeysIndex"));
        }
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile(indexId);
        final AtomicBoolean isBufferingMode = new AtomicBoolean();
        final TIntObjectHashMap tempMap = new TIntObjectHashMap();
        DataExternalizer dataExternalizer = new DataExternalizer<Collection<K>>(){

            public void save(@NotNull DataOutput out, @NotNull Collection<K> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$9", "save"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl$9", "save"));
                }
                try {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                    for (Object key : value) {
                        keyDescriptor.save(out, key);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Error saving data for index " + indexId, e);
                }
            }

            @NotNull
            public Collection<K> read(@NotNull DataInput in) throws IOException {
                ArrayList<Object> arrayList;
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$9", "read"));
                }
                try {
                    int size = DataInputOutputUtil.readINT((DataInput)in);
                    ArrayList<Object> list = new ArrayList<Object>(size);
                    for (int idx = 0; idx < size; ++idx) {
                        list.add(keyDescriptor.read(in));
                    }
                    arrayList = list;
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Error reading data for index " + indexId, e);
                }
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$9", "read"));
                }
                return arrayList;
            }
        };
        final PersistentHashMap map = new PersistentHashMap<Integer, Collection<K>>(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, dataExternalizer){

            protected Collection<K> doGet(Integer integer) throws IOException {
                Collection collection;
                if (isBufferingMode.get() && (collection = (Collection)tempMap.get(integer.intValue())) != null) {
                    return collection;
                }
                return (Collection)super.doGet((Object)integer);
            }

            protected void doPut(Integer integer, @Nullable Collection<K> ks) throws IOException {
                if (isBufferingMode.get()) {
                    tempMap.put(integer.intValue(), ks == null ? Collections.emptySet() : ks);
                } else {
                    super.doPut((Object)integer, ks);
                }
            }

            protected void doRemove(Integer integer) throws IOException {
                if (isBufferingMode.get()) {
                    tempMap.put(integer.intValue(), Collections.emptySet());
                } else {
                    super.doRemove((Object)integer);
                }
            }
        };
        storage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bufferingStateChanged(boolean newState) {
                PersistentHashMap persistentHashMap = map;
                synchronized (persistentHashMap) {
                    isBufferingMode.set(newState);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void memoryStorageCleared() {
                PersistentHashMap persistentHashMap = map;
                synchronized (persistentHashMap) {
                    tempMap.clear();
                }
            }
        });
        PersistentHashMap persistentHashMap = map;
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createIdToDataKeysIndex"));
        }
        return persistentHashMap;
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                this.myChangedFilesCollector.forceUpdate(null, null, null, true);
                IndexingStamp.flushCaches();
                for (ID<?, ?> indexId : this.myIndices.keySet()) {
                    UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
                    assert (index != null);
                    this.checkRebuild(indexId, true);
                    index.dispose();
                }
                this.myConnection.disconnect();
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        for (ID<?, ?> indexId : new ArrayList(this.myIndices.keySet())) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                this.requestRebuild(indexId);
            }
        }
        if (!HeavyProcessLatch.INSTANCE.isRunning() && modCount == (long)this.myLocalModCount) {
            SerializationManagerEx.getInstanceEx().flushNameStorage();
        }
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getAllKeys"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "getAllKeys"));
        }
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, (Processor<K>)new CommonProcessors.CollectProcessor((Collection)allKeys), project);
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getAllKeys"));
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor, @Nullable Project project) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        return this.processAllKeys(indexId, processor, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        try {
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            this.ensureUpToDate(indexId, scope.getProject(), scope);
            return index.processAllKeys(processor, scope, idFilter);
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    public static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    public static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue = currentValue - 1;
            if (newValue != 0) {
                myUpToDateCheckState.set(newValue);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    private static boolean isUpToDateCheckEnabled() {
        Integer value = myUpToDateCheckState.get();
        return value == null || value == 0;
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "ensureUpToDate"));
        }
        this.ensureUpToDate(indexId, project, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block12: {
            if (indexId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "ensureUpToDate"));
            }
            ProgressManager.checkCanceled();
            this.myContentlessIndicesUpdateQueue.ensureUpToDate();
            if (!this.needsFileContentLoading(indexId)) {
                return;
            }
            if (filter == GlobalSearchScope.EMPTY_SCOPE) {
                return;
            }
            if (FileBasedIndexImpl.isDumb(project)) {
                FileBasedIndexImpl.handleDumbMode(project);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
                if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) break block12;
                try {
                    this.checkRebuild(indexId, false);
                    this.myChangedFilesCollector.forceUpdate(project, filter, restrictedFile, false);
                    this.indexUnsavedDocuments(indexId, project, filter, restrictedFile);
                }
                catch (StorageException e) {
                    this.scheduleRebuild(indexId, e);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, e);
                        break block12;
                    }
                    throw e;
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
    }

    private static void handleDumbMode(@Nullable Project project) {
        BackgroundableProcessIndicator indicator;
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        if (project != null && (progressIndicator = ProgressManager.getInstance().getProgressIndicator()) instanceof BackgroundableProcessIndicator && (indicator = (BackgroundableProcessIndicator)progressIndicator).getDumbModeAction() == DumbModeAction.WAIT) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            DumbService.getInstance((Project)project).waitForSmartMode();
            return;
        }
        throw new IndexNotReadyException();
    }

    private static boolean isDumb(@Nullable Project project) {
        if (project != null) {
            return DumbServiceImpl.getInstance(project).isDumb();
        }
        for (Project proj : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbServiceImpl.getInstance(proj).isDumb()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        SmartList values = new SmartList();
        this.processValuesImpl(indexId, dataKey, true, null, new FileBasedIndex.ValueProcessor<V>((List)values){
            final /* synthetic */ List val$values;
            {
                this.val$values = list;
            }

            public boolean process(VirtualFile file, V value) {
                this.val$values.add(value);
                return true;
            }
        }, filter, null);
        SmartList smartList = values;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        return smartList;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        THashSet files = new THashSet();
        this.processValuesImpl(indexId, dataKey, false, null, new FileBasedIndex.ValueProcessor<V>((Set)files){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            public boolean process(VirtualFile file, V value) {
                this.val$files.add(file);
                return true;
            }
        }, filter, null);
        THashSet tHashSet = files;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        return tHashSet;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        return this.processValuesImpl(indexId, dataKey, false, inFile, processor, filter, idFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter, @NotNull ThrowableConvertor<UpdatableIndex<K, V, FileContent>, R, StorageException> computable) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processExceptions"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "processExceptions"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/indexing/FileBasedIndexImpl", "processExceptions"));
        }
        try {
            UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project = filter.getProject();
            this.ensureUpToDate(indexId, project, filter, restrictToFile);
            try {
                index.getReadLock().lock();
                Object object = computable.convert(index);
                return (R)object;
            }
            finally {
                index.getReadLock().unlock();
            }
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
            return null;
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause == null) throw e;
            this.scheduleRebuild(indexId, cause);
            return null;
        }
        catch (AssertionError ae) {
            this.scheduleRebuild(indexId, (Throwable)((Object)ae));
        }
        return null;
    }

    private <K, V> boolean processValuesImpl(@NotNull ID<K, V> indexId, final @NotNull K dataKey, final boolean ensureValueProcessedOnce, final @Nullable VirtualFile restrictToFile, final @NotNull FileBasedIndex.ValueProcessor<V> processor, final @NotNull GlobalSearchScope scope, final @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesImpl"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesImpl"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesImpl"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesImpl"));
        }
        ThrowableConvertor keyProcessor = new ThrowableConvertor<UpdatableIndex<K, V, FileContent>, Boolean, StorageException>(){

            public Boolean convert(@NotNull UpdatableIndex<K, V, FileContent> index) throws StorageException {
                boolean shouldContinue;
                block5: {
                    ValueContainer container;
                    block6: {
                        if (index == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$15", "convert"));
                        }
                        container = index.getData(dataKey);
                        shouldContinue = true;
                        if (restrictToFile == null) break block6;
                        if (!(restrictToFile instanceof VirtualFileWithId)) break block5;
                        int restrictedFileId = FileBasedIndex.getFileId((VirtualFile)restrictToFile);
                        ValueContainer.ValueIterator valueIt = container.getValueIterator();
                        while (valueIt.hasNext()) {
                            Object value = valueIt.next();
                            if (!valueIt.getValueAssociationPredicate().contains(restrictedFileId) || (shouldContinue = processor.process(restrictToFile, value))) continue;
                            break block5;
                        }
                        break block5;
                    }
                    PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
                    IdFilter filter = idFilter != null ? idFilter : FileBasedIndexImpl.this.projectIndexableFiles(scope.getProject());
                    ValueContainer.ValueIterator valueIt = container.getValueIterator();
                    block1: while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                        while (inputIdsIterator.hasNext()) {
                            VirtualFile file;
                            int id = inputIdsIterator.next();
                            if (filter != null && !filter.containsFileId(id) || (file = IndexInfrastructure.findFileByIdIfCached(fs, id)) == null || !scope.accept(file)) continue;
                            shouldContinue = processor.process(file, value);
                            if (shouldContinue) {
                                if (!ensureValueProcessedOnce) continue;
                                continue block1;
                            }
                            break block5;
                        }
                    }
                }
                return shouldContinue;
            }
        };
        Boolean result = (Boolean)this.processExceptions(indexId, restrictToFile, scope, keyProcessor);
        return result == null || result != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<V> valueChecker, @NotNull Processor<VirtualFile> processor) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        ProjectIndexableFilesFilter filesSet = this.projectIndexableFiles(filter.getProject());
        TIntHashSet set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter, valueChecker, filesSet);
        return set != null && FileBasedIndexImpl.processVirtualFiles(set, filter, processor);
    }

    public void filesUpdateEnumerationFinished() {
        this.myContentlessIndicesUpdateQueue.ensureUpToDate();
        this.myContentlessIndicesUpdateQueue.signalUpdateEnd();
    }

    void filesUpdateStarted(Project project) {
        this.myContentlessIndicesUpdateQueue.signalUpdateStart();
        this.myContentlessIndicesUpdateQueue.ensureUpToDate();
        this.myProjectsBeingUpdated.add((Object)project);
    }

    void filesUpdateFinished(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "filesUpdateFinished"));
        }
        this.myProjectsBeingUpdated.remove((Object)project);
        ++this.myFilesModCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project) {
        if (project == null || this.myUpdatingFiles.get() > 0) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains((Object)project)) {
            return null;
        }
        SoftReference reference = (SoftReference)project.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
        if (data != null && data.myModificationCount == this.myFilesModCount) {
            return data;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference = (SoftReference)project.getUserData(ourProjectFilesSetKey);
                data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
                if (data != null && data.myModificationCount == this.myFilesModCount) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = data;
                    return projectIndexableFilesFilter;
                }
                long start = System.currentTimeMillis();
                final TIntArrayList filesSet = new TIntArrayList();
                this.iterateIndexableFiles(new ContentIterator(){

                    public boolean processFile(@NotNull VirtualFile fileOrDir) {
                        if (fileOrDir == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$16", "processFile"));
                        }
                        filesSet.add(((VirtualFileWithId)fileOrDir).getId());
                        return true;
                    }
                }, project, (ProgressIndicator)SilentProgressIndicator.create());
                ProjectIndexableFilesFilter filter = new ProjectIndexableFilesFilter(filesSet, this.myFilesModCount);
                project.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter));
                long finish = System.currentTimeMillis();
                LOG.debug(filesSet.size() + " files iterated in " + (finish - start) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    private <K, V> TIntHashSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, final @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter, final @Nullable Condition<V> valueChecker, final @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "collectFileIdsContainingAllKeys"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "collectFileIdsContainingAllKeys"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "collectFileIdsContainingAllKeys"));
        }
        ThrowableConvertor convertor = new ThrowableConvertor<UpdatableIndex<K, V, FileContent>, TIntHashSet, StorageException>(){

            @Nullable
            public TIntHashSet convert(@NotNull UpdatableIndex<K, V, FileContent> index) throws StorageException {
                if (index == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$17", "convert"));
                }
                TIntHashSet mainIntersection = null;
                for (Object dataKey : dataKeys) {
                    ProgressManager.checkCanceled();
                    final TIntHashSet copy = new TIntHashSet();
                    ValueContainer container = index.getData(dataKey);
                    final ValueContainer.ValueIterator valueIt = container.getValueIterator();
                    while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        if (valueChecker != null && !valueChecker.value(value)) continue;
                        ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                        if (mainIntersection == null || iterator.size() < mainIntersection.size()) {
                            while (iterator.hasNext()) {
                                int id = iterator.next();
                                if ((mainIntersection != null || projectFilesFilter != null && !projectFilesFilter.containsFileId(id)) && (mainIntersection == null || !mainIntersection.contains(id))) continue;
                                copy.add(id);
                            }
                            continue;
                        }
                        mainIntersection.forEach(new TIntProcedure(){
                            final ValueContainer.IntPredicate predicate;
                            {
                                this.predicate = valueIt.getValueAssociationPredicate();
                            }

                            public boolean execute(int id) {
                                if (this.predicate.contains(id)) {
                                    copy.add(id);
                                }
                                return true;
                            }
                        });
                    }
                    mainIntersection = copy;
                    if (!mainIntersection.isEmpty()) continue;
                    return new TIntHashSet();
                }
                return mainIntersection;
            }
        };
        return (TIntHashSet)this.processExceptions(indexId, null, filter, convertor);
    }

    private static boolean processVirtualFiles(@NotNull TIntHashSet ids, final @NotNull GlobalSearchScope filter, final @NotNull Processor<VirtualFile> processor) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processVirtualFiles"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processVirtualFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "processVirtualFiles"));
        }
        final PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        return ids.forEach(new TIntProcedure(){

            public boolean execute(int id) {
                ProgressManager.checkCanceled();
                VirtualFile file = IndexInfrastructure.findFileByIdIfCached(fs, id);
                if (file != null && filter.accept(file)) {
                    return processor.process((Object)file);
                }
                return true;
            }
        });
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getCauseToRebuildIndex"));
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<K> dataKeys, @NotNull Processor<VirtualFile> processor, @NotNull GlobalSearchScope filter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        try {
            UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            Project project = filter.getProject();
            this.ensureUpToDate(indexId, project, filter);
            try {
                VirtualFile file;
                int id;
                index.getReadLock().lock();
                ArrayList<TIntHashSet> locals = new ArrayList<TIntHashSet>();
                for (K dataKey : dataKeys) {
                    TIntHashSet local = new TIntHashSet();
                    locals.add(local);
                    ValueContainer container = index.getData(dataKey);
                    ValueContainer.ValueIterator valueIt = container.getValueIterator();
                    while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                        while (inputIdsIterator.hasNext()) {
                            int id2 = inputIdsIterator.next();
                            local.add(id2);
                        }
                    }
                }
                if (locals.isEmpty()) {
                    boolean i$ = true;
                    return i$;
                }
                Collections.sort(locals, new Comparator<TIntHashSet>(){

                    @Override
                    public int compare(TIntHashSet o1, TIntHashSet o2) {
                        return o1.size() - o2.size();
                    }
                });
                PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
                TIntIterator ids = FileBasedIndexImpl.join(locals).iterator();
                ProjectIndexableFilesFilter projectIndexableFilesFilter = this.projectIndexableFiles(project);
                do {
                    if (!ids.hasNext()) return true;
                    id = ids.next();
                } while (projectIndexableFilesFilter != null && !projectIndexableFilesFilter.containsFileId(id) || (file = IndexInfrastructure.findFileByIdIfCached(fs, id)) == null || !filter.accept(file) || processor.process((Object)file));
                boolean bl = false;
                return bl;
            }
            finally {
                index.getReadLock().unlock();
            }
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
            return true;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof StorageException)) {
                if (!(cause instanceof IOException)) throw e;
            }
            this.scheduleRebuild(indexId, cause);
            return true;
        }
        catch (AssertionError ae) {
            this.scheduleRebuild(indexId, (Throwable)((Object)ae));
        }
        return true;
    }

    @NotNull
    private static TIntHashSet join(@NotNull List<TIntHashSet> locals) {
        if (locals == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "join"));
        }
        TIntHashSet result = locals.get(0);
        if (locals.size() > 1) {
            TIntIterator it = result.iterator();
            block0: while (it.hasNext()) {
                int id = it.next();
                for (int i = 1; i < locals.size(); ++i) {
                    if (locals.get(i).contains(id)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        TIntHashSet tIntHashSet = result;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "join"));
        }
        return tIntHashSet;
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "scheduleRebuild"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "scheduleRebuild"));
        }
        this.requestRebuild(indexId, new Throwable(e));
        try {
            this.checkRebuild(indexId, false);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private void checkRebuild(final @NotNull ID<?, ?> indexId, final boolean cleanupOnly) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "checkRebuild"));
        }
        final AtomicInteger status = ourRebuildStatus.get(indexId);
        if (status.get() == 1) {
            return;
        }
        if (status.compareAndSet(2, 3)) {
            FileBasedIndexImpl.cleanupProcessedFlag();
            this.advanceIndexVersion(indexId);
            final Runnable rebuildRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FileBasedIndexImpl.this.doClearIndex(indexId);
                        if (!cleanupOnly) {
                            FileBasedIndexImpl.this.scheduleIndexRebuild(false);
                        }
                    }
                    catch (StorageException e) {
                        FileBasedIndexImpl.this.requestRebuild(indexId);
                        LOG.info((Throwable)e);
                    }
                    finally {
                        status.compareAndSet(3, 1);
                    }
                }
            };
            if (cleanupOnly || this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Task.Modal(null, "Updating index", false){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$21$1", "run"));
                                }
                                indicator.setIndeterminate(true);
                                rebuildRunnable.run();
                            }
                        }.queue();
                    }
                }, ModalityState.NON_MODAL);
            }
        }
        if (status.get() == 3) {
            throw new ProcessCanceledException();
        }
    }

    private void scheduleIndexRebuild(boolean forceDumbMode) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Set<CacheUpdater> updatersToRun = Collections.singleton(new UnindexedFilesUpdater(project, this));
            DumbServiceImpl service = DumbServiceImpl.getInstance(project);
            if (forceDumbMode) {
                service.queueCacheUpdateInDumbMode(updatersToRun);
                continue;
            }
            service.queueCacheUpdate(updatersToRun);
        }
    }

    private void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "clearIndex"));
        }
        this.advanceIndexVersion(indexId);
        this.doClearIndex(indexId);
    }

    private void doClearIndex(ID<?, ?> indexId) throws StorageException {
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null) : "Index with key " + indexId + " not found or not registered properly";
        index.clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexInfrastructure.rewriteVersion(IndexInfrastructure.getVersionFile(indexId), this.myIndexIdToVersionMap.get(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        THashSet tHashSet = new THashSet(Arrays.asList(this.myFileDocumentManager.getUnsavedDocuments()));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getUnsavedDocuments"));
        }
        return tHashSet;
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set set = this.myTransactionMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getTransactedDocuments"));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project, GlobalSearchScope filter, VirtualFile restrictedFile) throws StorageException {
        Set<Document> documents;
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocuments"));
        }
        if (this.myUpToDateIndices.contains(indexId)) {
            return;
        }
        Set<Document> set = documents = this.myPsiDependentIndices.contains(indexId) ? this.getTransactedDocuments() : this.getUnsavedDocuments();
        if (!documents.isEmpty()) {
            StorageGuard.Holder guard = this.setDataBufferingEnabled(true);
            try {
                Semaphore semaphore = this.myUnsavedDataIndexingSemaphores.get(indexId);
                assert (semaphore != null) : "Semaphore for unsaved data indexing was not initialized for index " + indexId;
                semaphore.down();
                boolean allDocsProcessed = true;
                try {
                    for (Document document : documents) {
                        allDocsProcessed &= this.indexUnsavedDocument(document, indexId, project, filter, restrictedFile);
                        ProgressManager.checkCanceled();
                    }
                }
                finally {
                    semaphore.up();
                    while (!semaphore.waitFor(500L)) {
                        ProgressManager.checkCanceled();
                        if (!Thread.holdsLock(PsiLock.LOCK)) continue;
                    }
                    if (allDocsProcessed && !this.hasActiveTransactions()) {
                        ProgressManager.checkCanceled();
                        this.myUpToDateIndices.add(indexId);
                    }
                }
            }
            finally {
                guard.leave();
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block16: {
            long previousDocStamp;
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocument"));
            }
            if (requestedIndexId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocument"));
            }
            VirtualFile vFile = this.myFileDocumentManager.getFile(document);
            if (!(vFile instanceof VirtualFileWithId) || !vFile.isValid()) {
                return true;
            }
            if (restrictedFile != null ? !Comparing.equal((Object)vFile, (Object)restrictedFile) : filter != null && !filter.accept(vFile)) {
                return false;
            }
            PsiFile dominantContentFile = this.findDominantPsiForDocument(document, project);
            DocumentContent content = dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
            long currentDocStamp = content.getModificationStamp();
            if (currentDocStamp != (previousDocStamp = this.myLastIndexedDocStamps.getAndSet(document, requestedIndexId, currentDocStamp))) {
                CharSequence contentText = content.getText();
                FileTypeManagerImpl.cacheFileType(vFile, FileBasedIndexImpl.getFileType(vFile));
                try {
                    FileContentImpl newFc;
                    if (this.isTooLarge(vFile, contentText.length()) || !this.getAffectedIndexCandidates(vFile).contains(requestedIndexId) || !this.getInputFilter(requestedIndexId).acceptInput(vFile)) break block16;
                    WeakReference previousContentRef = (WeakReference)document.getUserData(ourFileContentKey);
                    FileContentImpl previousContent = (FileContentImpl)((Object)com.intellij.reference.SoftReference.dereference((Reference)previousContentRef));
                    if (previousContent != null && previousContent.getStamp() == currentDocStamp) {
                        newFc = previousContent;
                    } else {
                        newFc = new FileContentImpl(vFile, contentText, vFile.getCharset(), currentDocStamp);
                        document.putUserData(ourFileContentKey, new WeakReference<FileContentImpl>(newFc));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, project, dominantContentFile);
                    if (content instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)vFile));
                    try {
                        this.getIndex(requestedIndexId).update(inputId, newFc).compute();
                    }
                    catch (ProcessCanceledException pce) {
                        this.myLastIndexedDocStamps.getAndSet(document, requestedIndexId, previousDocStamp);
                        throw pce;
                    }
                    finally {
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                }
                finally {
                    FileTypeManagerImpl.cacheFileType(vFile, null);
                }
            }
        }
        return true;
    }

    @Nullable
    private PsiFile findDominantPsiForDocument(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "findDominantPsiForDocument"));
        }
        PsiFile psiFile = (PsiFile)this.myTransactionMap.get((Object)document);
        if (psiFile != null) {
            return psiFile;
        }
        return project == null ? null : FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project);
    }

    @NotNull
    private StorageGuard.Holder setDataBufferingEnabled(boolean enabled) {
        StorageGuard.Holder holder = this.myStorageLock.enter(enabled);
        for (ID<?, ?> indexId : this.myIndices.keySet()) {
            MapReduceIndex index = (MapReduceIndex)this.getIndex(indexId);
            assert (index != null);
            if (this.myPsiDependentIndices.contains(indexId)) continue;
            IndexStorage indexStorage = index.getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
        StorageGuard.Holder holder2 = holder;
        if (holder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "setDataBufferingEnabled"));
        }
        return holder2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMemoryStorage() {
        this.myLastIndexedDocStamps.clear();
        for (ID<?, ?> indexId : this.myIndices.keySet()) {
            MapReduceIndex index = (MapReduceIndex)this.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            index.getWriteLock().lock();
            try {
                memStorage.clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
            memStorage.fireMemoryStorageCleared();
        }
    }

    private void dropUnregisteredIndices() {
        Set<String> indicesToDrop = FileBasedIndexImpl.readRegisteredIndexNames();
        for (ID<?, ?> key : this.myIndices.keySet()) {
            indicesToDrop.remove(key.toString());
        }
        for (String s : indicesToDrop) {
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
        }
    }

    public void requestRebuild(ID<?, ?> indexId, Throwable throwable) {
        FileBasedIndexImpl.cleanupProcessedFlag();
        boolean requiresRebuildWasSet = ourRebuildStatus.get(indexId).compareAndSet(1, 2);
        if (requiresRebuildWasSet) {
            LOG.info("Rebuild requested for index " + indexId, throwable);
        }
    }

    private <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair = this.myIndices.get(indexId);
        assert (pair != null) : "Index data is absent for index " + indexId;
        return (UpdatableIndex)pair.getFirst();
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getInputFilter"));
        }
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair = this.myIndices.get(indexId);
        assert (pair != null) : "Index data is absent for index " + indexId;
        return (FileBasedIndex.InputFilter)pair.getSecond();
    }

    public int getNumberOfPendingInvalidations() {
        return this.myChangedFilesCollector.getNumberOfPendingInvalidations();
    }

    @NotNull
    public Collection<VirtualFile> getFilesToUpdate(final Project project) {
        List list = ContainerUtil.findAll(this.myChangedFilesCollector.getAllFilesToUpdate(), (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                for (IndexableFileSet set : FileBasedIndexImpl.this.myIndexableSets) {
                    Project proj = (Project)FileBasedIndexImpl.this.myIndexableSetToProjectMap.get(set);
                    if (proj != null && !proj.equals(project) || !set.isInSet(virtualFile)) continue;
                    return true;
                }
                return false;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesToUpdate"));
        }
        return list;
    }

    public boolean isFileUpToDate(VirtualFile file) {
        return !this.myChangedFilesCollector.myFilesToUpdate.contains(file);
    }

    void processRefreshedFile(@NotNull Project project, @NotNull com.intellij.ide.caches.FileContent fileContent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "processRefreshedFile"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "processRefreshedFile"));
        }
        this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
        this.myChangedFilesCollector.processFileImpl(project, fileContent, false);
    }

    public void indexFileContent(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "indexFileContent"));
        }
        VirtualFile file = content.getVirtualFile();
        this.myChangedFilesCollector.myFilesToUpdate.remove(file);
        this.doIndexFileContent(project, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIndexFileContent(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "doIndexFileContent"));
        }
        this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
        VirtualFile file = content.getVirtualFile();
        FileTypeManagerImpl.cacheFileType(file, FileBasedIndexImpl.getFileType(file));
        try {
            PsiFile psiFile = null;
            FileContentImpl fc = null;
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(file);
            int size = affectedIndexCandidates.size();
            for (int i = 0; i < size; ++i) {
                ID<?, ?> indexId = affectedIndexCandidates.get(i);
                if (!this.shouldIndexFile(file, indexId)) continue;
                if (fc == null) {
                    byte[] currentBytes;
                    try {
                        currentBytes = content.getBytes();
                    }
                    catch (IOException e) {
                        currentBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
                    }
                    fc = new FileContentImpl(file, currentBytes);
                    if (project == null) {
                        project = ProjectUtil.guessProjectForFile((VirtualFile)file);
                    }
                    psiFile = (PsiFile)content.getUserData(IndexingDataKeys.PSI_FILE);
                    FileBasedIndexImpl.initFileContent(fc, project, psiFile);
                }
                try {
                    ProgressManager.checkCanceled();
                    this.updateSingleIndex(indexId, file, fc);
                    continue;
                }
                catch (ProcessCanceledException e) {
                    FileBasedIndexImpl.cleanFileContent(fc, psiFile);
                    this.myChangedFilesCollector.scheduleForUpdate(file);
                    throw e;
                }
                catch (StorageException e) {
                    this.requestRebuild(indexId);
                    LOG.info((Throwable)e);
                }
            }
            if (psiFile != null) {
                psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
            }
        }
        finally {
            FileTypeManagerImpl.cacheFileType(file, null);
        }
    }

    @NotNull
    public static FileType getFileType(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "getFileType"));
        }
        FileType fileType = file.getFileType();
        if (fileType == FileTypes.PLAIN_TEXT && FileTypeManagerImpl.isFileTypeDetectedFromContent(file)) {
            fileType = FileTypes.UNKNOWN;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getFileType"));
        }
        return fileType2;
    }

    public boolean isIndexingCandidate(VirtualFile file, ID<?, ?> indexId) {
        return !this.isTooLarge(file) && this.getAffectedIndexCandidates(file).contains(indexId);
    }

    private List<ID<?, ?>> getAffectedIndexCandidates(VirtualFile file) {
        if (file.isDirectory()) {
            return FileBasedIndexImpl.isProjectOrWorkspaceFile(file, null) ? Collections.emptyList() : this.myIndicesForDirectories;
        }
        FileType fileType = FileBasedIndexImpl.getFileType(file);
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(file, fileType)) {
            return Collections.emptyList();
        }
        List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
        if (ids == null) {
            ids = this.myIndicesWithoutFileTypeInfo;
        }
        return ids;
    }

    private static void cleanFileContent(FileContentImpl fc, PsiFile psiFile) {
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)false);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(FileContentImpl fc, Project project, PsiFile psiFile) {
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc.putUserData(IndexingDataKeys.PROJECT, project);
    }

    private void updateSingleIndex(@NotNull ID<?, ?> indexId, @NotNull VirtualFile file, @Nullable FileContent currentFC) throws StorageException {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "updateSingleIndex"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "updateSingleIndex"));
        }
        if (ourRebuildStatus.get(indexId).get() == 2) {
            return;
        }
        ++this.myLocalModCount;
        int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)file));
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        Computable<Boolean> update = index.update(inputId, currentFC);
        this.scheduleUpdate(indexId, this.createUpdateComputableWithBufferingDisabled(update), this.createIndexedStampUpdateRunnable(indexId, file, currentFC != null));
    }

    @NotNull
    private Runnable createIndexedStampUpdateRunnable(final @NotNull ID<?, ?> indexId, final @NotNull VirtualFile file, final boolean hasContent) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndexedStampUpdateRunnable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndexedStampUpdateRunnable"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (file.isValid()) {
                    if (hasContent) {
                        IndexingStamp.update(file, indexId, IndexInfrastructure.getIndexCreationStamp(indexId));
                    } else {
                        IndexingStamp.update(file, indexId, -1L);
                    }
                    if (FileBasedIndexImpl.this.myNotRequiringContentIndices.contains(indexId)) {
                        IndexingStamp.flushCache(file);
                    }
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndexedStampUpdateRunnable"));
        }
        return runnable;
    }

    @NotNull
    private Computable<Boolean> createUpdateComputableWithBufferingDisabled(final @NotNull Computable<Boolean> update) {
        if (update == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "createUpdateComputableWithBufferingDisabled"));
        }
        Computable<Boolean> computable = new Computable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean compute() {
                Boolean result;
                StorageGuard.Holder lock = FileBasedIndexImpl.this.setDataBufferingEnabled(false);
                try {
                    result = (Boolean)update.compute();
                }
                finally {
                    lock.leave();
                }
                return result;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createUpdateComputableWithBufferingDisabled"));
        }
        return computable;
    }

    private void scheduleUpdate(ID<?, ?> indexId, Computable<Boolean> update, Runnable successRunnable) {
        if (this.myNotRequiringContentIndices.contains(indexId)) {
            this.myContentlessIndicesUpdateQueue.submit(update, successRunnable);
        } else {
            Boolean result = (Boolean)update.compute();
            if (result == Boolean.TRUE) {
                ApplicationManager.getApplication().runReadAction(successRunnable);
            }
        }
    }

    private boolean needsFileContentLoading(ID<?, ?> indexId) {
        return !this.myNotRequiringContentIndices.contains(indexId);
    }

    @Nullable
    private IndexableFileSet getIndexableSetForFile(VirtualFile file) {
        for (IndexableFileSet set : this.myIndexableSets) {
            if (!set.isInSet(file)) continue;
            return set;
        }
        return null;
    }

    private List<ID<?, ?>> calculateAffectedContentIndices(VirtualFile file) {
        ArrayList affected = new ArrayList();
        for (ID<?, ?> indexId : this.getAffectedIndexCandidates(file)) {
            if (!this.needsFileContentLoading(indexId) || !this.getInputFilter(indexId).acceptInput(file)) continue;
            affected.add(indexId);
        }
        return affected;
    }

    private boolean shouldIndexFile(@NotNull VirtualFile file, @NotNull ID<?, ?> indexId) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "shouldIndexFile"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "shouldIndexFile"));
        }
        return this.getInputFilter(indexId).acceptInput(file) && (FileBasedIndexImpl.isMock(file) || !FileBasedIndexImpl.isFileIndexed(file, indexId));
    }

    private static boolean isFileIndexed(VirtualFile file, @NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "isFileIndexed"));
        }
        return IndexingStamp.isFileIndexed(file, indexId, IndexInfrastructure.getIndexCreationStamp(indexId));
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "isUnderConfigOrSystem"));
        }
        String filePath = file.getPath();
        return this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath) || this.myLogPath != null && FileUtil.startsWith((String)filePath, (String)this.myLogPath);
    }

    private static boolean isMock(VirtualFile file) {
        return !(file instanceof NewVirtualFile);
    }

    private boolean isTooLarge(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "isTooLarge"));
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file)) {
            return !this.myNoLimitCheckTypes.contains(FileBasedIndexImpl.getFileType(file));
        }
        return false;
    }

    private boolean isTooLarge(@NotNull VirtualFile file, long contentSize) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "isTooLarge"));
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file, contentSize)) {
            return !this.myNoLimitCheckTypes.contains(FileBasedIndexImpl.getFileType(file));
        }
        return false;
    }

    @NotNull
    public CollectingContentIterator createContentIterator(@Nullable ProgressIndicator indicator) {
        UnindexedFilesFinder unindexedFilesFinder = new UnindexedFilesFinder(indicator);
        if (unindexedFilesFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createContentIterator"));
        }
        return unindexedFilesFinder;
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set, @Nullable Project project) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "registerIndexableSet"));
        }
        this.myIndexableSets.add(set);
        this.myIndexableSetToProjectMap.put(set, project);
        if (project != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).addTreeChangePreprocessor(new PsiTreeChangePreprocessor(){

                @Override
                public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
                    VirtualFile virtualFile;
                    PsiFile file;
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$25", "treeChanged"));
                    }
                    if (event.isGenericChange() && event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED && (file = event.getFile()) != null && (virtualFile = file.getVirtualFile()) instanceof VirtualFileWithId) {
                        boolean wasIndexed = false;
                        for (ID psiBackedIndex : FileBasedIndexImpl.this.myPsiDependentIndices) {
                            if (!FileBasedIndexImpl.isFileIndexed(virtualFile, psiBackedIndex)) continue;
                            IndexingStamp.update(virtualFile, psiBackedIndex, -2L);
                            wasIndexed = true;
                        }
                        if (wasIndexed) {
                            FileBasedIndexImpl.this.myChangedFilesCollector.scheduleForUpdate(virtualFile);
                            IndexingStamp.flushCache(virtualFile);
                        }
                    }
                }
            });
        }
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "removeIndexableSet"));
        }
        if (!this.myIndexableSetToProjectMap.containsKey(set)) {
            return;
        }
        this.myChangedFilesCollector.forceUpdate(this.myIndexableSetToProjectMap.get(set), null, null, true);
        IndexingStamp.flushCaches();
        this.myIndexableSets.remove(set);
        this.myIndexableSetToProjectMap.remove(set);
    }

    public VirtualFile findFileById(Project project, int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "findLatestKnownPsiForUncomittedDocument"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "findLatestKnownPsiForUncomittedDocument"));
        }
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    private static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndexImpl.cleanProcessedFlag(root);
        }
    }

    private static void cleanProcessedFlag(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "cleanProcessedFlag"));
        }
        if (!(file instanceof VirtualFileSystemEntry)) {
            return;
        }
        VirtualFileSystemEntry nvf = (VirtualFileSystemEntry)file;
        if (file.isDirectory()) {
            nvf.setFileIndexed(false);
            for (VirtualFile child : nvf.getCachedChildren()) {
                FileBasedIndexImpl.cleanProcessedFlag(child);
            }
        } else {
            nvf.setFileIndexed(false);
        }
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor, @NotNull Project project, ProgressIndicator indicator) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateIndexableFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateIndexableFiles"));
        }
        if (project.isDisposed()) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        projectFileIndex.iterateContent(processor);
        if (project.isDisposed()) {
            return;
        }
        THashSet visitedRoots = new THashSet();
        for (IndexedRootsProvider indexedRootsProvider : (IndexedRootsProvider[])Extensions.getExtensions(IndexedRootsProvider.EP_NAME)) {
            if (project.isDisposed()) {
                return;
            }
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex(indexedRootsProvider)) {
                if (!visitedRoots.add(root)) continue;
                FileBasedIndexImpl.iterateRecursively(root, processor, indicator);
            }
            for (VirtualFile root : IndexableSetContributor.getProjectRootsToIndex(indexedRootsProvider, project)) {
                if (!visitedRoots.add(root)) continue;
                FileBasedIndexImpl.iterateRecursively(root, processor, indicator);
            }
        }
        if (project.isDisposed()) {
            return;
        }
        for (IndexedRootsProvider indexedRootsProvider : ModuleManager.getInstance((Project)project).getModules()) {
            OrderEntry[] orderEntries;
            if (indexedRootsProvider.isDisposed()) {
                return;
            }
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)indexedRootsProvider).getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid()) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] libSources = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
                VirtualFile[][] arr$ = new VirtualFile[][]{libSources, libClasses};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    VirtualFile[] roots;
                    for (VirtualFile root : roots = arr$[i$]) {
                        if (!visitedRoots.add(root)) continue;
                        FileBasedIndexImpl.iterateRecursively(root, processor, indicator);
                    }
                }
            }
        }
    }

    private static void iterateRecursively(@Nullable VirtualFile root, final @NotNull ContentIterator processor, final @Nullable ProgressIndicator indicator) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateRecursively"));
        }
        if (root == null) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$26", "visitFile"));
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                processor.processFile(file);
                return true;
            }
        });
    }

    private static class StorageGuard {
        private int myHolds = 0;
        private final Holder myTrueHolder = new Holder(){

            @Override
            public void leave() {
                StorageGuard.this.leave(true);
            }
        };
        private final Holder myFalseHolder = new Holder(){

            @Override
            public void leave() {
                StorageGuard.this.leave(false);
            }
        };

        private StorageGuard() {
        }

        @NotNull
        public synchronized Holder enter(boolean mode) {
            if (mode) {
                while (this.myHolds < 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {}
                }
                ++this.myHolds;
                Holder holder = this.myTrueHolder;
                if (holder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$StorageGuard", "enter"));
                }
                return holder;
            }
            while (this.myHolds > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.myHolds;
            Holder holder = this.myFalseHolder;
            if (holder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$StorageGuard", "enter"));
            }
            return holder;
        }

        private synchronized void leave(boolean mode) {
            this.myHolds += mode ? -1 : 1;
            if (this.myHolds == 0) {
                this.notifyAll();
            }
        }

        public static interface Holder {
            public void leave();
        }
    }

    private static class IndexableFilesFilter
    implements FileBasedIndex.InputFilter {
        private final FileBasedIndex.InputFilter myDelegate;

        private IndexableFilesFilter(FileBasedIndex.InputFilter delegate) {
            this.myDelegate = delegate;
        }

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$IndexableFilesFilter", "acceptInput"));
            }
            return file instanceof VirtualFileWithId && this.myDelegate.acceptInput(file);
        }
    }

    private class UnindexedFilesFinder
    implements CollectingContentIterator {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        @Nullable
        private final ProgressIndicator myProgressIndicator;

        private UnindexedFilesFinder(ProgressIndicator indicator) {
            this.myProgressIndicator = indicator;
        }

        @NotNull
        public List<VirtualFile> getFiles() {
            List<VirtualFile> list = this.myFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder", "getFiles"));
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean processFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder", "processFile"));
            }
            if (!file.isValid()) {
                return true;
            }
            if (file instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file).isFileIndexed()) {
                return true;
            }
            if (file instanceof VirtualFileWithId) {
                try {
                    FileTypeManagerImpl.cacheFileType(file, FileBasedIndexImpl.getFileType(file));
                    boolean oldStuff = true;
                    if (file.isDirectory() || !FileBasedIndexImpl.this.isTooLarge(file)) {
                        List affectedIndexCandidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file);
                        int size = affectedIndexCandidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID indexId = (ID)affectedIndexCandidates.get(i);
                            try {
                                if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.shouldIndexFile(file, indexId)) continue;
                                this.myFiles.add(file);
                                oldStuff = false;
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info((Throwable)e);
                                    FileBasedIndexImpl.this.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    FileContentImpl fileContent = null;
                    for (ID indexId : FileBasedIndexImpl.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndexImpl.this.shouldIndexFile(file, indexId)) continue;
                        oldStuff = false;
                        try {
                            if (fileContent == null) {
                                fileContent = new FileContentImpl(file);
                            }
                            FileBasedIndexImpl.this.updateSingleIndex(indexId, file, fileContent);
                        }
                        catch (StorageException e) {
                            LOG.info((Throwable)e);
                            FileBasedIndexImpl.this.requestRebuild(indexId);
                        }
                    }
                    IndexingStamp.flushCache(file);
                    if (oldStuff && file instanceof VirtualFileSystemEntry) {
                        ((VirtualFileSystemEntry)file).setFileIndexed(true);
                    }
                }
                finally {
                    FileTypeManagerImpl.cacheFileType(file, null);
                }
                if (this.myProgressIndicator != null && file.isDirectory()) {
                    this.myProgressIndicator.checkCanceled();
                    this.myProgressIndicator.setText("Scanning files to index");
                }
            }
            return true;
        }
    }

    private final class ChangedFilesCollector
    extends VirtualFileAdapter
    implements BulkFileListener {
        private final Set<VirtualFile> myFilesToUpdate = new ConcurrentHashSet();
        private final Queue<InvalidationTask> myFutureInvalidations = new ConcurrentLinkedQueue<InvalidationTask>();
        private final ManagingFS myManagingFS = ManagingFS.getInstance();
        private final AtomicReference<UpdateSemaphore> myUpdateSemaphoreRef = new AtomicReference<Object>(null);

        private ChangedFilesCollector() {
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "fileMoved"));
            }
            this.markDirty((VirtualFileEvent)event, false);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "fileCreated"));
            }
            this.markDirty(event, false);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "fileDeleted"));
            }
            this.myFilesToUpdate.remove(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "fileCopied"));
            }
            this.markDirty((VirtualFileEvent)event, false);
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "beforeFileDeletion"));
            }
            this.invalidateIndices(event.getFile(), false);
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "beforeContentsChange"));
            }
            this.invalidateIndices(event.getFile(), true);
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "contentsChanged"));
            }
            this.markDirty(event, true);
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "beforePropertyChange"));
            }
            if (event.getPropertyName().equals("name")) {
                VirtualFile file = event.getFile();
                this.invalidateIndices(file, false);
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "propertyChanged"));
            }
            if (event.getPropertyName().equals("name")) {
                this.markDirty((VirtualFileEvent)event, false);
            }
        }

        private void markDirty(@NotNull VirtualFileEvent event, boolean contentChange) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "markDirty"));
            }
            VirtualFile eventFile = event.getFile();
            FileBasedIndexImpl.cleanProcessedFlag(eventFile);
            if (!contentChange) {
                FileBasedIndexImpl.this.myUpdatingFiles.incrementAndGet();
            }
            this.iterateIndexableFiles(eventFile, new Processor<VirtualFile>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector$1", "process"));
                    }
                    FileContentImpl fileContent = null;
                    boolean fileIsDirectory = file.isDirectory();
                    for (ID indexId : fileIsDirectory ? FileBasedIndexImpl.this.myIndicesForDirectories : FileBasedIndexImpl.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndexImpl.this.getInputFilter(indexId).acceptInput(file)) continue;
                        try {
                            if (fileContent == null) {
                                fileContent = new FileContentImpl(file);
                            }
                            FileBasedIndexImpl.this.updateSingleIndex(indexId, file, fileContent);
                        }
                        catch (StorageException e) {
                            LOG.info((Throwable)e);
                            FileBasedIndexImpl.this.requestRebuild(indexId);
                        }
                    }
                    if (!fileIsDirectory) {
                        if (FileBasedIndexImpl.this.isTooLarge(file)) {
                            FileBasedIndexImpl.this.myChangedFilesCollector.myFilesToUpdate.remove(file);
                        } else {
                            FileTypeManagerImpl.cacheFileType(file, FileBasedIndexImpl.getFileType(file));
                            try {
                                List candidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file);
                                boolean scheduleForUpdate = false;
                                boolean resetStamp = false;
                                int size = candidates.size();
                                for (int i = 0; i < size; ++i) {
                                    ID indexId = (ID)candidates.get(i);
                                    if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.getInputFilter(indexId).acceptInput(file)) continue;
                                    if (IndexingStamp.isFileIndexed(file, indexId, IndexInfrastructure.getIndexCreationStamp(indexId))) {
                                        IndexingStamp.update(file, indexId, -2L);
                                        resetStamp = true;
                                    }
                                    scheduleForUpdate = true;
                                }
                                if (scheduleForUpdate) {
                                    if (resetStamp) {
                                        IndexingStamp.flushCache(file);
                                    }
                                    ChangedFilesCollector.this.scheduleForUpdate(file);
                                }
                            }
                            finally {
                                FileTypeManagerImpl.cacheFileType(file, null);
                            }
                        }
                    }
                    return true;
                }
            });
            IndexingStamp.flushCaches();
            if (!contentChange && FileBasedIndexImpl.this.myUpdatingFiles.decrementAndGet() == 0) {
                ++FileBasedIndexImpl.this.myFilesModCount;
            }
        }

        private void scheduleForUpdate(VirtualFile file) {
            this.myFilesToUpdate.add(file);
        }

        private void invalidateIndices(@NotNull VirtualFile file, final boolean markForReindex) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "invalidateIndices"));
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector$2", "visitFile"));
                    }
                    if (FileBasedIndexImpl.this.isUnderConfigOrSystem(file)) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        ChangedFilesCollector.this.invalidateIndicesForFile(file, markForReindex);
                        if (!FileBasedIndexImpl.isMock(file) && !ChangedFilesCollector.this.myManagingFS.wereChildrenAccessed(file)) {
                            return false;
                        }
                    } else {
                        ChangedFilesCollector.this.invalidateIndicesForFile(file, markForReindex);
                    }
                    return true;
                }

                public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector$2", "getChildrenIterable"));
                    }
                    return file instanceof NewVirtualFile ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }
            });
        }

        private void invalidateIndicesForFile(final @NotNull VirtualFile file, boolean markForReindex) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "invalidateIndicesForFile"));
            }
            FileBasedIndexImpl.cleanProcessedFlag(file);
            IndexingStamp.flushCache(file);
            Collection<ID<?, ?>> existingIndexedIds = IndexingStamp.getIndexedIds(file);
            for (ID<?, ?> indexId : existingIndexedIds) {
                if (!FileBasedIndexImpl.this.myNotRequiringContentIndices.contains(indexId)) continue;
                try {
                    FileBasedIndexImpl.this.updateSingleIndex(indexId, file, null);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    FileBasedIndexImpl.this.requestRebuild(indexId);
                }
            }
            Collection indexedIdsToUpdate = ContainerUtil.intersection(existingIndexedIds, (Collection)FileBasedIndexImpl.this.myRequiringContentIndices);
            if (markForReindex) {
                if (!indexedIdsToUpdate.isEmpty()) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            IndexingStamp.removeAllIndexedState(file);
                        }
                    });
                    if (!FileBasedIndexImpl.this.isTooLarge(file) && FileBasedIndexImpl.this.getIndexableSetForFile(file) != null) {
                        this.scheduleForUpdate(file);
                    }
                }
            } else {
                boolean removed = this.myFilesToUpdate.remove(file);
                if (removed) {
                    List affectedContentIndices = FileBasedIndexImpl.this.calculateAffectedContentIndices(file);
                    affectedContentIndices.addAll(indexedIdsToUpdate);
                    indexedIdsToUpdate = affectedContentIndices;
                }
                if (!indexedIdsToUpdate.isEmpty()) {
                    final Collection finalIndexedIdsToUpdate = indexedIdsToUpdate;
                    this.myFutureInvalidations.offer(new InvalidationTask(file){

                        @Override
                        public void run() {
                            ChangedFilesCollector.this.removeFileDataFromIndices(finalIndexedIdsToUpdate, file);
                        }
                    });
                }
            }
            IndexingStamp.flushCache(file);
        }

        private void removeFileDataFromIndices(@NotNull Collection<ID<?, ?>> affectedIndices, @NotNull VirtualFile file) {
            if (affectedIndices == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "removeFileDataFromIndices"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "removeFileDataFromIndices"));
            }
            Throwable unexpectedError = null;
            for (ID<?, ?> indexId : affectedIndices) {
                try {
                    FileBasedIndexImpl.this.updateSingleIndex(indexId, file, null);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    FileBasedIndexImpl.this.requestRebuild(indexId);
                }
                catch (ProcessCanceledException pce) {
                    LOG.error((Throwable)pce);
                }
                catch (Throwable e) {
                    LOG.info(e);
                    if (unexpectedError != null) continue;
                    unexpectedError = e;
                }
            }
            IndexingStamp.flushCache(file);
            if (unexpectedError != null) {
                LOG.error(unexpectedError);
            }
        }

        public int getNumberOfPendingInvalidations() {
            return this.myFutureInvalidations.size();
        }

        public void ensureAllInvalidateTasksCompleted() {
            final int size = this.getNumberOfPendingInvalidations();
            if (size == 0) {
                return;
            }
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    InvalidationTask task;
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    indicator.setText("");
                    int count = 0;
                    while ((task = (InvalidationTask)ChangedFilesCollector.this.myFutureInvalidations.poll()) != null) {
                        indicator.setFraction((double)count++ / (double)size);
                        task.run();
                    }
                }
            });
        }

        private void iterateIndexableFiles(@NotNull VirtualFile file, final @NotNull Processor<VirtualFile> processor) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "iterateIndexableFiles"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "iterateIndexableFiles"));
            }
            if (file.isDirectory()) {
                ContentIterator iterator = new ContentIterator(){

                    public boolean processFile(@NotNull VirtualFile fileOrDir) {
                        if (fileOrDir == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector$6", "processFile"));
                        }
                        processor.process((Object)fileOrDir);
                        return true;
                    }
                };
                for (IndexableFileSet set : FileBasedIndexImpl.this.myIndexableSets) {
                    if (!set.isInSet(file)) continue;
                    set.iterateIndexableFilesIn(file, iterator);
                }
            } else if (FileBasedIndexImpl.this.getIndexableSetForFile(file) != null) {
                processor.process((Object)file);
            }
        }

        public Collection<VirtualFile> getAllFilesToUpdate() {
            if (this.myFilesToUpdate.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<VirtualFile>(this.myFilesToUpdate);
        }

        @NotNull
        private UpdateSemaphore obtainForceUpdateSemaphore() {
            UpdateSemaphore newValue = null;
            do {
                UpdateSemaphore currentValue;
                if ((currentValue = this.myUpdateSemaphoreRef.get()) != null) {
                    UpdateSemaphore updateSemaphore = currentValue;
                    if (updateSemaphore == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "obtainForceUpdateSemaphore"));
                    }
                    return updateSemaphore;
                }
                if (newValue != null) continue;
                newValue = new UpdateSemaphore();
            } while (!this.myUpdateSemaphoreRef.compareAndSet(null, newValue));
            UpdateSemaphore updateSemaphore = newValue;
            if (updateSemaphore == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "obtainForceUpdateSemaphore"));
            }
            return updateSemaphore;
        }

        private void releaseForceUpdateSemaphore(UpdateSemaphore semaphore) {
            this.myUpdateSemaphoreRef.compareAndSet(semaphore, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedTo, boolean onlyRemoveOutdatedData) {
            UpdateSemaphore updateSemaphore;
            FileBasedIndexImpl.this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
            ProjectIndexableFilesFilter indexableFilesFilter = FileBasedIndexImpl.this.projectIndexableFiles(project);
            do {
                updateSemaphore = this.obtainForceUpdateSemaphore();
                try {
                    for (VirtualFile file : this.getAllFilesToUpdate()) {
                        if (indexableFilesFilter != null && file instanceof VirtualFileWithId && !indexableFilesFilter.containsFileId(((VirtualFileWithId)file).getId()) || filter != null && !filter.accept(file) && !Comparing.equal((Object)file, (Object)restrictedTo)) continue;
                        try {
                            updateSemaphore.down();
                            this.processFileImpl(project, new com.intellij.ide.caches.FileContent(file), onlyRemoveOutdatedData);
                        }
                        catch (ProcessCanceledException e) {
                            updateSemaphore.reportUpdateCanceled();
                            throw e;
                        }
                        finally {
                            updateSemaphore.up();
                        }
                    }
                    while (!updateSemaphore.waitFor(500L) && !Thread.holdsLock(PsiLock.LOCK)) {
                    }
                }
                finally {
                    this.releaseForceUpdateSemaphore(updateSemaphore);
                }
            } while (updateSemaphore.isUpdateCanceled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileImpl(Project project, @NotNull com.intellij.ide.caches.FileContent fileContent, boolean onlyRemoveOutdatedData) {
            if (fileContent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "processFileImpl"));
            }
            VirtualFile file = fileContent.getVirtualFile();
            boolean reallyRemoved = this.myFilesToUpdate.remove(file);
            if (reallyRemoved && file.isValid()) {
                try {
                    if (onlyRemoveOutdatedData || FileBasedIndexImpl.this.isTooLarge(file)) {
                        this.removeFileDataFromIndices(FileBasedIndexImpl.this.calculateAffectedContentIndices(file), file);
                        if (onlyRemoveOutdatedData && file instanceof VirtualFileSystemEntry) {
                            ((VirtualFileSystemEntry)file).setFileIndexed(false);
                        }
                    } else {
                        FileBasedIndexImpl.this.doIndexFileContent(project, fileContent);
                    }
                }
                finally {
                    IndexingStamp.flushCache(file);
                }
            }
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "before"));
            }
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.signalUpdateStart();
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.ensureUpToDate();
            for (VFileEvent vFileEvent : events) {
                Object requestor = vFileEvent.getRequestor();
                if (!(requestor instanceof FileDocumentManager) && !(requestor instanceof PsiManager) && requestor != LocalHistory.VFS_EVENT_REQUESTOR) continue;
                FileBasedIndexImpl.this.cleanupMemoryStorage();
                break;
            }
            for (VFileEvent vFileEvent : events) {
                BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "after"));
            }
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.ensureUpToDate();
            for (VFileEvent vFileEvent : events) {
                BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
            }
            FileBasedIndexImpl.this.myContentlessIndicesUpdateQueue.signalUpdateEnd();
        }
    }

    private static class SilentProgressIndicator
    extends DelegatingProgressIndicator {
        private SilentProgressIndicator(ProgressIndicator indicator) {
            super(indicator);
        }

        @Nullable
        private static SilentProgressIndicator create() {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            return indicator != null ? new SilentProgressIndicator(indicator) : null;
        }

        public void setText(String text) {
        }

        public String getText() {
            return "";
        }

        public void setText2(String text) {
        }

        public String getText2() {
            return "";
        }
    }

    private static abstract class InvalidationTask
    implements Runnable {
        private final VirtualFile mySubj;

        protected InvalidationTask(VirtualFile subj) {
            this.mySubj = subj;
        }

        public VirtualFile getSubj() {
            return this.mySubj;
        }
    }

    private static class PsiContent
    implements DocumentContent {
        private final Document myDocument;
        private final PsiFile myFile;

        private PsiContent(Document document, PsiFile file) {
            this.myDocument = document;
            this.myFile = file;
        }

        @Override
        public CharSequence getText() {
            if (this.myFile.getViewProvider().getModificationStamp() != this.myDocument.getModificationStamp()) {
                FileASTNode node = this.myFile.getNode();
                assert (node != null);
                return node.getChars();
            }
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myFile.getViewProvider().getModificationStamp();
        }
    }

    private static class AuthenticContent
    implements DocumentContent {
        private final Document myDocument;

        private AuthenticContent(Document document) {
            this.myDocument = document;
        }

        @Override
        public CharSequence getText() {
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myDocument.getModificationStamp();
        }
    }

    private static interface DocumentContent {
        public CharSequence getText();

        public long getModificationStamp();
    }

    public static final class ProjectIndexableFilesFilter
    extends IdFilter {
        private static final int SHIFT = 6;
        private static final int MASK = 63;
        private final long[] myBitMask;
        private final int myModificationCount;
        private final int myMinId;
        private final int myMaxId;

        private ProjectIndexableFilesFilter(@NotNull TIntArrayList set, int modificationCount) {
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/indexing/FileBasedIndexImpl$ProjectIndexableFilesFilter", "<init>"));
            }
            this.myModificationCount = modificationCount;
            final int[] minMax = new int[2];
            if (!set.isEmpty()) {
                minMax[0] = minMax[1] = set.get(0);
            }
            set.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    if (value < 0) {
                        value = -value;
                    }
                    minMax[0] = Math.min(minMax[0], value);
                    minMax[1] = Math.max(minMax[1], value);
                    return true;
                }
            });
            this.myMaxId = minMax[1];
            this.myMinId = minMax[0];
            this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
            set.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    if (value < 0) {
                        value = -value;
                    }
                    long[] lArray = ProjectIndexableFilesFilter.this.myBitMask;
                    int n = (value -= ProjectIndexableFilesFilter.this.myMinId) >> 6;
                    lArray[n] = lArray[n] | 1L << (value & 0x3F);
                    return true;
                }
            });
        }

        public boolean containsFileId(int id) {
            if (id < this.myMinId) {
                return false;
            }
            if (id > this.myMaxId) {
                return false;
            }
            return (this.myBitMask[(id -= this.myMinId) >> 6] & 1L << (id & 0x3F)) != 0L;
        }
    }
}

