/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import org.jetbrains.annotations.NotNull;

class GraphEdge<Node> {
    private final Node myStart;
    private final Node myFinish;
    private final int myDelta;

    GraphEdge(@NotNull Node start, @NotNull Node finish, int delta) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/graph/impl/GraphEdge", "<init>"));
        }
        if (finish == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/graph/impl/GraphEdge", "<init>"));
        }
        this.myStart = start;
        this.myFinish = finish;
        this.myDelta = delta;
    }

    public Node getStart() {
        return this.myStart;
    }

    public Node getFinish() {
        return this.myFinish;
    }

    public int getDelta() {
        return this.myDelta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge edge = (GraphEdge)o;
        return this.myFinish.equals(edge.myFinish) && this.myStart.equals(edge.myStart);
    }

    public int hashCode() {
        return 31 * this.myStart.hashCode() + this.myFinish.hashCode();
    }
}

