/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.annotations.NotNull;

public class DownloadableFileDescriptionImpl
implements DownloadableFileDescription {
    private final String myFileName;
    private final String myFileExtension;
    private final String myDownloadUrl;

    public DownloadableFileDescriptionImpl(@NotNull String downloadUrl, @NotNull String fileName, @NotNull String fileExtension) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "<init>"));
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "<init>"));
        }
        this.myFileName = fileName;
        this.myFileExtension = fileExtension.length() > 0 && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        this.myDownloadUrl = downloadUrl;
    }

    @NotNull
    public String getDownloadUrl() {
        String string = this.myDownloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getDownloadUrl"));
        }
        return string;
    }

    @NotNull
    public String getPresentableFileName() {
        String string = this.myFileName + this.myFileExtension;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getPresentableFileName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableDownloadUrl() {
        String string = this.myDownloadUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getPresentableDownloadUrl"));
        }
        return string;
    }

    @NotNull
    public String getDefaultFileName() {
        String string = this.generateFileName((Condition<String>)Conditions.alwaysTrue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getDefaultFileName"));
        }
        return string;
    }

    @NotNull
    public String generateFileName(@NotNull Condition<String> validator) {
        if (validator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "generateFileName"));
        }
        String string = UniqueNameGenerator.generateUniqueName((String)"", (String)this.myFileName, (String)this.myFileExtension, (String)"_", (String)"", validator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "generateFileName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadableFileDescriptionImpl that = (DownloadableFileDescriptionImpl)o;
        return this.myDownloadUrl.equals(that.myDownloadUrl);
    }

    public int hashCode() {
        return this.myDownloadUrl.hashCode();
    }
}

