/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class GeneralRunner
implements ContinuationContext {
    protected final Project myProject;
    protected final boolean myCancellable;
    protected final List<TaskDescriptor> myQueue;
    protected final Object myQueueLock;
    private boolean myTriggerSuspend;
    private ProgressIndicator myIndicator;
    protected final Map<Object, Object> myDisasters;
    private final List<Consumer<TaskDescriptor>> myTasksPatchers;
    private final Map<Class<? extends Exception>, Consumer<Exception>> myHandlersMap;

    GeneralRunner(Project project, boolean cancellable) {
        this.myProject = project;
        this.myCancellable = cancellable;
        this.myQueueLock = new Object();
        this.myQueue = new LinkedList<TaskDescriptor>();
        this.myDisasters = new HashMap<Object, Object>();
        this.myHandlersMap = new HashMap<Class<? extends Exception>, Consumer<Exception>>();
        this.myTasksPatchers = new ArrayList<Consumer<TaskDescriptor>>();
        this.myTriggerSuspend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Exception> void addExceptionHandler(final Class<T> clazz, final Consumer<T> consumer) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myHandlersMap.put(clazz, new Consumer<Exception>(){

                public void consume(Exception e) {
                    if (!clazz.isAssignableFrom(e.getClass())) {
                        throw new RuntimeException(e);
                    }
                    consumer.consume((Object)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIndicator(ProgressIndicator indicator) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myIndicator = indicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelIndicator() {
        Object object = this.myQueueLock;
        synchronized (object) {
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDisasters() {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myDisasters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleException(Exception e, boolean cancelEveryThing) {
        Object object = this.myQueueLock;
        synchronized (object) {
            try {
                Map.Entry<Class<? extends Exception>, Consumer<Exception>> entry;
                Class<?> aClass = e.getClass();
                Consumer<Exception> consumer = this.myHandlersMap.get(e.getClass());
                if (consumer != null) {
                    consumer.consume((Object)e);
                    boolean bl = true;
                    return bl;
                }
                Iterator<Map.Entry<Class<? extends Exception>, Consumer<Exception>>> i$ = this.myHandlersMap.entrySet().iterator();
                do {
                    if (!i$.hasNext()) return false;
                } while (!(entry = i$.next()).getKey().isAssignableFrom(aClass));
                entry.getValue().consume((Object)e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (cancelEveryThing) {
                    this.cancelEverything();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEverything() {
        Object object = this.myQueueLock;
        synchronized (object) {
            for (TaskDescriptor descriptor : this.myQueue) {
                descriptor.canceled();
            }
            this.myQueue.clear();
            this.myIndicator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCurrent() {
        Object object = this.myQueueLock;
        synchronized (object) {
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myTriggerSuspend = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getSuspendFlag() {
        Object object = this.myQueueLock;
        synchronized (object) {
            return this.myTriggerSuspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSuspend() {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myTriggerSuspend = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepExisting(Object disaster, Object cure) {
        Object object = this.myQueueLock;
        synchronized (object) {
            for (TaskDescriptor taskDescriptor : this.myQueue) {
                taskDescriptor.addCure(disaster, cure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwDisaster(@NotNull Object disaster, @NotNull Object cure) {
        if (disaster == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/continuation/GeneralRunner", "throwDisaster"));
        }
        if (cure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/continuation/GeneralRunner", "throwDisaster"));
        }
        Object object = this.myQueueLock;
        synchronized (object) {
            Iterator<TaskDescriptor> iterator = this.myQueue.iterator();
            while (iterator.hasNext()) {
                Object taskCure;
                TaskDescriptor taskDescriptor = iterator.next();
                if (taskDescriptor.isHaveMagicCure() || cure.equals(taskCure = taskDescriptor.hasCure(disaster))) continue;
                iterator.remove();
            }
            this.myDisasters.put(disaster, cure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull TaskDescriptor inQueue, TaskDescriptor ... next) {
        if (inQueue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/continuation/GeneralRunner", "after"));
        }
        Object object = this.myQueueLock;
        synchronized (object) {
            int idx = -1;
            int i = 0;
            for (TaskDescriptor descriptor : this.myQueue) {
                if (descriptor == inQueue) {
                    idx = i;
                    break;
                }
                ++i;
            }
            assert (idx != -1);
            List<TaskDescriptor> asList = Arrays.asList(next);
            this.patchTasks(asList);
            this.myQueue.addAll(idx + 1, asList);
        }
    }

    private void patchTasks(List<TaskDescriptor> next) {
        for (TaskDescriptor descriptor : next) {
            for (Consumer<TaskDescriptor> tasksPatcher : this.myTasksPatchers) {
                tasksPatcher.consume((Object)descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(TaskDescriptor ... next) {
        Object object = this.myQueueLock;
        synchronized (object) {
            List<TaskDescriptor> asList = Arrays.asList(next);
            this.patchTasks(asList);
            this.myQueue.addAll(0, asList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(List<TaskDescriptor> next) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.patchTasks(next);
            this.myQueue.addAll(0, next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last(List<TaskDescriptor> next) {
        Object object = this.myQueueLock;
        synchronized (object) {
            this.patchTasks(next);
            this.myQueue.addAll(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last(TaskDescriptor ... next) {
        Object object = this.myQueueLock;
        synchronized (object) {
            List<TaskDescriptor> asList = Arrays.asList(next);
            this.patchTasks(asList);
            this.myQueue.addAll(asList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myQueueLock;
        synchronized (object) {
            return this.myQueue.isEmpty();
        }
    }

    public abstract void ping();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewTasksPatcher(@NotNull Consumer<TaskDescriptor> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/continuation/GeneralRunner", "addNewTasksPatcher"));
        }
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myTasksPatchers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNewTasksPatcher(@NotNull Consumer<TaskDescriptor> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/continuation/GeneralRunner", "removeNewTasksPatcher"));
        }
        Object object = this.myQueueLock;
        synchronized (object) {
            this.myTasksPatchers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCancel() {
        Object object = this.myQueueLock;
        synchronized (object) {
            if (this.myQueue.isEmpty()) {
                return;
            }
            Iterator<TaskDescriptor> iterator = this.myQueue.iterator();
            while (iterator.hasNext()) {
                TaskDescriptor next = iterator.next();
                if (next.isHaveMagicCure()) continue;
                iterator.remove();
            }
        }
        this.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TaskDescriptor getNextMatching() {
        while (true) {
            Object object = this.myQueueLock;
            synchronized (object) {
                if (this.myQueue.isEmpty()) {
                    return null;
                }
                TaskDescriptor current = this.myQueue.remove(0);
                if (!current.isHaveMagicCure()) {
                    if (this.myIndicator != null && this.myIndicator.isCanceled()) {
                        continue;
                    }
                    for (Map.Entry<Object, Object> entry : this.myDisasters.entrySet()) {
                        if (entry.getValue().equals(current.hasCure(entry.getKey()))) continue;
                        current = null;
                        break;
                    }
                }
                if (current != null) {
                    return current;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressIndicator getIndicator() {
        Object object = this.myQueueLock;
        synchronized (object) {
            return this.myIndicator;
        }
    }
}

