/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyLoader;

public class SnappyInitializer {
    public static final boolean NO_SNAPPY = SystemProperties.getBooleanProperty((String)"idea.no.snappy", (boolean)false);

    public static void initializeSnappy(Logger log, File ideaTempDir) {
        if (!NO_SNAPPY) {
            if (System.getProperty("org.xerial.snappy.tempdir") == null) {
                System.setProperty("org.xerial.snappy.tempdir", ideaTempDir.getPath());
            }
            try {
                long t = System.currentTimeMillis();
                SnappyInitializer.loadSnappyForJRockit();
                log.info("Snappy library loaded (" + Snappy.getNativeLibraryVersion() + ") in " + (System.currentTimeMillis() - t) + " ms");
            }
            catch (Throwable t) {
                log.error("Unable to load Snappy library (OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ")", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSnappyForJRockit() throws Exception {
        String[] classes;
        byte[] bytes;
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null || !vmName.toLowerCase().contains("jrockit")) {
            return;
        }
        InputStream in = SnappyInitializer.class.getResourceAsStream("/org/xerial/snappy/SnappyNativeLoader.bytecode");
        try {
            bytes = FileUtil.loadBytes((InputStream)in);
        }
        finally {
            in.close();
        }
        ClassLoader classLoader = SnappyInitializer.class.getClassLoader();
        Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineClass.setAccessible(true);
        Class<?> loaderClass = (Class<?>)defineClass.invoke((Object)classLoader, "org.xerial.snappy.SnappyNativeLoader", bytes, 0, bytes.length);
        loaderClass = classLoader.loadClass(loaderClass.getName());
        for (String aClass : classes = new String[]{"org.xerial.snappy.SnappyNativeAPI", "org.xerial.snappy.SnappyNative", "org.xerial.snappy.SnappyErrorCode"}) {
            classLoader.loadClass(aClass);
        }
        Method loadNativeLibrary = SnappyLoader.class.getDeclaredMethod("loadNativeLibrary", Class.class);
        loadNativeLibrary.setAccessible(true);
        loadNativeLibrary.invoke(null, loaderClass);
    }
}

