/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView.impl;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageCallHierarchy;
import com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageContextPanelBase;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageContextCallHierarchyPanel
extends UsageContextPanelBase {
    private HierarchyBrowser myBrowser;

    public UsageContextCallHierarchyPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel", "<init>"));
        }
        super(project, presentation);
    }

    public void dispose() {
        super.dispose();
        this.myBrowser = null;
    }

    public void updateLayoutLater(@Nullable List<UsageInfo> infos) {
        PsiElement element;
        PsiElement psiElement = element = infos == null ? null : UsageContextCallHierarchyPanel.getElementToSliceOn(infos);
        if (this.myBrowser instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myBrowser));
            this.myBrowser = null;
        }
        if (element != null) {
            this.myBrowser = UsageContextCallHierarchyPanel.createCallHierarchyPanel(element);
            if (this.myBrowser == null) {
                element = null;
            }
        }
        this.removeAll();
        if (element == null) {
            JLabel titleComp = new JLabel(UsageViewBundle.message((String)"select.the.usage.to.preview", (Object[])new Object[]{this.myPresentation.getUsagesWord()}), 0);
            this.add(titleComp, "Center");
            this.revalidate();
        } else {
            if (this.myBrowser instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)this.myBrowser));
            }
            JComponent panel = this.myBrowser.getComponent();
            this.add(panel, "Center");
            this.revalidate();
        }
    }

    @Nullable
    private static HierarchyBrowser createCallHierarchyPanel(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel", "createCallHierarchyPanel"));
        }
        DataContext context = SimpleDataContext.getSimpleContext(CommonDataKeys.PSI_ELEMENT.getName(), element, SimpleDataContext.getProjectContext(element.getProject()));
        HierarchyProvider provider = BrowseHierarchyActionBase.findBestHierarchyProvider((LanguageExtension<HierarchyProvider>)LanguageCallHierarchy.INSTANCE, element, context);
        if (provider == null) {
            return null;
        }
        PsiElement providerTarget = provider.getTarget(context);
        if (providerTarget == null) {
            return null;
        }
        HierarchyBrowser browser = provider.createHierarchyBrowser(providerTarget);
        if (browser instanceof HierarchyBrowserBaseEx) {
            HierarchyBrowserBaseEx browserEx = (HierarchyBrowserBaseEx)browser;
            browserEx.changeView(CallHierarchyBrowserBase.CALLER_TYPE);
            final ProgressIndicatorBase indicator = new ProgressIndicatorBase();
            Disposer.register((Disposable)browserEx, (Disposable)new Disposable(){

                public void dispose() {
                    indicator.cancel();
                }
            });
            browserEx.setProgressIndicator(indicator);
        }
        return browser;
    }

    private static PsiElement getElementToSliceOn(@NotNull List<UsageInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel", "getElementToSliceOn"));
        }
        UsageInfo info = infos.get(0);
        return info.getElement();
    }

    public static class Provider
    implements UsageContextPanel.Provider {
        @NotNull
        public UsageContextPanel create(@NotNull UsageView usageView) {
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel$Provider", "create"));
            }
            UsageContextCallHierarchyPanel usageContextCallHierarchyPanel = new UsageContextCallHierarchyPanel(((UsageViewImpl)usageView).getProject(), usageView.getPresentation());
            if (usageContextCallHierarchyPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel$Provider", "create"));
            }
            return usageContextCallHierarchyPanel;
        }

        public boolean isAvailableFor(@NotNull UsageView usageView) {
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel$Provider", "isAvailableFor"));
            }
            UsageTarget[] targets = ((UsageViewImpl)usageView).getTargets();
            if (targets.length == 0) {
                return false;
            }
            UsageTarget target = targets[0];
            if (!(target instanceof PsiElementUsageTarget)) {
                return false;
            }
            PsiElement element = ((PsiElementUsageTarget)target).getElement();
            if (element == null || !element.isValid()) {
                return false;
            }
            Project project = element.getProject();
            DataContext context = SimpleDataContext.getSimpleContext(CommonDataKeys.PSI_ELEMENT.getName(), element, SimpleDataContext.getProjectContext(project));
            HierarchyProvider provider = BrowseHierarchyActionBase.findBestHierarchyProvider((LanguageExtension<HierarchyProvider>)LanguageCallHierarchy.INSTANCE, element, context);
            if (provider == null) {
                return false;
            }
            PsiElement providerTarget = provider.getTarget(context);
            return providerTarget != null;
        }

        @NotNull
        public String getTabTitle() {
            if ("Call Hierarchy" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/impl/UsageContextCallHierarchyPanel$Provider", "getTabTitle"));
            }
            return "Call Hierarchy";
        }
    }
}

