/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class UsageViewUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageViewUtil");

    private UsageViewUtil() {
    }

    public static String createNodeText(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    public static String getShortName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
    }

    public static String getLongName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    public static String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/UsageViewUtil", "getType"));
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }

    public static boolean hasNonCodeUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUsagesInGeneratedCode(UsageInfo[] usages, Project project) {
        GeneratedSourcesFilter[] filters = (GeneratedSourcesFilter[])GeneratedSourcesFilter.EP_NAME.getExtensions();
        for (UsageInfo usage : usages) {
            VirtualFile file = usage.getVirtualFile();
            if (file == null) continue;
            for (GeneratedSourcesFilter filter : filters) {
                if (!filter.isGeneratedSource(file, project)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    public static UsageInfo[] removeDuplicatedUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/UsageViewUtil", "removeDuplicatedUsages"));
        }
        LinkedHashSet<UsageInfo> set = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = null;
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            newTextInNonCodeUsage = ((NonCodeUsageInfo)usage).newText;
            break;
        }
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiLanguageInjectionHost context;
                PsiFile file;
                if (!(usage instanceof MoveRenameUsageInfo) || (file = usage.getFile()) == null || (context = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file)) == null || (usageElement = usage.getElement()) == null || (psiReference = usage.getReference()) == null) continue;
                int injectionOffsetInMasterFile = InjectedLanguageManager.getInstance((Project)usageElement.getProject()).injectedToHost(usageElement, usageElement.getTextOffset());
                ProperTextRange rangeInElement = usage.getRangeInElement();
                assert (rangeInElement != null) : usage;
                TextRange range = rangeInElement.shiftRight(injectionOffsetInMasterFile);
                PsiFile containingFile = context.getContainingFile();
                if (containingFile == null) continue;
                set.remove(NonCodeUsageInfo.create((PsiFile)containingFile, (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)((MoveRenameUsageInfo)usage).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        return set.toArray(new UsageInfo[set.size()]);
    }

    @NotNull
    public static UsageInfo[] toUsageInfoArray(@NotNull Collection<? extends UsageInfo> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/UsageViewUtil", "toUsageInfoArray"));
        }
        int size = collection.size();
        UsageInfo[] usageInfoArray = size == 0 ? UsageInfo.EMPTY_ARRAY : collection.toArray(new UsageInfo[size]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/UsageViewUtil", "toUsageInfoArray"));
        }
        return usageInfoArray;
    }

    @NotNull
    public static PsiElement[] toElements(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/UsageViewUtil", "toElements"));
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])usageInfos, PsiElement.class, (Function)new Function<UsageInfo, PsiElement>(){

            public PsiElement fun(UsageInfo info) {
                return info.getElement();
            }
        });
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usageView/UsageViewUtil", "toElements"));
        }
        return psiElementArray;
    }

    public static void navigateTo(@NotNull UsageInfo info, boolean requestFocus) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/usageView/UsageViewUtil", "navigateTo"));
        }
        int offset = info.getNavigationOffset();
        VirtualFile file = info.getVirtualFile();
        Project project = info.getProject();
        FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file, offset), requestFocus);
    }
}

