/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadOperation;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ThreadDumpPanel
extends JPanel {
    private static final Icon PAUSE_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Paused, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon LOCKED_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Locked, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon RUNNING_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Running, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon SOCKET_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Socket, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon IDLE_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Idle, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon EDT_BUSY_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.EdtBusy, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon IO_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.IO, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private final JBList myThreadList;
    private final List<ThreadState> myThreadDump;
    private final JPanel myFilterPanel;
    private final SearchTextField myFilterField;

    public ThreadDumpPanel(final Project project, final ConsoleView consoleView, DefaultActionGroup toolbarActions, List<ThreadState> threadDump) {
        super(new BorderLayout());
        this.myThreadDump = threadDump;
        this.myFilterField = new SearchTextField();
        this.myFilterField.addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                ThreadDumpPanel.this.updateThreadList();
            }
        });
        this.myFilterPanel = new JPanel(new BorderLayout());
        this.myFilterPanel.add((Component)new JLabel("Filter:"), "West");
        this.myFilterPanel.add((Component)this.myFilterField);
        this.myFilterPanel.setVisible(false);
        this.myThreadList = new JBList(new DefaultListModel());
        this.myThreadList.setCellRenderer((ListCellRenderer)((Object)new ThreadListCellRenderer()));
        this.myThreadList.setSelectionMode(0);
        this.myThreadList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ThreadDumpPanel.this.myThreadList.getSelectedIndex();
                if (index >= 0) {
                    ThreadState selection = (ThreadState)ThreadDumpPanel.this.myThreadList.getModel().getElementAt(index);
                    AnalyzeStacktraceUtil.printStacktrace(consoleView, selection.getStackTrace());
                } else {
                    AnalyzeStacktraceUtil.printStacktrace(consoleView, "");
                }
                ThreadDumpPanel.this.myThreadList.repaint();
            }
        });
        FilterAction filterAction = new FilterAction();
        filterAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("Find").getShortcutSet(), (JComponent)this.myThreadList);
        toolbarActions.add((AnAction)filterAction);
        toolbarActions.add((AnAction)new CopyToClipboardAction(threadDump, project));
        toolbarActions.add((AnAction)new SortThreadsAction());
        this.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarActions, false).getComponent(), "West");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myFilterPanel, "North");
        leftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myThreadList, (int)5), "Center");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent(consoleView.getComponent());
        this.add((Component)splitter, "Center");
        new ListSpeedSearch((JList)this.myThreadList).setComparator(new SpeedSearchComparator(false, true));
        this.updateThreadList();
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)consoleView.getPreferredFocusableComponent()));
        if (editor != null) {
            editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    String filter = ThreadDumpPanel.this.myFilterField.getText();
                    if (StringUtil.isNotEmpty((String)filter)) {
                        ThreadDumpPanel.highlightOccurrences(filter, project, editor);
                    }
                }
            }, (Disposable)consoleView);
        }
    }

    private void updateThreadList() {
        String text = this.myFilterPanel.isVisible() ? this.myFilterField.getText() : "";
        DefaultListModel model = (DefaultListModel)this.myThreadList.getModel();
        model.clear();
        for (ThreadState state : this.myThreadDump) {
            if (!StringUtil.containsIgnoreCase((String)state.getStackTrace(), (String)text) && !StringUtil.containsIgnoreCase((String)state.getName(), (String)text)) continue;
            model.addElement(state);
        }
        if (!model.isEmpty()) {
            this.myThreadList.setSelectedIndex(0);
        }
        this.myThreadList.revalidate();
        this.myThreadList.repaint();
    }

    private static void highlightOccurrences(String filter, Project project, Editor editor) {
        int nextOccurrence;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        String documentText = editor.getDocument().getText();
        int i = -1;
        while ((nextOccurrence = StringUtil.indexOfIgnoreCase((String)documentText, (String)filter, (int)(i + 1))) >= 0) {
            i = nextOccurrence;
            highlightManager.addOccurrenceHighlight(editor, i, i + filter.length(), attributes, 4, null, null);
        }
    }

    private static Icon getThreadStateIcon(ThreadState threadState) {
        boolean daemon = threadState.isDaemon();
        if (threadState.isSleeping()) {
            return daemon ? PAUSE_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Paused;
        }
        if (threadState.isWaiting()) {
            return daemon ? LOCKED_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Locked;
        }
        if (threadState.getOperation() == ThreadOperation.Socket) {
            return daemon ? SOCKET_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Socket;
        }
        if (threadState.getOperation() == ThreadOperation.IO) {
            return daemon ? IO_ICON_DAEMON : AllIcons.Debugger.ThreadStates.IO;
        }
        if (threadState.isEDT()) {
            if ("idle".equals(threadState.getThreadStateDetail())) {
                return daemon ? IDLE_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Idle;
            }
            return daemon ? EDT_BUSY_ICON_DAEMON : AllIcons.Debugger.ThreadStates.EdtBusy;
        }
        return daemon ? RUNNING_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Running;
    }

    private static StateCode getThreadStateCode(ThreadState state) {
        if (state.isSleeping()) {
            return StateCode.PAUSED;
        }
        if (state.isWaiting()) {
            return StateCode.LOCKED;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return StateCode.RUN_SOCKET;
        }
        if (state.getOperation() == ThreadOperation.IO) {
            return StateCode.RUN_IO;
        }
        if (state.isEDT()) {
            return "idle".equals(state.getThreadStateDetail()) ? StateCode.IDLE : StateCode.EDT;
        }
        return StateCode.RUN;
    }

    private static SimpleTextAttributes getAttributes(ThreadState threadState) {
        if (threadState.isSleeping()) {
            return SimpleTextAttributes.GRAY_ATTRIBUTES;
        }
        if (threadState.isEmptyStackTrace() || ThreadDumpParser.isKnownJdkThread(threadState)) {
            return new SimpleTextAttributes(0, Color.GRAY.brighter());
        }
        if (threadState.isEDT()) {
            return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public void selectStackFrame(int index) {
        this.myThreadList.setSelectedIndex(index);
    }

    private class FilterAction
    extends ToggleAction
    implements DumbAware {
        FilterAction() {
            super("Filter", "Show only threads containing a specific string", AllIcons.General.Filter);
        }

        public boolean isSelected(AnActionEvent e) {
            return ThreadDumpPanel.this.myFilterPanel.isVisible();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ThreadDumpPanel.this.myFilterPanel.setVisible(state);
            if (state) {
                IdeFocusManager.getInstance((Project)FilterAction.getEventProject((AnActionEvent)e)).requestFocus((Component)ThreadDumpPanel.this.myFilterField, true);
                ThreadDumpPanel.this.myFilterField.selectText();
            }
            ThreadDumpPanel.this.updateThreadList();
        }
    }

    private static class CopyToClipboardAction
    extends DumbAwareAction {
        private static final NotificationGroup GROUP = NotificationGroup.toolWindowGroup((String)"Analyze thread dump", (String)ToolWindowId.RUN, (boolean)false);
        private final List<ThreadState> myThreadDump;
        private final Project myProject;

        public CopyToClipboardAction(List<ThreadState> threadDump, Project project) {
            super("Copy to Clipboard", "Copy whole thread dump to clipboard", PlatformIcons.COPY_ICON);
            this.myThreadDump = threadDump;
            this.myProject = project;
        }

        public void actionPerformed(AnActionEvent e) {
            StringBuilder buf = new StringBuilder();
            buf.append("Full thread dump").append("\n\n");
            for (ThreadState state : this.myThreadDump) {
                buf.append(state.getStackTrace()).append("\n\n");
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(buf.toString()));
            GROUP.createNotification("Full thread dump was successfully copied to clipboard", MessageType.INFO).notify(this.myProject);
        }
    }

    private class SortThreadsAction
    extends DumbAwareAction {
        private final Comparator<ThreadState> BY_TYPE;
        private final Comparator<ThreadState> BY_NAME;
        private Comparator<ThreadState> COMPARATOR;
        private static final String TYPE_LABEL = "Sort threads by type";
        private static final String NAME_LABEL = "Sort threads by name";

        public SortThreadsAction() {
            super(TYPE_LABEL);
            this.BY_TYPE = new Comparator<ThreadState>(){

                @Override
                public int compare(ThreadState o1, ThreadState o2) {
                    int s2;
                    int s1 = ThreadDumpPanel.getThreadStateCode(o1).ordinal();
                    if (s1 == (s2 = ThreadDumpPanel.getThreadStateCode(o2).ordinal())) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                    return s1 < s2 ? -1 : 1;
                }
            };
            this.BY_NAME = new Comparator<ThreadState>(){

                @Override
                public int compare(ThreadState o1, ThreadState o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            };
            this.COMPARATOR = this.BY_TYPE;
        }

        public void actionPerformed(AnActionEvent e) {
            DefaultListModel model = (DefaultListModel)ThreadDumpPanel.this.myThreadList.getModel();
            ThreadState selected = (ThreadState)ThreadDumpPanel.this.myThreadList.getSelectedValue();
            ArrayList<ThreadState> states = new ArrayList<ThreadState>();
            for (int i = 0; i < model.getSize(); ++i) {
                states.add((ThreadState)model.getElementAt(i));
            }
            Collections.sort(states, this.COMPARATOR);
            int selectedIndex = 0;
            for (int i = 0; i < states.size(); ++i) {
                ThreadState state = (ThreadState)states.get(i);
                model.setElementAt(state, i);
                if (state != selected) continue;
                selectedIndex = i;
            }
            ThreadDumpPanel.this.myThreadList.setSelectedIndex(selectedIndex);
            this.COMPARATOR = this.COMPARATOR == this.BY_TYPE ? this.BY_NAME : this.BY_TYPE;
            this.update(e);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(this.COMPARATOR == this.BY_TYPE ? AllIcons.ObjectBrowser.SortByType : AllIcons.Icons.Inspector.SortByName);
            e.getPresentation().setText(this.COMPARATOR == this.BY_TYPE ? TYPE_LABEL : NAME_LABEL);
        }
    }

    private static class ThreadListCellRenderer
    extends ColoredListCellRenderer {
        private ThreadListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            ThreadState threadState = (ThreadState)value;
            this.setIcon(ThreadDumpPanel.getThreadStateIcon(threadState));
            if (!selected) {
                ThreadState selectedThread = (ThreadState)list.getSelectedValue();
                if (threadState.isDeadlocked()) {
                    this.setBackground(LightColors.RED);
                } else if (selectedThread != null && threadState.isAwaitedBy(selectedThread)) {
                    this.setBackground((Color)JBColor.YELLOW);
                } else {
                    this.setBackground(UIUtil.getListBackground());
                }
            }
            SimpleTextAttributes attrs = ThreadDumpPanel.getAttributes(threadState);
            this.append(threadState.getName() + " (", attrs);
            String detail = threadState.getThreadStateDetail();
            if (detail == null) {
                detail = threadState.getState();
            }
            if (detail.length() > 30) {
                detail = detail.substring(0, 30) + "...";
            }
            this.append(detail, attrs);
            this.append(")", attrs);
            if (threadState.getExtraState() != null) {
                this.append(" [" + threadState.getExtraState() + "]", attrs);
            }
        }
    }

    private static enum StateCode {
        RUN,
        RUN_IO,
        RUN_SOCKET,
        PAUSED,
        LOCKED,
        EDT,
        IDLE;

    }
}

