/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.configurable.VcsContentAnnotationConfigurable;
import com.intellij.util.PlatformIcons;

public class ShowRecentlyChanged
extends DumbAwareAction {
    public ShowRecentlyChanged() {
        super("Show recently changed", "Show recently changed", PlatformIcons.COPY_ICON);
    }

    public void actionPerformed(AnActionEvent e) {
        if (!this.enabled(e)) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        VcsContentAnnotationConfigurable configurable = new VcsContentAnnotationConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
    }

    private boolean enabled(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return false;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return vcsManager.hasActiveVcss();
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.enabled(e));
    }
}

