/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketControlHelper {
    private static final String ACTIVATE_COMMAND = "activate ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int portNumber = Integer.parseInt(args[0]);
        String pathToProject = new File(args[1]).getAbsolutePath();
        InetAddress lba = SocketControlHelper.getLoopbackAddress();
        try {
            Socket socket = new Socket(lba, portNumber);
            socket.setSoTimeout(300);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            try {
                out.writeUTF(ACTIVATE_COMMAND + new File(".").getAbsolutePath() + "\u0000" + "reopen" + "\u0000" + pathToProject);
                out.flush();
                String response = in.readUTF();
                if (response.equals("ok")) {
                    System.err.println("Activated.");
                }
            }
            finally {
                in.close();
                out.close();
                socket.close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        System.err.println("Activation failed");
    }

    private static InetAddress getLoopbackAddress() {
        InetAddress returnValue = null;
        try {
            returnValue = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        return returnValue;
    }
}

