/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupDispatcher;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.ui.popup.util.MnemonicsSearch;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WizardPopup
extends AbstractPopup
implements ActionListener,
ElementFilter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.WizardPopup");
    private static final int AUTO_POPUP_DELAY = 750;
    private static final Dimension MAX_SIZE = new Dimension(Integer.MAX_VALUE, 600);
    protected static final int STEP_X_PADDING = 2;
    private final WizardPopup myParent;
    protected final PopupStep<Object> myStep;
    protected WizardPopup myChild;
    private final Timer myAutoSelectionTimer;
    private final MnemonicsSearch myMnemonicsSearch;
    private Object myParentValue;
    private Point myLastOwnerPoint;
    private Window myOwnerWindow;
    private MyComponentAdapter myOwnerListener;
    private final ActionMap myActionMap;
    private final InputMap myInputMap;

    public WizardPopup(@NotNull PopupStep<Object> aStep) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/popup/WizardPopup", "<init>"));
        }
        this(null, aStep);
    }

    public WizardPopup(@Nullable JBPopup aParent, @NotNull PopupStep<Object> aStep) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/popup/WizardPopup", "<init>"));
        }
        this.myAutoSelectionTimer = UIUtil.createNamedTimer((String)"Wizard autoselection", (int)750, (ActionListener)this);
        this.myActionMap = new ActionMap();
        this.myInputMap = new InputMap();
        this.myParent = (WizardPopup)aParent;
        this.myStep = aStep;
        this.mySpeedSearch.setEnabled(this.myStep.isSpeedSearchEnabled());
        JComponent content = this.createContent();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)content);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getHorizontalScrollBar().setBorder(null);
        scrollPane.getActionMap().get("unitScrollLeft").setEnabled(false);
        scrollPane.getActionMap().get("unitScrollRight").setEnabled(false);
        scrollPane.setBorder(null);
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        this.init(project, scrollPane, this.getPreferredFocusableComponent(), true, true, true, null, false, aStep.getTitle(), null, true, null, false, null, null, null, false, null, true, false, true, null, 0.0f, null, true, false, new Component[0], null, 2, true, Collections.<Pair<ActionListener, KeyStroke>>emptyList(), null, null, false, true, true, true, null);
        this.registerAction("disposeAll", 27, 1, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizardPopup.this.mySpeedSearch.isHoldingFilter()) {
                    WizardPopup.this.mySpeedSearch.reset();
                } else {
                    WizardPopup.this.disposeAll();
                }
            }
        });
        AbstractAction goBackAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPopup.this.goBack();
            }
        };
        this.registerAction("goBack3", 27, 0, goBackAction);
        this.myMnemonicsSearch = new MnemonicsSearch(this){

            protected void select(Object value) {
                WizardPopup.this.onSelectByMnemonic(value);
            }
        };
    }

    private void disposeAll() {
        WizardPopup root = PopupDispatcher.getActiveRoot();
        this.disposeAllParents(null);
        root.getStep().canceled();
    }

    public void goBack() {
        if (this.mySpeedSearch.isHoldingFilter()) {
            this.mySpeedSearch.reset();
            return;
        }
        if (this.myParent != null) {
            this.myParent.disposeChildren();
        } else {
            this.disposeAll();
        }
    }

    protected abstract JComponent createContent();

    @Override
    public void dispose() {
        super.dispose();
        this.myAutoSelectionTimer.stop();
        PopupDispatcher.unsetShowing(this);
        PopupDispatcher.clearRootIfNeeded(this);
        if (this.myOwnerWindow != null && this.myOwnerListener != null) {
            this.myOwnerWindow.removeComponentListener(this.myOwnerListener);
        }
    }

    public void disposeChildren() {
        if (this.myChild != null) {
            this.myChild.disposeChildren();
            Disposer.dispose((Disposable)this.myChild);
            this.myChild = null;
        }
    }

    @Override
    public void show(Component owner, int aScreenX, int aScreenY, boolean considerForcedXY) {
        LOG.assertTrue(!this.isDisposed());
        Rectangle targetBounds = new Rectangle(new Point(aScreenX, aScreenY), this.getContent().getPreferredSize());
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)targetBounds);
        if (this.getParent() != null) {
            Rectangle parentBounds = this.getParent().getBounds();
            parentBounds.x += 2;
            parentBounds.width -= 4;
            if (parentBounds.intersects(targetBounds)) {
                targetBounds.x = this.getParent().getBounds().x - targetBounds.width - 2;
            }
        }
        if (this.getParent() == null) {
            PopupDispatcher.setActiveRoot(this);
        } else {
            PopupDispatcher.setShowing(this);
        }
        LOG.assertTrue(!this.isDisposed(), (Object)("Disposed popup, parent=" + this.getParent()));
        super.show(owner, targetBounds.x, targetBounds.y, true);
    }

    @Override
    protected void afterShow() {
        super.afterShow();
        this.registerAutoMove();
        if (!this.myFocusTrackback.isMustBeShown()) {
            this.cancel();
        }
    }

    private void registerAutoMove() {
        if (this.myOwner != null) {
            this.myOwnerWindow = SwingUtilities.getWindowAncestor(this.myOwner);
            if (this.myOwnerWindow != null) {
                this.myLastOwnerPoint = this.myOwnerWindow.getLocationOnScreen();
                this.myOwnerListener = new MyComponentAdapter();
                this.myOwnerWindow.addComponentListener(this.myOwnerListener);
            }
        }
    }

    private void processParentWindowMoved() {
        if (this.isDisposed()) {
            return;
        }
        Point newOwnerPoint = this.myOwnerWindow.getLocationOnScreen();
        int deltaX = this.myLastOwnerPoint.x - newOwnerPoint.x;
        int deltaY = this.myLastOwnerPoint.y - newOwnerPoint.y;
        this.myLastOwnerPoint = newOwnerPoint;
        Window wnd = SwingUtilities.getWindowAncestor(this.getContent());
        Point current = wnd.getLocationOnScreen();
        this.setLocation(new Point(current.x - deltaX, current.y - deltaY));
    }

    protected abstract JComponent getPreferredFocusableComponent();

    @Override
    public void cancel(InputEvent e) {
        super.cancel(e);
        this.disposeChildren();
        Disposer.dispose((Disposable)this);
        this.getStep().canceled();
    }

    @Override
    public boolean isCancelKeyEnabled() {
        return super.isCancelKeyEnabled() && !this.mySpeedSearch.isHoldingFilter();
    }

    protected void disposeAllParents(InputEvent e) {
        this.myDisposeEvent = e;
        this.dispose();
        if (this.myParent != null) {
            this.myParent.disposeAllParents(null);
        }
    }

    public final void registerAction(@NonNls String aActionName, int aKeyCode, @JdkConstants.InputEventMask int aModifier, Action aAction) {
        this.myInputMap.put(KeyStroke.getKeyStroke(aKeyCode, aModifier), aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    protected String getActionForKeyStroke(KeyStroke keyStroke) {
        return (String)this.myInputMap.get(keyStroke);
    }

    public final void registerAction(@NonNls String aActionName, KeyStroke keyStroke, Action aAction) {
        this.myInputMap.put(keyStroke, aActionName);
        this.myActionMap.put(aActionName, aAction);
    }

    protected abstract InputMap getInputMap();

    protected abstract ActionMap getActionMap();

    protected final void setParentValue(Object parentValue) {
        this.myParentValue = parentValue;
    }

    @Override
    @NotNull
    protected AbstractPopup.MyContentPanel createContentPanel(boolean resizable, PopupBorder border, boolean isToDrawMacCorner) {
        MyContainer myContainer = new MyContainer(resizable, border, isToDrawMacCorner);
        if (myContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/WizardPopup", "createContentPanel"));
        }
        return myContainer;
    }

    public WizardPopup getParent() {
        return this.myParent;
    }

    public PopupStep getStep() {
        return this.myStep;
    }

    public final boolean dispatch(KeyEvent event) {
        KeyStroke stroke;
        if (event.getID() != 401 && event.getID() != 402) {
            return false;
        }
        if (event.getID() == 401 && this.proceedKeyEvent(event, stroke = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers(), false))) {
            return false;
        }
        if (event.getID() == 402) {
            stroke = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiers(), true);
            return this.proceedKeyEvent(event, stroke);
        }
        this.myMnemonicsSearch.process(event);
        this.mySpeedSearch.process(event);
        if (event.isConsumed()) {
            return true;
        }
        this.process(event);
        return event.isConsumed();
    }

    private boolean proceedKeyEvent(KeyEvent event, KeyStroke stroke) {
        Action action;
        if (this.myInputMap.get(stroke) != null && (action = this.myActionMap.get(this.myInputMap.get(stroke))) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this.getContent(), event.getID(), "", event.getWhen(), event.getModifiers()));
            return true;
        }
        return false;
    }

    protected void process(KeyEvent aEvent) {
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getContent().getLocationOnScreen(), this.getContent().getSize());
    }

    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        if (step instanceof ListPopupStep) {
            return new ListPopupImpl(parent, (ListPopupStep)step, parentValue);
        }
        if (step instanceof TreePopupStep) {
            return new TreePopupImpl(parent, (TreePopupStep)step, parentValue);
        }
        throw new IllegalArgumentException(step.getClass().toString());
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        this.myAutoSelectionTimer.stop();
        if (this.getStep().isAutoSelectionEnabled()) {
            this.onAutoSelectionTimer();
        }
    }

    protected final void restartTimer() {
        if (!this.myAutoSelectionTimer.isRunning()) {
            this.myAutoSelectionTimer.start();
        } else {
            this.myAutoSelectionTimer.restart();
        }
    }

    protected final void stopTimer() {
        this.myAutoSelectionTimer.stop();
    }

    protected void onAutoSelectionTimer() {
    }

    public boolean shouldBeShowing(Object value) {
        if (!this.myStep.isSpeedSearchEnabled()) {
            return true;
        }
        SpeedSearchFilter filter = this.myStep.getSpeedSearchFilter();
        if (!filter.canBeHidden(value)) {
            return true;
        }
        String text = filter.getIndexedString(value);
        return this.mySpeedSearch.shouldBeShowing(text);
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    protected void onSelectByMnemonic(Object value) {
    }

    protected abstract void onChildSelectedFor(Object var1);

    protected final void notifyParentOnChildSelection() {
        if (this.myParent == null || this.myParentValue == null) {
            return;
        }
        this.myParent.onChildSelectedFor(this.myParentValue);
    }

    @Override
    public final void setFinalRunnable(Runnable runnable) {
        if (this.getParent() == null) {
            super.setFinalRunnable(runnable);
        } else {
            this.getParent().setFinalRunnable(runnable);
        }
    }

    @Override
    public void setOk(boolean ok) {
        if (this.getParent() == null) {
            super.setOk(ok);
        } else {
            this.getParent().setOk(ok);
        }
    }

    private class MyComponentAdapter
    extends ComponentAdapter {
        private MyComponentAdapter() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            WizardPopup.this.processParentWindowMoved();
        }
    }

    private class MyContainer
    extends AbstractPopup.MyContentPanel {
        private MyContainer(boolean resizable, PopupBorder border, boolean drawMacCorner) {
            super(resizable, border, drawMacCorner);
            this.setOpaque(true);
            this.setFocusCycleRoot(true);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Point p = null;
            if (focusOwner != null && focusOwner.isShowing()) {
                p = focusOwner.getLocationOnScreen();
            }
            boolean isEmpty = (size = WizardPopup.this.getSize()) == null || size.height <= 1 && size.width <= 1;
            return isEmpty ? this.computeNotBiggerDimension(super.getPreferredSize().getSize(), p) : size;
        }

        private Dimension computeNotBiggerDimension(Dimension ofContent, Point locationOnScreen) {
            int resultWidth;
            int resultHeight;
            int n = resultHeight = ofContent.height > MAX_SIZE.height + 50 ? MAX_SIZE.height : ofContent.height;
            if (locationOnScreen != null) {
                Rectangle r = ScreenUtil.getScreenRectangle((Point)locationOnScreen);
                resultHeight = ofContent.height > r.height - r.height / 4 ? r.height - r.height / 4 : ofContent.height;
            }
            int n2 = resultWidth = ofContent.width > MAX_SIZE.width ? MAX_SIZE.width : ofContent.width;
            if (ofContent.height > MAX_SIZE.height) {
                resultWidth = (int)((double)resultWidth + ScrollPaneFactory.createScrollPane().getVerticalScrollBar().getPreferredSize().getWidth());
            }
            return new Dimension(resultWidth, resultHeight);
        }
    }
}

