/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.ui.popup.WizardPopup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class PopupDispatcher
implements AWTEventListener,
KeyEventDispatcher,
IdePopupEventDispatcher {
    private static WizardPopup ourActiveWizardRoot;
    private static WizardPopup ourShowingStep;
    private static final PopupDispatcher ourInstance;

    private PopupDispatcher() {
    }

    public static PopupDispatcher getInstance() {
        return ourInstance;
    }

    public static void setActiveRoot(WizardPopup aRootPopup) {
        PopupDispatcher.disposeActiveWizard();
        ourActiveWizardRoot = aRootPopup;
        ourShowingStep = aRootPopup;
        if (ApplicationManager.getApplication() != null) {
            IdeEventQueue.getInstance().getPopupManager().push(ourInstance);
        }
    }

    public static void clearRootIfNeeded(WizardPopup aRootPopup) {
        if (ourActiveWizardRoot == aRootPopup) {
            ourActiveWizardRoot = null;
            ourShowingStep = null;
            if (ApplicationManager.getApplication() != null) {
                IdeEventQueue.getInstance().getPopupManager().remove(ourInstance);
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.dispatchMouseEvent(event);
    }

    private boolean dispatchMouseEvent(AWTEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        if (ourShowingStep == null) {
            return false;
        }
        WizardPopup eachParent = ourShowingStep;
        MouseEvent mouseEvent = (MouseEvent)event;
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        do {
            if (!eachParent.getContent().isShowing()) {
                PopupDispatcher.getActiveRoot().cancel();
                return false;
            }
            if (!eachParent.getBounds().contains(point) && eachParent.canClose()) continue;
            return false;
        } while ((eachParent = eachParent.getParent()) != null);
        PopupDispatcher.getActiveRoot().cancel();
        return false;
    }

    public static boolean disposeActiveWizard() {
        if (ourActiveWizardRoot != null) {
            ourActiveWizardRoot.disposeChildren();
            ourActiveWizardRoot.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (ourShowingStep == null) {
            return false;
        }
        return ourShowingStep.dispatch(e);
    }

    public static void setShowing(WizardPopup aBaseWizardPopup) {
        ourShowingStep = aBaseWizardPopup;
    }

    public static void unsetShowing(WizardPopup aBaseWizardPopup) {
        ourShowingStep = aBaseWizardPopup.getParent();
    }

    public static WizardPopup getActiveRoot() {
        return ourActiveWizardRoot;
    }

    public static boolean isWizardShowing() {
        return ourActiveWizardRoot != null;
    }

    public Component getComponent() {
        return ourShowingStep != null ? ourShowingStep.getContent() : null;
    }

    public boolean dispatch(AWTEvent event) {
        if (event instanceof KeyEvent) {
            return this.dispatchKeyEvent((KeyEvent)event);
        }
        if (event instanceof MouseEvent) {
            return this.dispatchMouseEvent(event);
        }
        return false;
    }

    public boolean requestFocus() {
        if (ourShowingStep != null) {
            ourShowingStep.requestFocus();
        }
        return true;
    }

    public boolean close() {
        String s = "sdfsf";
        return PopupDispatcher.disposeActiveWizard();
    }

    static {
        ourInstance = new PopupDispatcher();
        if (System.getProperty("is.popup.test") != null || ApplicationManagerEx.getApplicationEx() != null && ApplicationManagerEx.getApplicationEx().isUnitTestMode()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(ourInstance, 501L);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(ourInstance);
        }
    }
}

