/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.growl;

import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Pointer;
import org.jetbrains.annotations.NotNull;

public class Growl {
    private static final String GROWL_APPLICATION_REGISTRATION_NOTIFICATION = "GrowlApplicationRegistrationNotification";
    private static final String GROWL_APP_NAME = "ApplicationName";
    private static final String GROWL_APP_ICON = "ApplicationIcon";
    private static final String GROWL_DEFAULT_NOTIFICATIONS = "DefaultNotifications";
    private static final String GROWL_ALL_NOTIFICATIONS = "AllNotifications";
    private static final String GROWL_NOTIFICATION_NAME = "NotificationName";
    private static final String GROWL_NOTIFICATION_TITLE = "NotificationTitle";
    private static final String GROWL_NOTIFICATION_DESCRIPTION = "NotificationDescription";
    private static final String GROWL_NOTIFICATION = "GrowlNotification";
    private final String myProductName;
    private String[] myAllNotifications;
    private String[] myDefaultNotification;

    public Growl(@NotNull String productName) {
        if (productName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/growl/Growl", "<init>"));
        }
        this.myProductName = productName;
    }

    public void register() {
        ID autoReleasePool = Growl.createAutoReleasePool();
        ID applicationIcon = Growl.getApplicationIcon();
        ID defaultNotifications = Foundation.fillArray((Object[])this.myDefaultNotification);
        ID allNotifications = Foundation.fillArray((Object[])this.myAllNotifications);
        ID userDict = Foundation.createDict((String[])new String[]{GROWL_APP_NAME, GROWL_APP_ICON, GROWL_DEFAULT_NOTIFICATIONS, GROWL_ALL_NOTIFICATIONS}, (Object[])new Object[]{this.myProductName, applicationIcon, defaultNotifications, allNotifications});
        ID center = Growl.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]);
        ID notificationName = Foundation.nsString((String)GROWL_APPLICATION_REGISTRATION_NOTIFICATION);
        Growl.invoke(center, "postNotificationName:object:userInfo:deliverImmediately:", notificationName, null, userDict, true);
        Growl.invoke(autoReleasePool, "release", new Object[0]);
    }

    public void notifyGrowlOf(String notification, String title, String description) {
        ID autoReleasePool = Growl.createAutoReleasePool();
        ID dict = Foundation.createDict((String[])new String[]{GROWL_NOTIFICATION_NAME, GROWL_NOTIFICATION_TITLE, GROWL_NOTIFICATION_DESCRIPTION, GROWL_APP_NAME}, (Object[])new Object[]{notification, title, description, this.myProductName});
        ID center = Growl.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]);
        ID notificationName = Foundation.nsString((String)GROWL_NOTIFICATION);
        Growl.invoke(center, "postNotificationName:object:userInfo:deliverImmediately:", notificationName, null, dict, true);
        Growl.invoke(autoReleasePool, "release", new Object[0]);
    }

    public void setAllowedNotifications(String[] allNotifications) {
        this.myAllNotifications = allNotifications;
    }

    public void setDefaultNotifications(String[] defaultNotification) {
        this.myDefaultNotification = defaultNotification;
    }

    private static ID createAutoReleasePool() {
        return Growl.invoke("NSAutoreleasePool", "new", new Object[0]);
    }

    private static ID getApplicationIcon() {
        ID sharedApp = Growl.invoke("NSApplication", "sharedApplication", new Object[0]);
        ID nsImage = Growl.invoke(sharedApp, "applicationIconImage", new Object[0]);
        return Growl.invoke(nsImage, "TIFFRepresentation", new Object[0]);
    }

    private static ID invoke(@NotNull String className, @NotNull String selector, Object ... args) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/growl/Growl", "invoke"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/mac/growl/Growl", "invoke"));
        }
        return Growl.invoke(Foundation.getObjcClass((String)className), selector, args);
    }

    private static ID invoke(@NotNull ID id, @NotNull String selector, Object ... args) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/growl/Growl", "invoke"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/mac/growl/Growl", "invoke"));
        }
        return Growl.invoke(id, Foundation.createSelector((String)selector), args);
    }

    private static ID invoke(@NotNull ID id, @NotNull Pointer selector, Object ... args) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/mac/growl/Growl", "invoke"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/mac/growl/Growl", "invoke"));
        }
        return Foundation.invoke((ID)id, (Pointer)selector, (Object[])args);
    }
}

