/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.ListModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class TreeList
extends JBList
implements TreeModelListener {
    private final TreeModel myTreeModel;
    private boolean myRootVisible = false;
    private final DefaultListModel myListModel = new DefaultListModel();

    public TreeList(TreeModel treeModel) {
        super.setModel((ListModel)this.myListModel);
        this.myTreeModel = treeModel;
        this.myTreeModel.addTreeModelListener(this);
        Object root = this.myTreeModel.getRoot();
        if (root instanceof TreeNode) {
            TreeNode node = (TreeNode)root;
            this.myListModel.addElement(node);
            if (this.myTreeModel instanceof DefaultTreeModel && ((DefaultTreeModel)this.myTreeModel).asksAllowsChildren() && node.getAllowsChildren()) {
                Enumeration<? extends TreeNode> enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode object = enumeration.nextElement();
                    this.myListModel.addElement(object);
                }
            }
        }
    }

    public boolean isRootVisible() {
        return this.myRootVisible;
    }

    public void setRootVisible(boolean rootVisible) {
        this.myRootVisible = rootVisible;
    }

    public void setModel(@NotNull ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TreeList", "setModel"));
        }
        throw new UnsupportedOperationException("TreeList accepts only TreeModel as a model");
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TreeList Showcase");
        frame.setLocation(0, 0);
        frame.setSize(800, 600);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Sample root node");
        for (int i = 0; i < 5; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode("Node #" + (i + 1));
            rootNode.add(node);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode, true);
        TreeList treeList = new TreeList(treeModel);
        contentPane.add((Component)((Object)treeList));
        frame.setVisible(true);
    }
}

