/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.TableCell;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableExpandableItemsHandler
extends AbstractExpandableItemsHandler<TableCell, JTable> {
    protected TableExpandableItemsHandler(final JTable table) {
        super(table);
        final ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TableExpandableItemsHandler.this.updateSelection(table);
            }
        };
        table.getSelectionModel().addListSelectionListener(selectionListener);
        table.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        table.addPropertyChangeListener("selectionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((ListSelectionModel)evt.getOldValue()).removeListSelectionListener(selectionListener);
                }
                if (evt.getNewValue() != null) {
                    ((ListSelectionModel)evt.getNewValue()).addListSelectionListener(selectionListener);
                }
            }
        });
        table.addPropertyChangeListener("columnModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((TableColumnModel)evt.getOldValue()).getSelectionModel().removeListSelectionListener(selectionListener);
                }
                if (evt.getNewValue() != null) {
                    ((TableColumnModel)evt.getNewValue()).getSelectionModel().addListSelectionListener(selectionListener);
                }
            }
        });
        final TableModelListener modelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TableExpandableItemsHandler.this.updateSelection(table);
                    }
                });
            }
        };
        if (table.getModel() != null) {
            table.getModel().addTableModelListener(modelListener);
        }
        table.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableExpandableItemsHandler.this.updateSelection(table);
                if (evt.getOldValue() != null) {
                    ((TableModel)evt.getOldValue()).removeTableModelListener(modelListener);
                }
                if (evt.getNewValue() != null) {
                    ((TableModel)evt.getNewValue()).addTableModelListener(modelListener);
                }
            }
        });
    }

    private void updateSelection(JTable table) {
        int row = table.getSelectedRowCount() == 1 ? table.getSelectedRow() : -1;
        int column = table.getSelectedColumnCount() == 1 ? table.getSelectedColumn() : -1;
        this.handleSelectionChange(row == -1 || column == -1 ? null : new TableCell(row, column));
    }

    private Rectangle getCellRect(TableCell tableCellKey) {
        return ((JTable)this.myComponent).getCellRect(tableCellKey.row, tableCellKey.column, false);
    }

    @Override
    public Pair<Component, Rectangle> getCellRendererAndBounds(TableCell key) {
        Rectangle cellRect = this.getCellRect(key);
        int modelColumnIndex = ((JTable)this.myComponent).convertColumnIndexToModel(key.column);
        int modelRowIndex = ((JTable)this.myComponent).convertRowIndexToModel(key.row);
        TableModel model = ((JTable)this.myComponent).getModel();
        if (key.row < 0 || key.row >= model.getRowCount() || key.column < 0 || key.column >= model.getColumnCount()) {
            return null;
        }
        Component renderer = ((JTable)this.myComponent).getCellRenderer(key.row, key.column).getTableCellRendererComponent((JTable)this.myComponent, model.getValueAt(modelRowIndex, modelColumnIndex), ((JTable)this.myComponent).getSelectionModel().isSelectedIndex(key.row), ((JTable)this.myComponent).hasFocus(), key.row, key.column);
        cellRect.width = renderer.getPreferredSize().width;
        return Pair.create((Object)renderer, (Object)cellRect);
    }

    @Override
    public Rectangle getVisibleRect(TableCell key) {
        Rectangle columnVisibleRect = ((JTable)this.myComponent).getVisibleRect();
        Rectangle cellRect = this.getCellRect(key);
        int visibleRight = Math.min(columnVisibleRect.x + columnVisibleRect.width, cellRect.x + cellRect.width);
        columnVisibleRect.x = Math.min(columnVisibleRect.x, cellRect.x);
        columnVisibleRect.width = Math.max(0, visibleRight - columnVisibleRect.x);
        return columnVisibleRect;
    }

    @Override
    public TableCell getCellKeyForPoint(Point point) {
        int rowIndex = ((JTable)this.myComponent).rowAtPoint(point);
        if (rowIndex == -1) {
            return null;
        }
        int columnIndex = ((JTable)this.myComponent).columnAtPoint(point);
        if (columnIndex == -1) {
            return null;
        }
        return new TableCell(rowIndex, columnIndex);
    }
}

