/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.GrowlNotifications;
import com.intellij.ui.LibNotifyWrapper;
import com.intellij.ui.MountainLionNotifications;
import com.intellij.ui.SystemNotifications;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="SystemNotifications", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class SystemNotificationsImpl
extends SystemNotifications
implements PersistentStateComponent<State> {
    private final Notifier myNotifier = SystemNotificationsImpl.getPlatformNotifier();
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @Override
    public void notify(@NotNull String notificationName, @NotNull String title, @NotNull String text) {
        if (notificationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/SystemNotificationsImpl", "notify"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/SystemNotificationsImpl", "notify"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/SystemNotificationsImpl", "notify"));
        }
        if (this.myNotifier != null && !ApplicationManager.getApplication().isActive()) {
            this.myState.NOTIFICATIONS.add(notificationName);
            this.myNotifier.notify(this.myState.NOTIFICATIONS, notificationName, title, text);
        }
    }

    private static Notifier getPlatformNotifier() {
        try {
            if (SystemInfo.isMac) {
                if (SystemInfo.isMacOSMountainLion && Registry.is((String)"ide.mac.mountain.lion.notifications.enabled")) {
                    return MountainLionNotifications.getInstance();
                }
                if (!Boolean.getBoolean("growl.disable")) {
                    return GrowlNotifications.getInstance();
                }
            }
            if (SystemInfo.isXWindow && Registry.is((String)"ide.libnotify.enabled")) {
                return LibNotifyWrapper.getInstance();
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getInstance(SystemNotifications.class);
            if (logger.isDebugEnabled()) {
                logger.debug(t);
            }
            logger.info(t.getMessage());
        }
        return null;
    }

    static interface Notifier {
        public void notify(@NotNull Set<String> var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);
    }

    public static class State {
        public Set<String> NOTIFICATIONS = new HashSet<String>();
    }
}

