/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.ui.SimpleEditorCustomization;
import org.jetbrains.annotations.NotNull;

public class RightMarginEditorCustomization
extends SimpleEditorCustomization {
    private int myRightMarginColumns;

    public RightMarginEditorCustomization(boolean enabled, int rightMarginColumns) {
        super(enabled);
        this.myRightMarginColumns = rightMarginColumns;
    }

    public int getRightMarginColumns() {
        return this.myRightMarginColumns;
    }

    @Override
    public void customize(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/RightMarginEditorCustomization", "customize"));
        }
        if (this.isEnabled()) {
            editor.getSettings().setRightMarginShown(true);
            editor.getSettings().setRightMargin(this.getRightMarginColumns());
            editor.setColorsScheme(EditorColorsManager.getInstance().getGlobalScheme());
        } else {
            editor.getSettings().setRightMarginShown(false);
        }
    }
}

