/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroAwareTextBrowseFolderListener
extends TextBrowseFolderListener {
    public MacroAwareTextBrowseFolderListener(@NotNull FileChooserDescriptor fileChooserDescriptor, @Nullable Project project) {
        if (fileChooserDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/MacroAwareTextBrowseFolderListener", "<init>"));
        }
        super(fileChooserDescriptor, project);
    }

    @NotNull
    protected String expandPath(@NotNull String path) {
        Module module;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/MacroAwareTextBrowseFolderListener", "expandPath"));
        }
        Project project = this.getProject();
        if (project != null) {
            path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        }
        if ((module = (Module)this.myFileChooserDescriptor.getUserData(LangDataKeys.MODULE_CONTEXT)) == null) {
            module = (Module)this.myFileChooserDescriptor.getUserData(LangDataKeys.MODULE);
        }
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        String string = super.expandPath(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/MacroAwareTextBrowseFolderListener", "expandPath"));
        }
        return string;
    }
}

