/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class LibNotifyWrapper
implements SystemNotificationsImpl.Notifier {
    private static LibNotifyWrapper ourInstance;
    private final LibNotify myLibNotify = (LibNotify)Native.loadLibrary((String)"libnotify.so.4", LibNotify.class);

    public static synchronized LibNotifyWrapper getInstance() {
        if (ourInstance == null) {
            ourInstance = new LibNotifyWrapper();
        }
        return ourInstance;
    }

    private LibNotifyWrapper() {
        String appName = ApplicationNamesInfo.getInstance().getProductName();
        if (this.myLibNotify.notify_init(appName) == 0) {
            throw new IllegalStateException("notify_init failed");
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appClosing() {
                LibNotifyWrapper.this.myLibNotify.notify_uninit();
            }
        });
    }

    @Override
    public void notify(@NotNull Set<String> allNames, @NotNull String name, @NotNull String title, @NotNull String description) {
        if (allNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/LibNotifyWrapper", "notify"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/LibNotifyWrapper", "notify"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/LibNotifyWrapper", "notify"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/LibNotifyWrapper", "notify"));
        }
        String icon = AppUIUtil.findIcon(PathManager.getBinPath());
        if (icon == null) {
            icon = "dialog-information";
        }
        Pointer notification = this.myLibNotify.notify_notification_new(title, description, icon);
        this.myLibNotify.notify_notification_show(notification, null);
    }

    private static interface LibNotify
    extends Library {
        public int notify_init(String var1);

        public void notify_uninit();

        public Pointer notify_notification_new(String var1, String var2, String var3);

        public int notify_notification_show(Pointer var1, Pointer var2);
    }
}

