/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.Nullable;

public class JavaReferenceEditorUtil {
    private JavaReferenceEditorUtil() {
    }

    public static ReferenceEditorWithBrowseButton createReferenceEditorWithBrowseButton(ActionListener browseActionListener, String text, final Project project, final boolean toAcceptClasses) {
        return new ReferenceEditorWithBrowseButton(browseActionListener, project, (Function<String, Document>)new NullableFunction<String, Document>(){

            public Document fun(String s) {
                return JavaReferenceEditorUtil.createDocument(s, project, toAcceptClasses);
            }
        }, text);
    }

    @Nullable
    public static Document createDocument(String text, Project project, boolean isClassesAccepted) {
        return JavaReferenceEditorUtil.createDocument(text, project, isClassesAccepted, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
    }

    @Nullable
    public static Document createDocument(String text, Project project, boolean isClassesAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment(text, (PsiElement)defaultPackage, true, isClassesAccepted);
        fragment.setVisibilityChecker(visibilityChecker);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    @Nullable
    public static Document createTypeDocument(String text, Project project) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        PsiTypeCodeFragment fragment = factory.createTypeCodeFragment(text, (PsiElement)defaultPackage, true);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }
}

