/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.PopupUpdateProcessor;
import java.awt.Component;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class JBTreeWithHintProvider
extends DnDAwareTree {
    private JBPopup myHint;

    public JBTreeWithHintProvider() {
        this.addSelectionListener();
    }

    public JBTreeWithHintProvider(TreeModel treemodel) {
        super(treemodel);
        this.addSelectionListener();
    }

    public JBTreeWithHintProvider(TreeNode root) {
        super(root);
        this.addSelectionListener();
    }

    private void addSelectionListener() {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PsiElement psiElement;
                TreePath path;
                if (JBTreeWithHintProvider.this.isHintBeingShown() && JBTreeWithHintProvider.this.getClientProperty("byMouseEvent") != Boolean.TRUE && (path = JBTreeWithHintProvider.this.getSelectionPath()) != null && (psiElement = JBTreeWithHintProvider.this.getPsiElementForHint(path.getLastPathComponent())) != null && psiElement.isValid()) {
                    JBTreeWithHintProvider.this.updateHint(psiElement);
                }
            }
        });
    }

    @Nullable
    protected PsiElement getPsiElementForHint(Object selectedValue) {
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext((Component)((Object)this)));
    }

    public void registerHint(JBPopup hint) {
        this.hideHint();
        this.myHint = hint;
    }

    public void hideHint() {
        if (this.isHintBeingShown()) {
            this.myHint.cancel();
        }
        this.myHint = null;
    }

    public void updateHint(PsiElement element) {
        if (!this.isHintBeingShown()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    private boolean isHintBeingShown() {
        return this.myHint != null && this.myHint.isVisible();
    }
}

