/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.mac.growl.Growl;
import com.intellij.util.ArrayUtil;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class GrowlNotifications
implements SystemNotificationsImpl.Notifier {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.GrowlNotifications");
    private static GrowlNotifications ourNotifications;
    private final Growl myGrowl = new Growl(ApplicationNamesInfo.getInstance().getFullProductName());
    private final Set<String> myNotifications = new TreeSet<String>();

    public static synchronized GrowlNotifications getInstance() {
        if (ourNotifications == null) {
            ourNotifications = new GrowlNotifications();
        }
        return ourNotifications;
    }

    private GrowlNotifications() {
        this.register();
    }

    private void register() {
        this.myGrowl.setAllowedNotifications(ArrayUtil.toStringArray(this.myNotifications));
        this.myGrowl.setDefaultNotifications(ArrayUtil.toStringArray(this.myNotifications));
        this.myGrowl.register();
    }

    @Override
    public void notify(@NotNull Set<String> allNames, @NotNull String name, @NotNull String title, @NotNull String description) {
        if (allNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/GrowlNotifications", "notify"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/GrowlNotifications", "notify"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ui/GrowlNotifications", "notify"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/ui/GrowlNotifications", "notify"));
        }
        try {
            if (!((Object)this.myNotifications).equals(allNames)) {
                this.myNotifications.addAll(allNames);
                this.register();
            }
            this.myGrowl.notifyGrowlOf(name, title, description);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }
}

