/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.Hint;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpansionHint
implements Hint {
    private final JComponent myComponent;
    private final List<HintListener> myListeners;
    private JBPopup myPopup;

    public ExpansionHint(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExpansionHint", "<init>"));
        }
        this.myComponent = component;
        this.myListeners = ContainerUtil.newSmartList((Object[])new Object[0]);
    }

    @Override
    public void show(@NotNull JComponent parentComponent, int x, int y, @Nullable JComponent focusBackComponent, @Nullable HintHint hh) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExpansionHint", "show"));
        }
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.myComponent, null).setRequestFocus(false).setFocusable(false).setResizable(false).setMovable(false).setModalContext(false).setShowShadow(false).setShowBorder(false).setCancelKeyEnabled(false).setCancelOnClickOutside(false).setCancelOnOtherWindowOpen(false).createPopup();
        this.myPopup.show(new RelativePoint((Component)parentComponent, new Point(x, y)));
    }

    @Override
    public boolean isVisible() {
        return this.myComponent.isShowing();
    }

    @Override
    public void hide() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
        this.fireHintHidden();
    }

    private void fireHintHidden() {
        EventObject event = new EventObject(this);
        for (HintListener listener : this.myListeners) {
            listener.hintHidden(event);
        }
    }

    @Override
    public void pack() {
    }

    @Override
    public void updateBounds(int x, int y) {
    }

    @Override
    public void setLocation(@NotNull RelativePoint point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExpansionHint", "setLocation"));
        }
        if (this.myPopup != null) {
            this.myPopup.setLocation(point.getScreenPoint());
        }
    }

    @Override
    public void addHintListener(@NotNull HintListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExpansionHint", "addHintListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeHintListener(@NotNull HintListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/ExpansionHint", "removeHintListener"));
        }
        this.myListeners.remove(listener);
    }
}

