/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpansionHint;
import com.intellij.ui.Hint;
import com.intellij.ui.HintHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExpandableItemsHandler<KeyType, ComponentType extends JComponent>
implements ExpandableItemsHandler<KeyType> {
    protected final ComponentType myComponent;
    private final Alarm myUpdateAlarm;
    private final CellRendererPane myRendererPane;
    private final TipComponent myTipComponent;
    private boolean myEnabled;
    private Hint myHint;
    private KeyType myKey;
    private Rectangle myKeyItemBounds;
    private BufferedImage myImage;

    protected AbstractExpandableItemsHandler(@NotNull ComponentType component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/AbstractExpandableItemsHandler", "<init>"));
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myRendererPane = new CellRendererPane();
        this.myEnabled = Registry.is((String)"ide.expansion.hints.enabled");
        this.myComponent = component;
        ((Container)this.myComponent).add(this.myRendererPane);
        ((Container)this.myComponent).validate();
        this.myTipComponent = new TipComponent();
        ((Component)this.myComponent).addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }
        });
        ((Component)this.myComponent).addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(e, false);
            }
        });
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractExpandableItemsHandler.this.onFocusLost();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }
        });
    }

    protected void onFocusLost() {
        this.hideHint();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
        if (!this.myEnabled) {
            this.hideHint();
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public Collection<KeyType> getExpandedItems() {
        Collection<Object> collection = this.myKey == null ? Collections.emptyList() : Collections.singleton(this.myKey);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AbstractExpandableItemsHandler", "getExpandedItems"));
        }
        return collection;
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this.myKey, true);
    }

    private void handleMouseEvent(MouseEvent e) {
        this.handleMouseEvent(e, true);
    }

    protected void handleMouseEvent(MouseEvent e, boolean forceUpdate) {
        KeyType selected = this.getCellKeyForPoint(e.getPoint());
        if (forceUpdate || !Comparing.equal(this.myKey, selected)) {
            this.handleSelectionChange(selected, true);
        }
    }

    protected void handleSelectionChange(KeyType selected) {
        this.handleSelectionChange(selected, false);
    }

    protected void handleSelectionChange(final KeyType selected, final boolean processIfUnfocused) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                AbstractExpandableItemsHandler.this.doHandleSelectionChange(selected, processIfUnfocused);
            }
        }, 10);
    }

    private void doHandleSelectionChange(KeyType selected, boolean processIfUnfocused) {
        if (!this.myEnabled) {
            return;
        }
        if (selected == null || !((Component)this.myComponent).isEnabled() || !((Component)this.myComponent).isShowing() || !((Component)this.myComponent).isFocusOwner() && !processIfUnfocused || this.isPopup()) {
            this.hideHint();
            return;
        }
        if (!Comparing.equal(this.myKey, selected)) {
            this.hideHint();
        }
        this.myKey = selected;
        Point location = this.createToolTipImage(this.myKey);
        if (location == null) {
            this.hideHint();
        } else if (this.myHint == null) {
            this.showHint(location);
        } else {
            this.repaintHint(location);
        }
    }

    protected boolean isPopup() {
        Window window = SwingUtilities.getWindowAncestor(this.myComponent);
        return window != null && !(window instanceof Dialog) && !(window instanceof Frame) && !AbstractExpandableItemsHandler.isHintsAllowed(window);
    }

    private static boolean isHintsAllowed(Window window) {
        JRootPane pane;
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return Boolean.TRUE.equals(pane.getClientProperty("ShowHints"));
        }
        return false;
    }

    private void hideHint() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myHint != null) {
            this.myHint.hide();
            this.myHint = null;
            this.repaintKeyItem();
        }
        this.myKey = null;
    }

    public boolean isShowing() {
        return this.myHint != null && this.myHint.isVisible();
    }

    private void showHint(Point location) {
        assert (this.myHint == null);
        if (!((Component)this.myComponent).isShowing()) {
            return;
        }
        this.myHint = new ExpansionHint(this.myTipComponent);
        this.myHint.show((JComponent)this.myComponent, location.x, location.y, (JComponent)this.myComponent, new HintHint((Component)this.myComponent, location));
        this.repaintKeyItem();
    }

    private void repaintHint(Point location) {
        if (this.myHint != null && this.myKey != null && ((Component)this.myComponent).isShowing()) {
            this.myHint.setLocation(new RelativePoint(this.myComponent, location));
            this.myTipComponent.repaint();
            this.repaintKeyItem();
        }
    }

    private void repaintKeyItem() {
        if (this.myKeyItemBounds != null) {
            ((JComponent)this.myComponent).repaint(this.myKeyItemBounds);
        }
    }

    @Nullable
    private Point createToolTipImage(@NotNull KeyType key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/AbstractExpandableItemsHandler", "createToolTipImage"));
        }
        Pair<Component, Rectangle> rendererAndBounds = this.getCellRendererAndBounds(key);
        if (rendererAndBounds == null) {
            return null;
        }
        Component renderer = (Component)rendererAndBounds.first;
        if (!(renderer instanceof JComponent)) {
            return null;
        }
        Rectangle cellBounds = this.myKeyItemBounds = (Rectangle)rendererAndBounds.second;
        Rectangle visibleRect = this.getVisibleRect(key);
        int width = cellBounds.x + cellBounds.width - (visibleRect.x + visibleRect.width);
        int height = cellBounds.height;
        if (width <= 0 || height <= 0) {
            return null;
        }
        if (cellBounds.y < visibleRect.y) {
            return null;
        }
        if (cellBounds.y + cellBounds.height > visibleRect.y + visibleRect.height) {
            return null;
        }
        Dimension size = this.getImageSize(width, height);
        this.myImage = UIUtil.createImage((int)size.width, (int)size.height, (int)1);
        Graphics2D g = this.myImage.createGraphics();
        g.setClip(null);
        this.doFillBackground(height, width, g);
        g.translate(-(visibleRect.x + visibleRect.width - cellBounds.x), 0);
        this.doPaintTooltipImage(renderer, cellBounds, height, g, key);
        if (this.isPaintBorder()) {
            g.translate(visibleRect.x + visibleRect.width - cellBounds.x, 0);
            g.setColor(this.getBorderColor());
            int rightX = size.width - 1;
            int h = size.height;
            UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)rightX, (int)0);
            UIUtil.drawLine((Graphics)g, (int)rightX, (int)0, (int)rightX, (int)(h - 1));
            UIUtil.drawLine((Graphics)g, (int)0, (int)(h - 1), (int)rightX, (int)(h - 1));
        }
        g.dispose();
        this.myRendererPane.remove(renderer);
        return new Point(visibleRect.x + visibleRect.width, cellBounds.y);
    }

    protected boolean isPaintBorder() {
        return true;
    }

    protected Color getBorderColor() {
        return UIUtil.getListSelectionBackground();
    }

    protected Dimension getImageSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected void doFillBackground(int height, int width, Graphics2D g) {
        g.setColor(((Component)this.myComponent).getBackground());
        g.fillRect(0, 0, width, height);
    }

    protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, int height, Graphics2D g, KeyType key) {
        this.myRendererPane.paintComponent(g, rComponent, (Container)this.myComponent, 0, 0, cellBounds.width, height, true);
    }

    protected Rectangle getVisibleRect(KeyType key) {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    @Nullable
    protected abstract Pair<Component, Rectangle> getCellRendererAndBounds(KeyType var1);

    protected abstract KeyType getCellKeyForPoint(Point var1);

    private class TipComponent
    extends JComponent {
        private TipComponent() {
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(AbstractExpandableItemsHandler.this.myImage.getWidth(), AbstractExpandableItemsHandler.this.myImage.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            UIUtil.drawImage((Graphics)g, (Image)AbstractExpandableItemsHandler.this.myImage, (int)0, (int)0, null);
        }
    }
}

