/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsGroup;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ToolsProcessor<T extends Tool>
extends BaseSchemeProcessor<ToolsGroup<T>> {
    @NonNls
    private static final String TOOL_SET = "toolSet";
    @NonNls
    private static final String TOOL = "tool";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHOW_IN_MAIN_MENU = "showInMainMenu";
    @NonNls
    private static final String SHOW_IN_EDITOR = "showInEditor";
    @NonNls
    private static final String SHOW_IN_PROJECT = "showInProject";
    @NonNls
    private static final String SHOW_IN_SEARCH_POPUP = "showInSearchPopup";
    @NonNls
    private static final String DISABLED = "disabled";
    @NonNls
    private static final String USE_CONSOLE = "useConsole";
    @NonNls
    private static final String SHOW_CONSOLE_ON_STDOUT = "showConsoleOnStdOut";
    @NonNls
    private static final String SHOW_CONSOLE_ON_STDERR = "showConsoleOnStdErr";
    @NonNls
    private static final String SYNCHRONIZE_AFTER_EXECUTION = "synchronizeAfterRun";
    @NonNls
    private static final String EXEC = "exec";
    @NonNls
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    @NonNls
    private static final String COMMAND = "COMMAND";
    @NonNls
    private static final String PARAMETERS = "PARAMETERS";
    @NonNls
    private static final String FILTER = "filter";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String APPLICATION_HOME_MACRO = "$APPLICATION_HOME_DIR$";

    public ToolsGroup<T> readScheme(@NotNull Document document) throws InvalidDataException, IOException, JDOMException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tools/ToolsProcessor", "readScheme"));
        }
        Element root = document.getRootElement();
        if (root == null || !TOOL_SET.equals(root.getName())) {
            throw new InvalidDataException();
        }
        String groupName = root.getAttributeValue("name");
        ToolsGroup<T> result = this.createToolsGroup(groupName);
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication());
        Iterator i$ = root.getChildren(TOOL).iterator();
        while (i$.hasNext()) {
            Iterator i$2;
            Element o;
            Element element = o = (Element)i$.next();
            T tool = this.createTool();
            this.readToolAttributes(element, tool);
            Element exec = element.getChild(EXEC);
            if (exec != null) {
                i$2 = exec.getChildren(ELEMENT_OPTION).iterator();
                while (i$2.hasNext()) {
                    Element o1;
                    Element optionElement = o1 = (Element)i$2.next();
                    String name = optionElement.getAttributeValue("name");
                    String value = optionElement.getAttributeValue(ATTRIBUTE_VALUE);
                    if (WORKING_DIRECTORY.equals(name) && value != null) {
                        String replace = macroManager.expandPath(value).replace('/', File.separatorChar);
                        ((Tool)tool).setWorkingDirectory(replace);
                    }
                    if (COMMAND.equals(name)) {
                        ((Tool)tool).setProgram(macroManager.expandPath(ToolManager.convertString(value)));
                    }
                    if (!PARAMETERS.equals(name)) continue;
                    ((Tool)tool).setParameters(macroManager.expandPath(ToolManager.convertString(value)));
                }
            }
            i$2 = element.getChildren(FILTER).iterator();
            while (i$2.hasNext()) {
                Element o2;
                Element childNode = o2 = (Element)i$2.next();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.readExternal(childNode);
                ((Tool)tool).addOutputFilter(filterInfo);
            }
            ((Tool)tool).setGroup(groupName);
            result.addElement((SchemeElement)tool);
        }
        return result;
    }

    protected void readToolAttributes(Element element, T tool) {
        ((Tool)tool).setName(ToolManager.convertString(element.getAttributeValue("name")));
        ((Tool)tool).setDescription(ToolManager.convertString(element.getAttributeValue(DESCRIPTION)));
        ((Tool)tool).setShownInMainMenu(Boolean.valueOf(element.getAttributeValue(SHOW_IN_MAIN_MENU)));
        ((Tool)tool).setShownInEditor(Boolean.valueOf(element.getAttributeValue(SHOW_IN_EDITOR)));
        ((Tool)tool).setShownInProjectViews(Boolean.valueOf(element.getAttributeValue(SHOW_IN_PROJECT)));
        ((Tool)tool).setShownInSearchResultsPopup(Boolean.valueOf(element.getAttributeValue(SHOW_IN_SEARCH_POPUP)));
        ((Tool)tool).setEnabled(Boolean.valueOf(element.getAttributeValue(DISABLED)) == false);
        ((Tool)tool).setUseConsole(Boolean.valueOf(element.getAttributeValue(USE_CONSOLE)));
        ((Tool)tool).setShowConsoleOnStdOut(Boolean.valueOf(element.getAttributeValue(SHOW_CONSOLE_ON_STDOUT)));
        ((Tool)tool).setShowConsoleOnStdErr(Boolean.valueOf(element.getAttributeValue(SHOW_CONSOLE_ON_STDERR)));
        ((Tool)tool).setFilesSynchronizedAfterRun(Boolean.valueOf(element.getAttributeValue(SYNCHRONIZE_AFTER_EXECUTION)));
    }

    protected abstract ToolsGroup<T> createToolsGroup(String var1);

    protected abstract T createTool();

    public Document writeScheme(@NotNull ToolsGroup<T> scheme) throws WriteExternalException {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tools/ToolsProcessor", "writeScheme"));
        }
        Element groupElement = new Element(TOOL_SET);
        if (scheme.getName() != null) {
            groupElement.setAttribute("name", scheme.getName());
        }
        for (Tool tool : scheme.getElements()) {
            this.saveTool(tool, groupElement);
        }
        return new Document(groupElement);
    }

    public boolean shouldBeSaved(@NotNull ToolsGroup scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tools/ToolsProcessor", "shouldBeSaved"));
        }
        return true;
    }

    private void saveTool(T tool, Element groupElement) {
        FilterInfo[] filters;
        Element element = new Element(TOOL);
        if (((Tool)tool).getName() != null) {
            element.setAttribute("name", ((Tool)tool).getName());
        }
        if (((Tool)tool).getDescription() != null) {
            element.setAttribute(DESCRIPTION, ((Tool)tool).getDescription());
        }
        this.saveToolAttributes(tool, element);
        Element taskElement = new Element(EXEC);
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication());
        Element option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", COMMAND);
        if (((Tool)tool).getProgram() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getProgram()));
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", PARAMETERS);
        if (((Tool)tool).getParameters() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getParameters()));
        }
        option = new Element(ELEMENT_OPTION);
        taskElement.addContent(option);
        option.setAttribute("name", WORKING_DIRECTORY);
        if (((Tool)tool).getWorkingDirectory() != null) {
            option.setAttribute(ATTRIBUTE_VALUE, macroManager.collapsePath(((Tool)tool).getWorkingDirectory()).replace(File.separatorChar, '/'));
        }
        element.addContent(taskElement);
        for (FilterInfo filter : filters = ((Tool)tool).getOutputFilters()) {
            Element filterElement = new Element(FILTER);
            filter.writeExternal(filterElement);
            element.addContent(filterElement);
        }
        groupElement.addContent(element);
    }

    protected void saveToolAttributes(T tool, Element element) {
        element.setAttribute(SHOW_IN_MAIN_MENU, Boolean.toString(((Tool)tool).isShownInMainMenu()));
        element.setAttribute(SHOW_IN_EDITOR, Boolean.toString(((Tool)tool).isShownInEditor()));
        element.setAttribute(SHOW_IN_PROJECT, Boolean.toString(((Tool)tool).isShownInProjectViews()));
        element.setAttribute(SHOW_IN_SEARCH_POPUP, Boolean.toString(((Tool)tool).isShownInSearchResultsPopup()));
        element.setAttribute(DISABLED, Boolean.toString(!((Tool)tool).isEnabled()));
        element.setAttribute(USE_CONSOLE, Boolean.toString(((Tool)tool).isUseConsole()));
        element.setAttribute(SHOW_CONSOLE_ON_STDOUT, Boolean.toString(((Tool)tool).isShowConsoleOnStdOut()));
        element.setAttribute(SHOW_CONSOLE_ON_STDERR, Boolean.toString(((Tool)tool).isShowConsoleOnStdErr()));
        element.setAttribute(SYNCHRONIZE_AFTER_EXECUTION, Boolean.toString(((Tool)tool).synchronizeAfterExecution()));
    }
}

