/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.tools.HackyDataContext;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsProvider;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ToolAction
extends AnAction
implements DumbAware {
    private final String myActionId;

    public ToolAction(Tool tool) {
        this.myActionId = tool.getActionId();
        this.getTemplatePresentation().setText(tool.getName(), false);
        this.getTemplatePresentation().setDescription(tool.getDescription());
    }

    public void actionPerformed(AnActionEvent e) {
        ToolAction.runTool(this.myActionId, e.getDataContext(), e, 0L, null);
    }

    public void update(AnActionEvent e) {
        Tool tool = ToolAction.findTool(this.myActionId, e.getDataContext());
        if (tool != null) {
            e.getPresentation().setText(ToolRunProfile.expandMacrosInName(tool, e.getDataContext()));
        }
    }

    private static Tool findTool(String actionId, DataContext context) {
        MacroManager.getInstance().cacheMacrosPreview(context);
        for (Tool tool : ToolAction.getAllTools()) {
            if (!actionId.equals(tool.getActionId())) continue;
            return tool;
        }
        return null;
    }

    protected static List<Tool> getAllTools() {
        return ToolsProvider.getAllTools();
    }

    static void runTool(String actionId, DataContext context) {
        ToolAction.runTool(actionId, context, null, 0L, null);
    }

    static boolean runTool(String actionId, DataContext context, @Nullable AnActionEvent e, long executionId, @Nullable ProcessListener processListener) {
        Tool tool = ToolAction.findTool(actionId, context);
        if (tool != null) {
            return tool.execute(e, new HackyDataContext(context), executionId, processListener);
        }
        return false;
    }
}

