/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolSelectDialog;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.tools.ToolsPanel;
import com.intellij.tools.ToolsProjectConfig;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExternalToolsCheckinHandlerFactory
extends CheckinHandlerFactory {
    public static final Object NONE_TOOL = new Object();

    @NotNull
    public CheckinHandler createHandler(final CheckinProjectPanel panel, CommitContext commitContext) {
        final ToolsProjectConfig config = ToolsProjectConfig.getInstance(panel.getProject());
        CheckinHandler checkinHandler = new CheckinHandler(){

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                JLabel label = new JLabel(ToolsBundle.message("tools.after.commit.description", new Object[0]));
                ComboboxWithBrowseButton listComponent = new ComboboxWithBrowseButton();
                final JComboBox comboBox = listComponent.getComboBox();
                comboBox.setModel(new CollectionComboBoxModel(ExternalToolsCheckinHandlerFactory.getComboBoxElements(), null));
                comboBox.setRenderer(new ListCellRendererWrapper<Object>(){

                    public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                        if (value instanceof ToolsGroup) {
                            this.setText(StringUtil.notNullize((String)((ToolsGroup)((Object)value)).getName(), (String)ToolsBundle.message("tools.unnamed.group", new Object[0])));
                        } else if (value instanceof Tool) {
                            this.setText("  " + StringUtil.notNullize((String)((Tool)value).getName()));
                        } else {
                            this.setText(ToolsBundle.message("tools.list.item.none", new Object[0]));
                        }
                    }
                });
                listComponent.getButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object item = comboBox.getSelectedItem();
                        String id = null;
                        if (item instanceof Tool) {
                            id = ((Tool)item).getActionId();
                        }
                        ToolSelectDialog dialog = new ToolSelectDialog(panel.getProject(), id, new ToolsPanel());
                        dialog.show();
                        if (!dialog.isOK()) {
                            return;
                        }
                        comboBox.setModel(new CollectionComboBoxModel(ExternalToolsCheckinHandlerFactory.getComboBoxElements(), (Object)dialog.getSelectedTool()));
                    }
                });
                BorderLayout layout = new BorderLayout();
                layout.setVgap(3);
                final JPanel panel2 = new JPanel(layout);
                panel2.add((Component)label, "North");
                panel2.add((Component)listComponent, "Center");
                listComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                if (comboBox.getItemCount() == 0 || comboBox.getItemCount() == 1 && comboBox.getItemAt(0) == NONE_TOOL) {
                    return null;
                }
                return new RefreshableOnComponent(){

                    public JComponent getComponent() {
                        return panel2;
                    }

                    public void refresh() {
                        String id = config.getAfterCommitToolsId();
                        if (id == null) {
                            comboBox.setSelectedIndex(-1);
                        } else {
                            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                                Object itemAt = comboBox.getItemAt(i);
                                if (!(itemAt instanceof Tool) || !id.equals(((Tool)itemAt).getActionId())) continue;
                                comboBox.setSelectedIndex(i);
                                return;
                            }
                        }
                    }

                    public void saveState() {
                        Object item = comboBox.getSelectedItem();
                        config.setAfterCommitToolId(item instanceof Tool ? ((Tool)item).getActionId() : null);
                    }

                    public void restoreState() {
                        this.refresh();
                    }
                };
            }

            public void checkinSuccessful() {
                final String id = config.getAfterCommitToolsId();
                if (id == null) {
                    return;
                }
                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                    public void consume(final DataContext context) {
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ToolAction.runTool(id, context);
                            }
                        });
                    }
                });
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/ExternalToolsCheckinHandlerFactory", "createHandler"));
        }
        return checkinHandler;
    }

    private static List<Object> getComboBoxElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        ToolManager manager = ToolManager.getInstance();
        result.add(NONE_TOOL);
        for (ToolsGroup group : manager.getGroups()) {
            result.add((Object)group);
            Collections.addAll(result, manager.getTools(group.getName()));
        }
        return result;
    }
}

