/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool>
implements ExportableApplicationComponent {
    private final ActionManagerEx myActionManager;
    private final SchemesManager<ToolsGroup<T>, ToolsGroup<T>> mySchemesManager;

    public BaseToolManager(ActionManagerEx actionManagerEx, SchemesManagerFactory factory) {
        this.myActionManager = actionManagerEx;
        this.mySchemesManager = factory.createSchemesManager(this.getSchemesPath(), this.createProcessor(), RoamingType.PER_USER);
        this.mySchemesManager.loadSchemes();
        this.registerActions();
    }

    protected abstract String getSchemesPath();

    protected abstract SchemeProcessor<ToolsGroup<T>> createProcessor();

    @Nullable
    public static String convertString(String s) {
        if (s != null && s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{this.mySchemesManager.getRootDirectory()};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ToolsBundle.message("tools.settings", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getPresentableName"));
        }
        return string;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public List<T> getTools() {
        ArrayList result = new ArrayList();
        for (ToolsGroup group : this.mySchemesManager.getAllSchemes()) {
            result.addAll(group.getElements());
        }
        return result;
    }

    public List<T> getTools(String group) {
        ArrayList list = new ArrayList();
        ToolsGroup groupByName = (ToolsGroup)this.mySchemesManager.findSchemeByName(group);
        if (groupByName != null) {
            list.addAll(groupByName.getElements());
        }
        return list;
    }

    String[] getGroups(T[] tools) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tools.length; ++i) {
            T tool = tools[i];
            if (list.contains(((Tool)tool).getGroup())) continue;
            list.add(((Tool)tool).getGroup());
        }
        return ArrayUtil.toStringArray(list);
    }

    public String getGroupByActionId(String actionId) {
        for (Tool tool : this.getTools()) {
            if (!Comparing.equal((String)actionId, (String)tool.getActionId())) continue;
            return tool.getGroup();
        }
        return null;
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemesManager.getAllSchemes();
    }

    public void setTools(ToolsGroup[] tools) {
        this.mySchemesManager.clearAllSchemes();
        for (ToolsGroup newGroup : tools) {
            this.mySchemesManager.addNewScheme((Scheme)newGroup, true);
        }
        this.registerActions();
    }

    void registerActions() {
        this.unregisterActions();
        HashSet<String> registeredIds = new HashSet<String>();
        List<T> tools = this.getTools();
        for (Tool tool : tools) {
            String actionId = tool.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            this.myActionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    protected ToolAction createToolAction(T tool) {
        return new ToolAction((Tool)tool);
    }

    protected abstract String getActionIdPrefix();

    private void unregisterActions() {
        String[] oldIds = this.myActionManager.getActionIds(this.getActionIdPrefix());
        for (int i = 0; i < oldIds.length; ++i) {
            String oldId = oldIds[i];
            this.myActionManager.unregisterAction(oldId);
        }
    }
}

