/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaTestGenerator
implements TestGenerator {
    @Override
    public PsiElement generateTest(final Project project, final CreateTestDialog d) {
        return PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Computable<PsiElement>(){

            public PsiElement compute() {
                return (PsiElement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement>(){

                    public PsiElement compute() {
                        try {
                            IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
                            PsiClass targetClass = JavaTestGenerator.createTestClass(d);
                            JavaTestGenerator.addSuperClass(targetClass, project, d.getSuperClassName());
                            Editor editor = CodeInsightUtil.positionCursor(project, targetClass.getContainingFile(), targetClass.getLBrace());
                            JavaTestGenerator.addTestMethods(editor, targetClass, d.getSelectedTestFrameworkDescriptor(), d.getSelectedMethods(), d.shouldGeneratedBefore(), d.shouldGeneratedAfter());
                            return targetClass;
                        }
                        catch (IncorrectOperationException e) {
                            JavaTestGenerator.showErrorLater(project, d.getClassName());
                            return null;
                        }
                    }
                });
            }
        });
    }

    private static PsiClass createTestClass(CreateTestDialog d) {
        PsiClass classFromTemplate;
        TestFramework testFrameworkDescriptor = d.getSelectedTestFrameworkDescriptor();
        FileTemplateDescriptor fileTemplateDescriptor = TestIntegrationUtils.MethodKind.TEST_CLASS.getFileTemplateDescriptor(testFrameworkDescriptor);
        PsiDirectory targetDirectory = d.getTargetDirectory();
        if (fileTemplateDescriptor != null && (classFromTemplate = JavaTestGenerator.createTestClassFromCodeTemplate(d, fileTemplateDescriptor, targetDirectory)) != null) {
            return classFromTemplate;
        }
        return JavaDirectoryService.getInstance().createClass(targetDirectory, d.getClassName());
    }

    private static PsiClass createTestClassFromCodeTemplate(CreateTestDialog d, FileTemplateDescriptor fileTemplateDescriptor, PsiDirectory targetDirectory) {
        String templateName = fileTemplateDescriptor.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance().getCodeTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance().getDefaultProperties(targetDirectory.getProject());
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", d.getClassName());
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate(fileTemplate, templateName, properties, targetDirectory);
            if (psiElement instanceof PsiClass) {
                return (PsiClass)psiElement;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void addSuperClass(PsiClass targetClass, Project project, String superClassName) throws IncorrectOperationException {
        if (superClassName == null) {
            return;
        }
        PsiReferenceList extendsList = targetClass.getExtendsList();
        if (extendsList == null || extendsList.getReferencedTypes().length > 0) {
            return;
        }
        PsiElementFactory ef = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiClass superClass = JavaTestGenerator.findClass(project, superClassName);
        PsiJavaCodeReferenceElement superClassRef = superClass != null ? ef.createClassReferenceElement(superClass) : ef.createFQClassNameReferenceElement(superClassName, GlobalSearchScope.allScope((Project)project));
        extendsList.add((PsiElement)superClassRef);
    }

    @Nullable
    private static PsiClass findClass(Project project, String fqName) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName, scope);
    }

    private static void addTestMethods(Editor editor, PsiClass targetClass, TestFramework descriptor, Collection<MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        HashSet<String> existingNames = new HashSet<String>();
        if (generateBefore) {
            JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.SET_UP, descriptor, targetClass, editor, null, existingNames);
        }
        if (generateAfter) {
            JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEAR_DOWN, descriptor, targetClass, editor, null, existingNames);
        }
        for (MemberInfo m : methods) {
            JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEST, descriptor, targetClass, editor, ((PsiMember)m.getMember()).getName(), existingNames);
        }
    }

    private static void showErrorLater(final Project project, final String targetClassName) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project, (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{targetClassName}), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0]));
            }
        });
    }

    private static void generateMethod(TestIntegrationUtils.MethodKind methodKind, TestFramework descriptor, PsiClass targetClass, Editor editor, @Nullable String name, Set<String> existingNames) {
        PsiMethod method = (PsiMethod)targetClass.add((PsiElement)TestIntegrationUtils.createDummyMethod((PsiElement)targetClass));
        PsiDocumentManager.getInstance((Project)targetClass.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TestIntegrationUtils.runTestMethodTemplate(methodKind, descriptor, editor, targetClass, method, name, true, existingNames);
    }

    @Override
    public String toString() {
        return CodeInsightBundle.message((String)"intention.create.test.dialog.java", (Object[])new Object[0]);
    }
}

