/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestFinder
implements TestFinder {
    public PsiClass findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testIntegration/JavaTestFinder", "findSourceElement"));
        }
        return TestIntegrationUtils.findOuterClass(element);
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testIntegration/JavaTestFinder", "findClassesForTest"));
        }
        PsiClass klass = this.findSourceElement(element);
        if (klass == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findClassesForTest"));
            }
            return set;
        }
        Module module = JavaTestFinder.getModule(element);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)element.getProject());
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)element.getProject());
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithWeights = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        for (Pair<String, Integer> eachNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights(klass.getName())) {
            for (PsiClass eachClass : cache.getClassesByName((String)eachNameWithWeight.first, scope)) {
                if (!JavaTestFinder.isTestSubjectClass(eachClass)) continue;
                classesWithWeights.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachClass, eachNameWithWeight.second));
            }
        }
        List<PsiElement> list = TestFinderHelper.getSortedElements(classesWithWeights, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findClassesForTest"));
        }
        return list;
    }

    private static boolean isTestSubjectClass(PsiClass klass) {
        return !klass.isAnnotationType() && !TestFrameworks.getInstance().isTestClass(klass);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testIntegration/JavaTestFinder", "findTestsForClass"));
        }
        PsiClass klass = this.findSourceElement(element);
        if (klass == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findTestsForClass"));
            }
            return set;
        }
        Module module = JavaTestFinder.getModule(element);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependentsScope((Module)module) : GlobalSearchScope.projectScope((Project)element.getProject());
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)element.getProject());
        String klassName = klass.getName();
        Pattern pattern = Pattern.compile(".*" + klassName + ".*");
        ArrayList<Pair<? extends PsiNamedElement, Integer>> classesWithProximities = new ArrayList<Pair<? extends PsiNamedElement, Integer>>();
        HashSet names = new HashSet();
        cache.getAllClassNames(names);
        for (String eachName : names) {
            if (!pattern.matcher(eachName).matches()) continue;
            for (PsiClass eachClass : cache.getClassesByName(eachName, scope)) {
                if (!TestFrameworks.getInstance().isTestClass(eachClass)) continue;
                classesWithProximities.add((Pair<? extends PsiNamedElement, Integer>)new Pair((Object)eachClass, (Object)TestFinderHelper.calcTestNameProximity(klassName, eachName)));
            }
        }
        List<PsiElement> list = TestFinderHelper.getSortedElements(classesWithProximities, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/JavaTestFinder", "findTestsForClass"));
        }
        return list;
    }

    @Nullable
    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testIntegration/JavaTestFinder", "isTest"));
        }
        return TestIntegrationUtils.isTest(element);
    }
}

