/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.parameterInfo;

import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class MockUpdateParameterInfoContext
implements UpdateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private PsiElement myParameterOwner;
    private Object myHighlightedParameter;
    private int myCurrentParameter;

    public MockUpdateParameterInfoContext(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/utils/parameterInfo/MockUpdateParameterInfoContext", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/utils/parameterInfo/MockUpdateParameterInfoContext", "<init>"));
        }
        this.myEditor = editor;
        this.myFile = file;
    }

    public void removeHint() {
    }

    public void setParameterOwner(PsiElement o) {
        this.myParameterOwner = o;
    }

    public PsiElement getParameterOwner() {
        return this.myParameterOwner;
    }

    public void setHighlightedParameter(Object parameter) {
        this.myHighlightedParameter = parameter;
    }

    public void setCurrentParameter(int index) {
        this.myCurrentParameter = index;
    }

    public int getCurrentParameter() {
        return this.myCurrentParameter;
    }

    public boolean isUIComponentEnabled(int index) {
        return false;
    }

    public void setUIComponentEnabled(int index, boolean b) {
    }

    public int getParameterListStart() {
        return this.myEditor.getCaretModel().getOffset();
    }

    public Object[] getObjectsToView() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public Project getProject() {
        return this.myFile.getProject();
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public int getOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/utils/parameterInfo/MockUpdateParameterInfoContext", "getEditor"));
        }
        return editor;
    }
}

