/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JList;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    @NonNls
    private static final String PROFILE = "Configurable";
    private static final Function<IntentionAction, String> INTENTION_NAME_FUN = new Function<IntentionAction, String>(){

        public String fun(IntentionAction intentionAction) {
            return "\"" + intentionAction.getText() + "\"";
        }
    };
    private PsiManagerImpl myPsiManager;
    private PsiFile myFile;
    private Editor myEditor;
    private String myTestDataPath;
    private boolean myEmptyLookup;
    private InspectionProfileEntry[] myInspections;
    private final Map<String, InspectionToolWrapper> myAvailableTools = new THashMap();
    private final TempDirTestFixture myTempDirFixture;
    protected final IdeaProjectTestFixture myProjectFixture;
    @NonNls
    private static final String XXX = "XXX";
    private final FileTreeAccessFilter myJavaFilesFilter = new FileTreeAccessFilter();
    private boolean myAllowDirt;
    private boolean myCaresAboutInjection = true;
    private static final String START_FOLD = "<fold\\stext='[^']*'(\\sexpand='[^']*')*>";
    private static final String END_FOLD = "</fold>";

    public CodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirTestFixture) {
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    @Override
    public void setTestDataPath(String dataPath) {
        this.myTestDataPath = dataPath;
    }

    @Override
    public String getTempDirPath() {
        return this.myTempDirFixture.getTempDirPath();
    }

    @Override
    public TempDirTestFixture getTempDirFixture() {
        return this.myTempDirFixture;
    }

    @Override
    public VirtualFile copyFileToProject(@NonNls String sourceFilePath, @NonNls String targetPath) {
        VirtualFile result;
        String testDataPath = this.getTestDataPath();
        assert (testDataPath != null) : "test data path not specified";
        File fromFile = new File(testDataPath + "/" + sourceFilePath);
        if (!fromFile.exists()) {
            fromFile = new File(sourceFilePath);
        }
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            VirtualFile fromVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(fromFile);
            if (fromVFile == null) {
                fromVFile = this.myTempDirFixture.getFile(sourceFilePath);
            }
            assert (fromVFile != null) : "can't find test data file " + sourceFilePath + " (" + testDataPath + ")";
            result = this.myTempDirFixture.copyFile(fromVFile, targetPath);
        } else {
            File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
            if (!targetFile.exists()) {
                if (fromFile.isDirectory()) {
                    assert (targetFile.mkdirs()) : targetFile;
                } else {
                    if (!fromFile.exists()) {
                        Assert.fail((String)("Cannot find source file: '" + sourceFilePath + "'. getTestDataPath()='" + testDataPath + "'. "));
                    }
                    try {
                        FileUtil.copy((File)fromFile, (File)targetFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot copy " + fromFile + " to " + targetFile, e);
                    }
                }
            }
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
            assert (file != null) : targetFile;
            result = file;
        }
        result.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)fromFile.getPath());
        return result;
    }

    @Override
    public VirtualFile copyDirectoryToProject(@NonNls String sourceFilePath, @NonNls String targetPath) {
        String testDataPath = this.getTestDataPath();
        assert (testDataPath != null) : "test data path not specified";
        File fromFile = new File(testDataPath + "/" + sourceFilePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir((File)fromFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file);
        file.refresh(false, true);
        return file;
    }

    @Override
    public VirtualFile copyFileToProject(@NonNls String sourceFilePath) {
        return this.copyFileToProject(sourceFilePath, sourceFilePath);
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        this.myInspections = inspections;
        if (this.isInitialized()) {
            this.configureInspections(this.myInspections);
        }
    }

    private boolean isInitialized() {
        return this.myPsiManager != null;
    }

    @Override
    public void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspections"));
        }
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (Class<? extends LocalInspectionTool> clazz : inspections) {
            try {
                LocalInspectionTool inspection = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                tools.add(inspection);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate " + clazz);
            }
        }
        this.enableInspections((InspectionProfileEntry[])tools.toArray(new LocalInspectionTool[tools.size()]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "disableInspections"));
        }
        this.myAvailableTools.clear();
        ArrayList<InspectionProfileEntry> tools = new ArrayList<InspectionProfileEntry>(Arrays.asList(this.myInspections));
        Iterator i = tools.iterator();
        block0: while (i.hasNext()) {
            InspectionProfileEntry tool = (InspectionProfileEntry)i.next();
            for (InspectionProfileEntry toRemove : inspections) {
                if (!tool.getShortName().equals(toRemove.getShortName())) continue;
                i.remove();
                continue block0;
            }
        }
        this.myInspections = tools.toArray(new InspectionProfileEntry[tools.size()]);
        this.configureInspections(this.myInspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider provider : providers) {
            for (Class clazz : provider.getInspectionClasses()) {
                try {
                    Object o = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!(o instanceof LocalInspectionTool)) continue;
                    LocalInspectionTool inspection = (LocalInspectionTool)o;
                    tools.add(inspection);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate " + clazz, e);
                }
            }
        }
        this.myInspections = (InspectionProfileEntry[])tools.toArray(new LocalInspectionTool[tools.size()]);
        this.configureInspections(this.myInspections);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        try {
            return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : filePaths) {
            files.add(this.copyFileToProject(path));
        }
        return this.testHighlightingAllFiles(checkWarnings, checkInfos, checkWeakWarnings, VfsUtilCore.toVirtualFileArray(files));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        return this.collectAndCheckHighlightings(checkWarnings, checkInfos, checkWeakWarnings, files);
    }

    private long collectAndCheckHighlightings(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings, VirtualFile[] files) {
        List datas = ContainerUtil.map2List((Object[])files, (Function)new Function<VirtualFile, Trinity<PsiFile, Editor, ExpectedHighlightingData>>(){

            public Trinity<PsiFile, Editor, ExpectedHighlightingData> fun(VirtualFile file) {
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(file);
                Assert.assertNotNull((Object)psiFile);
                Document document = PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).getDocument(psiFile);
                Assert.assertNotNull((Object)document);
                ExpectedHighlightingData data = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, psiFile);
                data.init();
                return Trinity.create((Object)psiFile, (Object)CodeInsightTestFixtureImpl.this.createEditor(file), (Object)data);
            }
        });
        long elapsed = 0L;
        for (Trinity trinity : datas) {
            this.myEditor = (Editor)trinity.second;
            this.myFile = (PsiFile)trinity.first;
            elapsed += this.collectAndCheckHighlighting((ExpectedHighlightingData)trinity.third);
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        try {
            return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile file) {
        this.openFileInEditor(file);
        try {
            return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HighlightTestInfo testFile(String ... filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testFile"));
        }
        return new HighlightTestInfo(this.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, CodeInsightTestFixtureImpl.this.myFile);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                data.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data);
                return this;
            }
        };
    }

    public void openFileInEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "openFileInEditor"));
        }
        this.myFile = this.myPsiManager.findFile(file);
        this.myEditor = this.createEditor(file);
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper toolWrapper) {
        if (testDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testInspection"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "testInspection"));
        }
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "src");
        AnalysisScope scope = new AnalysisScope(this.getPsiManager().findDirectory(sourceDir));
        scope.invalidate();
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject());
        GlobalInspectionContextImpl globalContext = CodeInsightTestFixtureImpl.createGlobalContextForTool(scope, this.getProject(), inspectionManager, toolWrapper);
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext, inspectionManager);
        InspectionTestUtil.compareToolResults(globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @NotNull
    public static GlobalInspectionContextImpl createGlobalContextForTool(@NotNull AnalysisScope scope, final @NotNull Project project, @NotNull InspectionManagerEx inspectionManager, final InspectionToolWrapper ... toolWrappers) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        final InspectionProfileImpl profile = InspectionProfileImpl.createSimple("test", project, toolWrappers);
        GlobalInspectionContextImpl context = new GlobalInspectionContextImpl(project, inspectionManager.getContentManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<Tools> getUsedTools() {
                try {
                    InspectionProfileImpl.INIT_INSPECTIONS = true;
                    for (InspectionToolWrapper tool : toolWrappers) {
                        profile.enableTool(tool.getShortName(), project);
                    }
                    List<Tools> list = profile.getAllEnabledInspectionTools(project);
                    return list;
                }
                finally {
                    InspectionProfileImpl.INIT_INSPECTIONS = false;
                }
            }
        };
        context.setCurrentScope(scope);
        GlobalInspectionContextImpl globalInspectionContextImpl = context;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "createGlobalContextForTool"));
        }
        return globalInspectionContextImpl;
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        assert (reference != null) : "no reference found at " + this.myEditor.getCaretModel().getLogicalPosition();
        PsiReference psiReference = reference;
        if (psiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getReferenceAtCaretPositionWithAssertion"));
        }
        return psiReference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        List<IntentionAction> list = this.getAvailableIntentions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        List<HighlightInfo> infos = this.doHighlighting();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (HighlightInfo info : infos) {
            if (info.quickFixActionRanges == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                actions.add(((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction());
            }
        }
        ArrayList<IntentionAction> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAllQuickFixes"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        PsiFile file = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageUtil.getTopLevelFile((PsiElement)file);
        }
        List<IntentionAction> list = CodeInsightTestFixtureImpl.getAvailableIntentions(editor, file);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        return list;
    }

    @Override
    public List<IntentionAction> filterAvailableIntentions(final @NotNull String hint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "filterAvailableIntentions"));
        }
        List<IntentionAction> availableIntentions = this.getAvailableIntentions();
        return ContainerUtil.findAll(availableIntentions, (Condition)new Condition<IntentionAction>(){

            public boolean value(IntentionAction intentionAction) {
                return intentionAction.getText().startsWith(hint);
            }
        });
    }

    @Override
    public IntentionAction findSingleIntention(@NotNull String hint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findSingleIntention"));
        }
        List<IntentionAction> list = this.filterAvailableIntentions(hint);
        if (list.isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]"));
        } else if (list.size() > 1) {
            Assert.fail((String)("Too many intention found for \"" + hint + "\": [" + StringUtil.join(list, INTENTION_NAME_FUN, (String)", ") + "]"));
        }
        return UsefulTestCase.assertOneElement(list);
    }

    @Override
    public IntentionAction getAvailableIntention(String intentionName, String ... filePaths) {
        List<IntentionAction> intentions = this.getAvailableIntentions(filePaths);
        return CodeInsightTestUtil.findIntentionByText(intentions, intentionName);
    }

    @Override
    public void launchAction(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "launchAction"));
        }
        ShowIntentionActionsHandler.chooseActionAndInvoke(this.getFile(), this.getEditor(), action, action.getText());
    }

    @Override
    public void testCompletion(@NonNls String[] filesBefore, @NonNls String fileAfter) {
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(String[] filesBefore, String toType, String fileAfter) {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        for (int i = 0; i < toType.length(); ++i) {
            this.type(toType.charAt(i));
        }
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)((Object)this.myPsiManager));
    }

    @Override
    public void testCompletion(String fileBefore, String fileAfter, String ... additionalFiles) {
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NonNls String fileBefore, String toType, @NonNls String fileAfter, String ... additionalFiles) {
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(String fileBefore, String ... expectedItems) {
        this.assertInitialized();
        List<String> result = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result);
        UsefulTestCase.assertSameElements(result, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        Object[] elements = this.getLookupElements();
        if (elements == null) {
            return null;
        }
        return ContainerUtil.map((Object[])elements, (Function)new Function<LookupElement, String>(){

            public String fun(LookupElement lookupItem) {
                return lookupItem.getLookupString();
            }
        });
    }

    @Override
    public void finishLookup(final char completionChar) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                ((LookupImpl)LookupManager.getActiveLookup(CodeInsightTestFixtureImpl.this.getEditor())).finishLookup(completionChar);
            }
        }, null, null);
    }

    @Override
    public void testRename(String fileBefore, String fileAfter, String newName, String ... additionalFiles) {
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore)));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRename(String fileAfter, String newName) {
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        Editor editor = this.getCompletionEditor();
        int findTargetFlags = 3;
        PsiElement element = TargetElementUtilBase.findTargetElement(editor, findTargetFlags);
        if (element == null && editor instanceof EditorWindow) {
            element = TargetElementUtilBase.findTargetElement(((EditorWindow)editor).getDelegate(), findTargetFlags);
        }
        assert (element != null) : "element not found in file " + this.myFile.getName() + " at caret position, offset " + this.myEditor.getCaretModel().getOffset() + "\"" + " psi structure: " + DebugUtil.psiToString((PsiElement)this.myFile, true, true);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getElementAtCaret"));
        }
        return psiElement;
    }

    @Override
    public void renameElementAtCaret(String newName) {
        this.renameElement(this.getElementAtCaret(), newName);
    }

    @Override
    public void renameElementAtCaretUsingHandler(final @NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "renameElementAtCaretUsingHandler"));
        }
        final DataContext editorContext = ((EditorEx)this.myEditor).getDataContext();
        DataContext context = new DataContext(){

            public Object getData(@NonNls String dataId) {
                return PsiElementRenameHandler.DEFAULT_NAME.getName().equals(dataId) ? newName : editorContext.getData(dataId);
            }
        };
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context);
        assert (renameHandler != null) : "No handler for this context";
        renameHandler.invoke(this.getProject(), this.myEditor, this.getFile(), context);
    }

    @Override
    public void renameElement(PsiElement element, String newName) {
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(PsiElement element, String newName, boolean searchInComments, boolean searchTextOccurrences) {
        PsiElement substitution = RenamePsiElementProcessor.forElement(element).substituteElementToRename(element, this.myEditor);
        if (substitution == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public <T extends PsiElement> T findElementByText(String text, Class<T> elementClass) {
        int pos = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getFile()).getText().indexOf(text);
        assert (pos >= 0) : "text not found in file";
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(pos), elementClass);
    }

    @Override
    public void type(final char c) {
        this.assertInitialized();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                final EditorActionManager actionManager = EditorActionManager.getInstance();
                if (c == '\b') {
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorBackSpace");
                    return;
                }
                if (c == '\n') {
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("EditorChooseLookupItem")) {
                        return;
                    }
                    CodeInsightTestFixtureImpl.this.performEditorAction("EditorEnter");
                    return;
                }
                if (c == '\t') {
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("EditorChooseLookupItemReplace")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("ExpandLiveTemplateByTab")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("NextTemplateVariable")) {
                        return;
                    }
                    if (CodeInsightTestFixtureImpl.this._performEditorAction("EditorTab")) {
                        return;
                    }
                }
                if (c == '\r' && CodeInsightTestFixtureImpl.this._performEditorAction("EditorChooseLookupItemCompleteStatement")) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(CodeInsightTestFixtureImpl.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().setCurrentCommandGroupId((Object)CodeInsightTestFixtureImpl.this.myEditor.getDocument());
                        ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, CodeInsightTestFixtureImpl.this.getEditorDataContext());
                        actionManager.getTypedAction().actionPerformed(CodeInsightTestFixtureImpl.this.getEditor(), c, CodeInsightTestFixtureImpl.this.getEditorDataContext());
                    }
                }, null, (Object)DocCommandGroupId.noneGroupId((Document)CodeInsightTestFixtureImpl.this.myEditor.getDocument()));
            }
        });
    }

    private DataContext getEditorDataContext() {
        return ((EditorEx)this.myEditor).getDataContext();
    }

    @Override
    public void type(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.type(s.charAt(i));
        }
    }

    @Override
    public void performEditorAction(String actionId) {
        this.assertInitialized();
        this._performEditorAction(actionId);
    }

    private boolean _performEditorAction(String actionId) {
        final DataContext dataContext = this.getEditorDataContext();
        final ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        final AnAction action = managerEx.getAction(actionId);
        final AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)managerEx, 0);
        return (Boolean)WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                action.update(event);
                if (!event.getPresentation().isEnabled()) {
                    return false;
                }
                managerEx.fireBeforeActionPerformed(action, dataContext, event);
                action.actionPerformed(event);
                managerEx.fireAfterActionPerformed(action, dataContext, event);
                return true;
            }
        });
    }

    @Override
    public Presentation testAction(AnAction action) {
        TestActionEvent e = new TestActionEvent(action);
        action.beforeActionPerformedUpdate((AnActionEvent)e);
        if (e.getPresentation().isEnabled() && e.getPresentation().isVisible()) {
            action.actionPerformed((AnActionEvent)e);
        }
        return e.getPresentation();
    }

    @Override
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        this.assertInitialized();
        this.configureByFiles(fileNames);
        PsiElement targetElement = TargetElementUtilBase.findTargetElement(this.getEditor(), 3);
        assert (targetElement != null) : "Cannot find referenced element";
        return this.findUsages(targetElement);
    }

    @Override
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findUsages"));
        }
        Project project = this.getProject();
        FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        assert (handler != null) : "Cannot find handler for: " + targetElement;
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        FindUsagesOptions options = handler.getFindUsagesOptions(null);
        for (PsiElement psiElement : psiElements) {
            handler.processElementUsages(psiElement, (Processor<UsageInfo>)processor, options);
        }
        return processor.getResults();
    }

    @Override
    public RangeHighlighter[] testHighlightUsages(String ... files) {
        this.configureByFiles(files);
        this.testAction(new HighlightUsagesAction());
        Editor editor = this.getEditor();
        return editor.getMarkupModel().getAllHighlighters();
    }

    @Override
    public void moveFile(final @NonNls String filePath, final @NonNls String to, final String ... additionalFiles) {
        this.assertInitialized();
        final Project project = this.getProject();
        new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath)));
                VirtualFile file = CodeInsightTestFixtureImpl.this.findFileInTempDir(to);
                assert (file != null) : "Directory " + to + " not found";
                assert (file.isDirectory()) : to + " is not a directory";
                PsiDirectory directory = CodeInsightTestFixtureImpl.this.myPsiManager.findDirectory(file);
                new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{CodeInsightTestFixtureImpl.this.myFile}, directory, false, false, null, null).run();
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public GutterMark findGutter(String filePath) {
        RangeHighlighter[] highlighters;
        this.configureByFilesInner(filePath);
        int offset = this.myEditor.getCaretModel().getOffset();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            GutterMark renderer;
            if (info.endOffset < offset || info.startOffset > offset || (renderer = info.getGutterIconRenderer()) == null) continue;
            return renderer;
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true).getAllHighlighters()) {
            GutterIconRenderer renderer;
            if (highlighter.getEndOffset() < offset || highlighter.getStartOffset() > offset || (renderer = highlighter.getGutterIconRenderer()) == null) continue;
            return renderer;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<GutterMark> findAllGutters(String filePath) {
        RangeHighlighter[] highlighters;
        Project project = this.getProject();
        TreeMap<Integer, List<GutterMark>> result = new TreeMap<Integer, List<GutterMark>>();
        this.configureByFilesInner(filePath);
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset, result);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), project, true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result);
        }
        List list = ContainerUtil.concat(result.values());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "findAllGutters"));
        }
        return list;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset, SortedMap<Integer, List<GutterMark>> result) {
        if (renderer == null) {
            return;
        }
        List renderers = (List)result.get(offset);
        if (renderers == null) {
            renderers = new SmartList();
            result.put(offset, renderers);
        }
        renderers.add(renderer);
    }

    @Override
    public PsiFile addFileToProject(@NonNls String relativePath, @NonNls String fileText) {
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(final String rootPath, final String relativePath, final String fileText) {
        return (PsiFile)new WriteCommandAction<PsiFile>(this.getProject(), new PsiFile[0]){

            protected void run(Result<PsiFile> result) throws Throwable {
                try {
                    if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                        VirtualFile file = CodeInsightTestFixtureImpl.this.myTempDirFixture.createFile(relativePath, fileText);
                        result.setResult((Object)PsiManager.getInstance((Project)this.getProject()).findFile(file));
                    } else {
                        result.setResult((Object)((HeavyIdeaTestFixture)CodeInsightTestFixtureImpl.this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.getProject()).getModificationTracker()).incCounter();
                }
            }
        }.execute().getResultObject();
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> epName, final T extension) {
        this.assertInitialized();
        final ExtensionPoint extensionPoint = area.getExtensionPoint(epName);
        extensionPoint.registerExtension(extension);
        this.disposeOnTearDown(new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    @Override
    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    public LookupElement[] complete(CompletionType type) {
        return this.complete(type, 1);
    }

    @Override
    public LookupElement[] complete(final CompletionType type, final int invocationCount) {
        this.assertInitialized();
        this.myEmptyLookup = false;
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(CodeInsightTestFixtureImpl.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        final CodeCompletionHandlerBase handler = new CodeCompletionHandlerBase(type){

                            @Override
                            protected void completionFinished(int offset1, int offset2, CompletionProgressIndicator indicator, LookupElement[] items, boolean hasModifiers) {
                                CodeInsightTestFixtureImpl.this.myEmptyLookup = items.length == 0;
                                super.completionFinished(offset1, offset2, indicator, items, hasModifiers);
                            }
                        };
                        final Editor editor = CodeInsightTestFixtureImpl.this.getCompletionEditor();
                        assert (editor != null) : "Editor is null";
                        editor.getCaretModel().runForEachCaret(new CaretAction(){

                            public void perform(Caret caret) {
                                handler.invokeCompletion(CodeInsightTestFixtureImpl.this.getProject(), editor, invocationCount);
                            }
                        });
                        PsiDocumentManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject()).commitAllDocuments();
                    }
                }, null, null);
            }
        });
        return this.getLookupElements();
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile);
    }

    @Override
    @Nullable
    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    @Override
    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookup = this.getLookup();
        if (lookup == null) {
            return this.myEmptyLookup ? LookupElement.EMPTY_ARRAY : null;
        }
        List<LookupElement> list = lookup.getItems();
        return list.toArray(new LookupElement[list.size()]);
    }

    @Override
    public void checkResult(String text) {
        this.checkResult(text, false);
    }

    @Override
    public void checkResult(final String text, final boolean stripTrailingSpaces) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                EditorUtil.fillVirtualSpaceUntilCaret(CodeInsightTestFixtureImpl.this.myEditor);
                CodeInsightTestFixtureImpl.this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(text), CodeInsightTestFixtureImpl.this.getHostFile().getText());
            }
        }.execute();
    }

    @Override
    public void checkResultByFile(String expectedFile) {
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(final String expectedFile, final boolean ignoreTrailingWhitespaces) {
        this.assertInitialized();
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, CodeInsightTestFixtureImpl.this.getHostFile(), ignoreTrailingWhitespaces);
            }
        }.execute().throwException();
    }

    @Override
    public void checkResultByFile(final String filePath, final String expectedFile, final boolean ignoreTrailingWhitespaces) {
        this.assertInitialized();
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Exception {
                String path = filePath.replace(File.separatorChar, '/');
                VirtualFile copy = CodeInsightTestFixtureImpl.this.findFileInTempDir(path);
                if (copy == null) {
                    throw new IllegalArgumentException("could not find results file " + path);
                }
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(copy);
                assert (psiFile != null);
                CodeInsightTestFixtureImpl.this.checkResultByFile(expectedFile, psiFile, ignoreTrailingWhitespaces);
            }
        }.execute().throwException();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CodeInsightTestFixtureImpl.this.myProjectFixture.setUp();
                    CodeInsightTestFixtureImpl.this.myTempDirFixture.setUp();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                CodeInsightTestFixtureImpl.this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject());
                CodeInsightTestFixtureImpl.this.configureInspections((InspectionProfileEntry[])(CodeInsightTestFixtureImpl.this.myInspections == null ? LocalInspectionTool.EMPTY_ARRAY : CodeInsightTestFixtureImpl.this.myInspections));
                DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject());
                daemonCodeAnalyzer.prepareForTest();
                DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
                CodeInsightTestFixtureImpl.ensureIndexesUpToDate(CodeInsightTestFixtureImpl.this.getProject());
                ((StartupManagerImpl)StartupManagerEx.getInstanceEx(CodeInsightTestFixtureImpl.this.getProject())).runPostStartupActivities();
            }
        });
    }

    @Override
    public void tearDown() throws Exception {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                VirtualFile[] openFiles;
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)CodeInsightTestFixtureImpl.this.getProject());
                for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
                CodeInsightTestFixtureImpl.this.myEditor = null;
                CodeInsightTestFixtureImpl.this.myFile = null;
                CodeInsightTestFixtureImpl.this.myPsiManager = null;
                CodeInsightTestFixtureImpl.access$1202(CodeInsightTestFixtureImpl.this, null);
                CodeInsightTestFixtureImpl.this.myAvailableTools.clear();
                try {
                    CodeInsightTestFixtureImpl.this.myProjectFixture.tearDown();
                    CodeInsightTestFixtureImpl.this.myTempDirFixture.tearDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        super.tearDown();
    }

    private void enableInspectionTool(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "enableInspectionTool"));
        }
        InspectionToolWrapper toolWrapper = InspectionToolRegistrar.wrapTool(tool);
        String shortName = tool.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            String id = tool instanceof LocalInspectionTool ? ((LocalInspectionTool)tool).getID() : shortName;
            HighlightDisplayKey.register((String)shortName, (String)toolWrapper.getDisplayName(), (String)id);
        }
        this.myAvailableTools.put(shortName, toolWrapper);
    }

    private void configureInspections(@NotNull InspectionProfileEntry[] tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInspections"));
        }
        for (InspectionProfileEntry tool : tools) {
            this.enableInspectionTool(tool);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(PROFILE){

            @Override
            @NotNull
            public ModifiableModel getModifiableModel() {
                this.mySource = this;
                20 v0 = this;
                if (v0 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getModifiableModel"));
                }
                return v0;
            }

            @Override
            @NotNull
            public InspectionToolWrapper[] getInspectionTools(PsiElement element) {
                Collection tools = CodeInsightTestFixtureImpl.this.myAvailableTools.values();
                InspectionToolWrapper[] inspectionToolWrapperArray = tools.toArray(new InspectionToolWrapper[tools.size()]);
                if (inspectionToolWrapperArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getInspectionTools"));
                }
                return inspectionToolWrapperArray;
            }

            @Override
            public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getToolById"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getToolById"));
                }
                if (CodeInsightTestFixtureImpl.this.myAvailableTools.containsKey(id)) {
                    return (InspectionToolWrapper)CodeInsightTestFixtureImpl.this.myAvailableTools.get(id);
                }
                return super.getToolById(id, element);
            }

            @Override
            @NotNull
            public List<Tools> getAllEnabledInspectionTools(Project project) {
                ArrayList<Tools> result = new ArrayList<Tools>();
                for (InspectionToolWrapper toolWrapper : this.getInspectionTools((PsiElement)CodeInsightTestFixtureImpl.this.getFile())) {
                    result.add(new ToolsImpl(toolWrapper, toolWrapper.getDefaultLevel(), true));
                }
                ArrayList<Tools> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getAllEnabledInspectionTools"));
                }
                return arrayList;
            }

            @Override
            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return key != null && key.toString() != null && CodeInsightTestFixtureImpl.this.myAvailableTools.containsKey(key.toString());
            }

            @Override
            public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getInspectionTool"));
                }
                return (InspectionToolWrapper)CodeInsightTestFixtureImpl.this.myAvailableTools.get(shortName);
            }

            @Override
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getErrorLevel"));
                }
                InspectionToolWrapper toolWrapper = (InspectionToolWrapper)CodeInsightTestFixtureImpl.this.myAvailableTools.get(key.toString());
                return toolWrapper == null ? HighlightDisplayLevel.WARNING : toolWrapper.getDefaultLevel();
            }

            @Override
            public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getInspectionTool"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$20", "getInspectionTool"));
                }
                return (InspectionToolWrapper)CodeInsightTestFixtureImpl.this.myAvailableTools.get(shortName);
            }
        };
        final InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile(profile);
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                inspectionProfileManager.deleteProfile(CodeInsightTestFixtureImpl.PROFILE);
            }
        });
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProjectProfileManager.getInstance(this.getProject()).updateProfile(profile);
        InspectionProjectProfileManager.getInstance(this.getProject()).setProjectProfile(profile.getName());
    }

    private PsiFile[] configureByFilesInner(String ... filePaths) {
        this.assertInitialized();
        this.myFile = null;
        this.myEditor = null;
        PsiFile[] psiFiles = new PsiFile[filePaths.length];
        for (int i = filePaths.length - 1; i >= 0; --i) {
            psiFiles[i] = this.configureByFileInner(filePaths[i]);
        }
        return psiFiles;
    }

    @Override
    public PsiFile configureByFile(String file) {
        this.configureByFilesInner(file);
        return this.myFile;
    }

    @Override
    public PsiFile[] configureByFiles(String ... files) {
        return this.configureByFilesInner(files);
    }

    @Override
    public PsiFile configureByText(final FileType fileType, @NonNls String text) {
        this.assertInitialized();
        final String extension = fileType.getDefaultExtension();
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                protected void run(Result result) throws Exception {
                    fileTypeManager.associateExtension(fileType, extension);
                }
            }.execute();
        }
        String fileName = "aaa." + extension;
        return this.configureByText(fileName, text);
    }

    @Override
    public PsiFile configureByText(final String fileName, final @NonNls String text) {
        this.assertInitialized();
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                VirtualFile vFile;
                if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    vFile = root.findOrCreateChildData((Object)this, fileName);
                } else if (CodeInsightTestFixtureImpl.this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    File tempFile = ((TempDirTestFixtureImpl)CodeInsightTestFixtureImpl.this.myTempDirFixture).createTempFile(fileName);
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
                } else {
                    vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(CodeInsightTestFixtureImpl.this.getTempDirPath(), fileName));
                }
                CodeInsightTestFixtureImpl.this.prepareVirtualFile(vFile);
                Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText((VirtualFile)vFile, (String)text);
                CodeInsightTestFixtureImpl.this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
            }
        }.execute();
        return this.myFile;
    }

    @Override
    public Document getDocument(PsiFile file) {
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
    }

    private PsiFile configureByFileInner(@NonNls String filePath) {
        this.assertInitialized();
        VirtualFile file = this.copyFileToProject(filePath);
        return this.configureByFileInner(file);
    }

    @Override
    public PsiFile configureFromTempProjectFile(String filePath) {
        VirtualFile fileInTempDir = this.findFileInTempDir(filePath);
        if (fileInTempDir == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(VirtualFile f) {
        this.configureByFileInner(f);
    }

    private PsiFile configureByFileInner(VirtualFile copy) {
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy));
    }

    private PsiFile configureInner(final @NotNull VirtualFile copy, final SelectionAndCaretMarkupLoader loader) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "configureInner"));
        }
        this.assertInitialized();
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            public void run() {
                try {
                    copy.setBinaryContent(loader.newFileText.getBytes(copy.getCharset()), 0L, 0L, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                CodeInsightTestFixtureImpl.this.myFile = CodeInsightTestFixtureImpl.this.myPsiManager.findFile(copy);
                CodeInsightTestFixtureImpl.this.myEditor = CodeInsightTestFixtureImpl.this.createEditor(copy);
                assert (CodeInsightTestFixtureImpl.this.myEditor != null) : "Editor couldn't be created for file: " + copy.getPath() + ", use copyFileToProject(..) method for this file instead of configureByFile(..)";
                EditorTestUtil.setCaretsAndSelection(CodeInsightTestFixtureImpl.this.myEditor, loader.caretState);
                Module module = CodeInsightTestFixtureImpl.this.getModule();
                if (module != null) {
                    for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                        ((FacetManagerListener)module.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
                    }
                }
                if (CodeInsightTestFixtureImpl.this.myCaresAboutInjection) {
                    CodeInsightTestFixtureImpl.this.setupEditorForInjectedLanguage();
                }
            }
        }.execute().throwException();
        return this.myFile;
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "prepareVirtualFile"));
        }
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile);
        if (editor instanceof EditorWindow) {
            this.myFile = ((EditorWindow)editor).getInjectedFile();
            this.myEditor = editor;
        }
    }

    @Override
    public VirtualFile findFileInTempDir(String filePath) {
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        assert (copy != null) : "file " + fullPath + " not found";
        return copy;
    }

    @Nullable
    private Editor createEditor(VirtualFile file) {
        Project project = this.getProject();
        FileEditorManager instance = FileEditorManager.getInstance((Project)project);
        if (file.getFileType().isBinary()) {
            return null;
        }
        return instance.openTextEditor(new OpenFileDescriptor(project, file, 0), false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) throws Exception {
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, this.getHostFile());
        data.init();
        return this.collectAndCheckHighlighting(data);
    }

    private PsiFile getHostFile() {
        return InjectedLanguageUtil.getTopLevelFile((PsiElement)this.myFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data) {
        List<HighlightInfo> infos;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "collectAndCheckHighlighting"));
        }
        Project project = this.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFileImpl file = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file.calcTreeElement();
        if (!DumbService.isDumb((Project)project)) {
            CacheManager.SERVICE.getInstance(project).getFilesWithWord(XXX, (short)2, GlobalSearchScope.allScope((Project)project), true);
        }
        long start = System.currentTimeMillis();
        ((PsiManagerImpl)PsiManager.getInstance((Project)project)).setAssertOnFileLoadingFilter(this.myJavaFilesFilter, this.myTestRootDisposable);
        try {
            infos = this.doHighlighting();
            CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.myTestRootDisposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data.checkResult(infos, file.getText());
        hardRefToFileElement.hashCode();
        return elapsed;
    }

    private static void removeDuplicatedRangesForInjected(List<HighlightInfo> infos) {
        Collections.sort(infos, new Comparator<HighlightInfo>(){

            @Override
            public int compare(HighlightInfo o1, HighlightInfo o2) {
                int i = o2.startOffset - o1.startOffset;
                return i != 0 ? i : o1.getSeverity().myVal - o2.getSeverity().myVal;
            }
        });
        HighlightInfo prevInfo = null;
        Iterator<HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        Project project = this.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageUtil.getTopLevelFile((PsiElement)file);
        }
        List<HighlightInfo> list = CodeInsightTestFixtureImpl.instantiateAndRun(file, editor, ArrayUtil.EMPTY_INT_ARRAY, this.myAllowDirt);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doHighlighting"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(final HighlightSeverity minimalSeverity) {
        List list = ContainerUtil.filter(this.doHighlighting(), (Condition)new Condition<HighlightInfo>(){

            public boolean value(HighlightInfo info) {
                return info.getSeverity().compareTo(minimalSeverity) >= 0;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doHighlighting"));
        }
        return list;
    }

    @NotNull
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file, @NotNull Editor editor, @NotNull int[] toIgnore, boolean canChangeDocument) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
        }
        Project project = file.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        ProcessCanceledException exception = null;
        for (int i = 0; i < 100; ++i) {
            List<HighlightInfo> list;
            try {
                List<HighlightInfo> infos = codeAnalyzer.runPasses(file, editor.getDocument(), textEditor, toIgnore, canChangeDocument, null);
                infos.addAll(DaemonCodeAnalyzerEx.getInstanceEx(project).getFileLevelHighlights(project, file));
                list = infos;
            }
            catch (ProcessCanceledException e) {
                exception = e;
                continue;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "instantiateAndRun"));
            }
            return list;
        }
        throw exception;
    }

    public static void ensureIndexesUpToDate(Project project) {
        if (!DumbService.isDumb((Project)project)) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, null);
            FileBasedIndex.getInstance().ensureUpToDate(TodoIndex.NAME, project, null);
        }
    }

    @Override
    public String getTestDataPath() {
        return this.myTestDataPath;
    }

    @Override
    public Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public int getCaretOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile;
    }

    public static List<IntentionAction> getAvailableIntentions(final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "getAvailableIntentions"));
        }
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<IntentionAction>>(){

            public List<IntentionAction> compute() {
                return CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor, file);
            }
        });
    }

    private static List<IntentionAction> doGetAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doGetAvailableIntentions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "doGetAvailableIntentions"));
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file, intentions, -1);
        ArrayList<HighlightInfo.IntentionActionDescriptor> descriptors = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        descriptors.addAll(intentions.intentionsToShow);
        descriptors.addAll(intentions.errorFixesToShow);
        descriptors.addAll(intentions.inspectionFixesToShow);
        descriptors.addAll(intentions.guttersToShow);
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        List<HighlightInfo> infos = DaemonCodeAnalyzerEx.getInstanceEx(file.getProject()).getFileLevelHighlights(file.getProject(), file);
        for (HighlightInfo info : infos) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (!actionInGroup.getAction().isAvailable(file.getProject(), editor, file)) continue;
                descriptors.add(actionInGroup);
            }
        }
        for (HighlightInfo.IntentionActionDescriptor descriptor : descriptors) {
            result.add(descriptor.getAction());
            List<IntentionAction> options = descriptor.getOptions(element, editor);
            if (options == null) continue;
            for (IntentionAction option : options) {
                if (!option.isAvailable(file.getProject(), editor, file)) continue;
                result.add(option);
            }
        }
        return result;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "allowTreeAccessForFile"));
        }
        this.myJavaFilesFilter.allowTreeAccessForFile(file);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        this.myJavaFilesFilter.allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NonNls String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) throws IOException {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl", "checkResultByFile"));
        }
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret(this.myEditor);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        String fileText = originalFile.getText();
        String path = this.getTestDataPath() + "/" + expectedFile;
        VirtualFile virtualFile = originalFile.getVirtualFile();
        String charset = virtualFile == null ? null : virtualFile.getCharset().name();
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path, charset), fileText);
    }

    private void checkResult(String expectedFile, boolean stripTrailingSpaces, SelectionAndCaretMarkupLoader loader, String actualText) {
        this.assertInitialized();
        Project project = this.getProject();
        PsiFile file = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageUtil.getTopLevelFile((PsiElement)file);
        }
        ((PostprocessReformattingAspect)project.getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (stripTrailingSpaces) {
            actualText = this.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String newFileText1 = loader.newFileText;
        if (stripTrailingSpaces) {
            newFileText1 = this.stripTrailingSpaces(newFileText1);
        }
        if (!Comparing.equal((String)newFileText1, (String)(actualText = StringUtil.convertLineSeparators((String)actualText)))) {
            if (loader.filePath != null) {
                throw new FileComparisonFailure(expectedFile, newFileText1, actualText, loader.filePath);
            }
            throw new ComparisonFailure(expectedFile, newFileText1, actualText);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor, loader.caretState, expectedFile);
    }

    private String stripTrailingSpaces(String actualText) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        actualText = document.getText();
        return actualText;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    public String getFoldingDescription(boolean withCollapseStatus) {
        CodeFoldingManager.getInstance(this.getProject()).buildInitialFoldings(this.myEditor);
        FoldingModel model = this.myEditor.getFoldingModel();
        FoldRegion[] foldingRegions = model.getAllFoldRegions();
        LinkedList<Border> borders = new LinkedList<Border>();
        for (FoldRegion region : foldingRegions) {
            borders.add(new Border(true, region.getStartOffset(), region.getPlaceholderText(), region.isExpanded()));
            borders.add(new Border(false, region.getEndOffset(), "", region.isExpanded()));
        }
        Collections.sort(borders);
        StringBuilder result = new StringBuilder(this.myEditor.getDocument().getText());
        for (Border border : borders) {
            result.insert(border.getOffset(), border.isSide() ? "<fold text='" + border.getText() + "'" + (withCollapseStatus ? " expand='" + border.isExpanded() + "'" : "") + ">" : END_FOLD);
        }
        return result.toString();
    }

    private void testFoldingRegions(String verificationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        try {
            expectedContent = FileUtil.loadFile((File)new File(verificationFileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace((String)expectedContent, (String)"\r", (String)"");
        String cleanContent = expectedContent.replaceAll(START_FOLD, "").replaceAll(END_FOLD, "");
        this.configureByText(FileTypeManager.getInstance().getFileTypeByFileName(verificationFileName), cleanContent);
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        Assert.assertEquals((String)expectedContent, (String)actual);
    }

    @Override
    public void testFoldingWithCollapseStatus(String verificationFileName) {
        this.testFoldingRegions(verificationFileName, true);
    }

    @Override
    public void testFolding(String verificationFileName) {
        this.testFoldingRegions(verificationFileName, false);
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        LookupImpl lookup = this.getLookup();
        Assert.assertNotNull((Object)lookup);
        JList list = lookup.getList();
        List<String> strings = this.getLookupElementStrings();
        assert (strings != null);
        List<String> actual = strings.subList(0, Math.min(expected.length, strings.size()));
        if (!((Object)actual).equals(Arrays.asList(expected))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights(lookup), expected);
        }
        if (selected != list.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights(lookup));
        }
        Assert.assertEquals((int)selected, (int)list.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(Consumer<StructureViewComponent> consumer) {
        assert (this.myFile != null) : "configure first";
        VirtualFile vFile = this.myFile.getVirtualFile();
        assert (vFile != null) : "no virtual file for " + this.myFile;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(vFile);
        assert (fileEditor != null) : "editor not opened for " + vFile;
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.myFile);
        assert (builder != null) : "no builder for " + this.myFile;
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.myProjectFixture.getProject());
            consumer.consume((Object)component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.myCaresAboutInjection = caresAboutInjection;
    }

    @Override
    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.myEditor.getDocument()).getDelegate();
            this.myFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
            this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
        }
    }

    static /* synthetic */ InspectionProfileEntry[] access$1202(CodeInsightTestFixtureImpl x0, InspectionProfileEntry[] x1) {
        x0.myInspections = x1;
        return x1;
    }

    private class Border
    implements Comparable<Border> {
        public static final boolean LEFT = true;
        public static final boolean RIGHT = false;
        public boolean mySide;
        public int myOffset;
        public String myText;
        public boolean myIsExpanded;

        private Border(boolean side, int offset, String text, boolean isExpanded) {
            this.mySide = side;
            this.myOffset = offset;
            this.myText = text;
            this.myIsExpanded = isExpanded;
        }

        public boolean isExpanded() {
            return this.myIsExpanded;
        }

        public boolean isSide() {
            return this.mySide;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public String getText() {
            return this.myText;
        }

        @Override
        public int compareTo(Border o) {
            return this.getOffset() < o.getOffset() ? 1 : -1;
        }
    }

    static class SelectionAndCaretMarkupLoader {
        final String filePath;
        final String newFileText;
        final EditorTestUtil.CaretAndSelectionState caretState;

        static SelectionAndCaretMarkupLoader fromFile(String path, String charset) throws IOException {
            return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(path), (String)charset)), path);
        }

        static SelectionAndCaretMarkupLoader fromFile(VirtualFile file) {
            String text;
            try {
                text = VfsUtilCore.loadText((VirtualFile)file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)text), file.getPath());
        }

        static SelectionAndCaretMarkupLoader fromText(String text) {
            return new SelectionAndCaretMarkupLoader(text, null);
        }

        private SelectionAndCaretMarkupLoader(String fileText, String filePath) {
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newFileText = document.getText();
        }
    }
}

