/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    public static VirtualFile createFile(VirtualFile root, String relativePath) {
        return VfsTestUtil.createFile(root, relativePath, "");
    }

    public static VirtualFile createFile(VirtualFile root, String relativePath, String text) {
        return VfsTestUtil.createFileOrDir(root, relativePath, text, false);
    }

    public static VirtualFile createDir(VirtualFile root, String relativePath) {
        return VfsTestUtil.createFileOrDir(root, relativePath, "", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VirtualFile createFileOrDir(VirtualFile root, String relativePath, String text, boolean dir) {
        VirtualFile virtualFile;
        AccessToken token = WriteAction.start();
        try {
            VirtualFile file;
            VirtualFile parent = root;
            Assert.assertNotNull((Object)parent);
            StringTokenizer parents = new StringTokenizer(PathUtil.getParentPath((String)relativePath), "/");
            while (parents.hasMoreTokens()) {
                String name = parents.nextToken();
                VirtualFile child = parent.findChild(name);
                if (child == null || !child.isValid()) {
                    child = parent.createChildDirectory(VfsTestUtil.class, name);
                }
                parent = child;
            }
            parent.getChildren();
            if (dir) {
                file = parent.createChildDirectory(VfsTestUtil.class, PathUtil.getFileName((String)relativePath));
            } else {
                file = parent.createChildData(VfsTestUtil.class, PathUtil.getFileName((String)relativePath));
                if (!text.isEmpty()) {
                    VfsUtil.saveText((VirtualFile)file, (String)text);
                }
            }
            virtualFile = file;
        }
        catch (Throwable throwable) {
            try {
                token.finish();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        token.finish();
        return virtualFile;
    }

    public static void clearContent(VirtualFile file) {
        Assert.assertNotNull((Object)file);
        try {
            VfsUtil.saveText((VirtualFile)file, (String)"");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void overwriteTestData(String filePath, String actual) {
        try {
            FileUtil.writeToFile((File)new File(filePath), (String)actual);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

