/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TempFiles {
    private final Collection<File> myFilesToDelete;

    public TempFiles(@NotNull Collection<File> filesToDelete) {
        if (filesToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "<init>"));
        }
        this.myFilesToDelete = filesToDelete;
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        return TempFiles.getVFileByFile(this.createTempFile(prefix));
    }

    @Nullable
    public VirtualFile createVFile(@NotNull String prefix, String postfix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "createVFile"));
        }
        return TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
    }

    public File createTempFile(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "createTempFile"));
        }
        return this.createTempFile(prefix, "_Temp_File_");
    }

    public File createTempFile(@NotNull String prefix, String postfix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "createTempFile"));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)prefix, (String)postfix);
            this.tempFileCreated(tempFile);
            TempFiles.getVFileByFile(tempFile);
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tempFileCreated(@NotNull File tempFile) {
        if (tempFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "tempFileCreated"));
        }
        this.myFilesToDelete.add(tempFile);
    }

    @Nullable
    public static VirtualFile getVFileByFile(@NotNull File tempFile) {
        if (tempFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "getVFileByFile"));
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
    }

    public File createTempDir() {
        return this.createTempDir("dir");
    }

    private File createTempDir(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "createTempDir"));
        }
        try {
            File dir = FileUtil.createTempDirectory((String)prefix, (String)"test", (boolean)false);
            this.tempFileCreated(dir);
            TempFiles.getVFileByFile(dir);
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public VirtualFile createTempVDir() {
        return this.createTempVDir("dir");
    }

    @Nullable
    public VirtualFile createTempVDir(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/TempFiles", "createTempVDir"));
        }
        return TempFiles.getVFileByFile(this.createTempDir(prefix));
    }

    public String createTempPath() {
        File tempFile = this.createTempFile("xxx");
        String absolutePath = tempFile.getAbsolutePath();
        Assert.assertTrue((String)absolutePath, (boolean)tempFile.delete());
        return absolutePath;
    }

    public void deleteAll() {
        for (File file : this.myFilesToDelete) {
            if (FileUtil.delete((File)file)) continue;
            file.deleteOnExit();
        }
    }

    public VirtualFile createVFile(VirtualFile parentDir, String name, String text) {
        try {
            VirtualFile virtualFile = parentDir.createChildData((Object)this, name);
            VfsUtil.saveText((VirtualFile)virtualFile, (String)(text + "\n"));
            return virtualFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

