/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplicationEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public abstract class FlyIdeaTestCase
extends TestCase {
    private Disposable myRootDisposable;
    private File myTempDir;

    protected void setUp() throws Exception {
        final Application old = ApplicationManagerEx.getApplication();
        this.myRootDisposable = Disposer.newDisposable();
        MockApplicationEx app = new MockApplicationEx(this.getRootDisposable()){

            @Override
            @NotNull
            public Future<?> executeOnPooledThread(@NotNull Runnable action) {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/testFramework/FlyIdeaTestCase$1", "executeOnPooledThread"));
                }
                Future future = old != null ? old.executeOnPooledThread(action) : super.executeOnPooledThread(action);
                if (future == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/FlyIdeaTestCase$1", "executeOnPooledThread"));
                }
                return future;
            }
        };
        ApplicationManager.setApplication((Application)app, (Disposable)this.myRootDisposable);
    }

    public File getTempDir() throws IOException {
        if (this.myTempDir == null) {
            this.myTempDir = FileUtil.createTempDirectory((String)this.getName(), (String)((Object)((Object)this)).getClass().getName(), (boolean)false);
        }
        return this.myTempDir;
    }

    public Disposable getRootDisposable() {
        return this.myRootDisposable;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.myTempDir != null) {
            FileUtil.asyncDelete((File)this.myTempDir);
        }
        Disposer.dispose((Disposable)this.myRootDisposable);
    }
}

