/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UnitBitSet {
    public static final int MAX_CHARS_IN_WORD = 64;
    public static final int MAX_UNIT_VALUE = 255;
    final byte[] b;
    private final Alphabet alpha;

    public UnitBitSet(@NotNull byte[] indices, @NotNull Alphabet alphabet) {
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/compress/UnitBitSet", "<init>"));
        }
        if (alphabet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/spellchecker/compress/UnitBitSet", "<init>"));
        }
        this.b = indices;
        this.alpha = alphabet;
    }

    public int getUnitValue(int number) {
        int r = this.b[number] & 0xFF;
        assert (r >= 0 && r <= 255) : "invalid unit value";
        return r;
    }

    public void setUnitValue(int number, int value) {
        assert (value >= 0) : "unit value is negative" + value;
        assert (value <= 255) : "unit value is too big";
        this.b[number] = (byte)value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnitBitSet)) {
            return false;
        }
        return Arrays.equals(this.b, ((UnitBitSet)obj).b);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (byte aB : this.b) {
            s.append(Integer.toHexString(aB & 0xFF));
        }
        return s.toString();
    }

    @NotNull
    public byte[] pack() {
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(this.alpha.getLastIndexUsed());
        assert (meaningfulBits <= 8);
        byte[] result = new byte[(this.b.length * meaningfulBits + 7) / 8];
        int byteNumber = 0;
        int bitOffset = 0;
        for (byte index : this.b) {
            int bitsToChip = Math.min(8 - bitOffset, meaningfulBits);
            int n = byteNumber++;
            result[n] = (byte)(result[n] | (index & (1 << bitsToChip) - 1) << bitOffset);
            int bitsLeft = meaningfulBits - bitsToChip;
            if (bitsLeft > 0) {
                int n2 = byteNumber;
                result[n2] = (byte)(result[n2] | index >> bitsToChip & (1 << bitsLeft) - 1);
                bitOffset = bitsLeft;
                continue;
            }
            bitOffset += bitsToChip;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/UnitBitSet", "pack"));
        }
        return result;
    }

    @NotNull
    public static String decode(@NotNull byte[] packed, @NotNull Alphabet alphabet) {
        int index;
        char letter;
        if (packed == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/compress/UnitBitSet", "decode"));
        }
        if (alphabet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/spellchecker/compress/UnitBitSet", "decode"));
        }
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(alphabet.getLastIndexUsed());
        assert (meaningfulBits <= 8);
        StringBuilder result = new StringBuilder(packed.length * 8 / meaningfulBits);
        int curByte = packed[0];
        int byteIndex = 0;
        int bitOffset = 0;
        while (byteIndex < packed.length && (letter = alphabet.getLetter(index = curByte & (1 << meaningfulBits) - 1)) != '\u0000') {
            result.append(letter);
            curByte >>>= meaningfulBits;
            assert ((bitOffset += meaningfulBits) <= 8);
            if (bitOffset + meaningfulBits <= 8) continue;
            if (++byteIndex == packed.length) break;
            int leftOverBits = 8 - bitOffset;
            curByte = packed[byteIndex] << leftOverBits | curByte & (1 << leftOverBits) - 1;
            bitOffset = -leftOverBits;
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/compress/UnitBitSet", "decode"));
        }
        return string;
    }

    public static int getFirstLetterIndex(byte firstPackedByte, @NotNull Alphabet alphabet) {
        if (alphabet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/spellchecker/compress/UnitBitSet", "getFirstLetterIndex"));
        }
        int meaningfulBits = 32 - Integer.numberOfLeadingZeros(alphabet.getLastIndexUsed());
        assert (meaningfulBits <= 8);
        int index = firstPackedByte & (1 << meaningfulBits) - 1;
        return index;
    }
}

